/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.voting;

import com.teamscale.core.index.ICommitDescriptorSerializer;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.voting.VotingRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@Index(name="voting-records", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED, EStorageOption.BACKUP}, valueClasses={VotingRecord.class})
public class VotingRecordIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "voting-records";
    private static final long NO_VOTE_FOUND_TIMESTAMP = -1L;
    private static final ICommitDescriptorSerializer KEY_SERIALIZER = ICommitDescriptorSerializer.BranchTimestamp.COMPACT;

    public VotingRecordIndex(IStore store) {
        super(store);
    }

    @VisibleForTesting
    public void setVotingRecord(CommitDescriptor commit, VotingRecord record) throws StorageException {
        this.store.put(KEY_SERIALIZER.serialize(commit), StorageUtils.serialize((Serializable)record));
    }

    public Optional<VotingRecord> getVotingRecord(CommitDescriptor commit) throws StorageException {
        return Optional.ofNullable((VotingRecord)StorageUtils.deserialize((byte[])this.store.get(KEY_SERIALIZER.serialize(commit))));
    }

    public boolean isMarkedAsSuccessfullyVoted(CommitDescriptor commit) throws StorageException {
        return this.getVotingRecord(commit).map(record -> record.getState().isSuccessfulAndComplete()).orElse(false);
    }

    public boolean isMarkedAsSuccessfullyVotedAtTimestampOrNewer(CommitDescriptor commit, long votingEventTimestamp) throws StorageException {
        return this.getVotingRecord(commit).map(record -> record.getState().isSuccessfulAndComplete() && record.getTimestamp().orElse(-1L) >= votingEventTimestamp).orElse(false);
    }

    public boolean isMarkedSuccessfullyVotedWithIncompleteBuild(CommitDescriptor commit, List<MergeRequestBuildJob> currentBuildJobs) throws StorageException {
        return this.getVotingRecord(commit).map(record -> record.getState() == VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD && Objects.equals(record.getRelevantBuildJobs(), currentBuildJobs)).orElse(false);
    }

    public PairList<CommitDescriptor, VotingRecord> getAllRecordsForBranch(String branchName) throws StorageException {
        PairList keysAndValues = this.store.getEntriesStartingWith(branchName);
        PairList results = new PairList(keysAndValues.size());
        for (Pair value : keysAndValues) {
            CommitDescriptor commit = KEY_SERIALIZER.deserialize((byte[])value.getFirst());
            if (!commit.isOnBranch(branchName)) continue;
            results.add((Object)commit, (Object)((VotingRecord)StorageUtils.deserialize((byte[])((byte[])value.getSecond()))));
        }
        results.sort(Comparator.comparing(ImmutablePair::getFirst));
        return results;
    }

    public @NonNull VotingRecord getNewestRecordForBranch(String branchName) throws StorageException {
        ArrayList keys = new ArrayList();
        this.store.scanKeys(branchName, (IKeyValueCallback)new KeyCollectingCallback(keys));
        CommitDescriptor latestCommit = null;
        for (byte[] key : keys) {
            CommitDescriptor commit = KEY_SERIALIZER.deserialize(key);
            if (!commit.isOnBranch(branchName) || latestCommit != null && commit.getTimestamp() <= latestCommit.getTimestamp()) continue;
            latestCommit = commit;
        }
        if (latestCommit == null) {
            return VotingRecord.unvoted();
        }
        byte[] latestVotingRecord = this.store.get(KEY_SERIALIZER.serialize(latestCommit));
        return (VotingRecord)StorageUtils.deserialize((byte[])latestVotingRecord);
    }

    public PairList<CommitDescriptor, VotingRecord> getAllRecords() throws StorageException {
        PairList keysAndValues = this.store.getEntriesStartingWith("");
        PairList results = new PairList(keysAndValues.size());
        for (Pair value : keysAndValues) {
            results.add((Object)KEY_SERIALIZER.deserialize((byte[])value.getFirst()), (Object)((VotingRecord)StorageUtils.deserialize((byte[])((byte[])value.getSecond()))));
        }
        return results;
    }

    public boolean existingVoteDidNotVoteOnAllPartitions(CommitDescriptor commit, PairList<String, Long> partitionsUpdatedWithCommit) throws StorageException {
        return this.getVotingRecord(commit).map(record -> !record.getPartitionsIncludedInVote().equals(partitionsUpdatedWithCommit.toMap())).orElse(false);
    }
}

