/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metadata;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;

public class MetaDataMetricSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementMetadataIndex metadataIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TokenElementMetadataIndex previousMetadataIndex;
    @DeltaSource(value=TokenElementMetadataIndex.class)
    protected KeyDelta metadataDelta;

    public void execute() throws Exception {
        this.synchronizeAddedChanged();
        this.synchronizeDeleted();
    }

    private void synchronizeAddedChanged() throws StorageException {
        ListMap<String, IFileMetadata> uniformPathWithMetadata = this.metadataIndex.getMetadataForKeys((List<StorageKey>)this.metadataDelta.getAddedOrChangedKeys());
        TwoDimHashMap partitionUniformPathMetadataMap = new TwoDimHashMap();
        for (Map.Entry entry : uniformPathWithMetadata) {
            String uniformPath = (String)entry.getKey();
            for (IFileMetadata fileMetadata : (List)entry.getValue()) {
                MetaDataMetricSynchronizer.collectMetadataMetrics((TwoDimHashMap<String, String, Serializable>)partitionUniformPathMetadataMap, uniformPath, fileMetadata);
            }
        }
        ArrayList<String> partitions = new ArrayList<String>();
        ArrayList<PairList> metricValues = new ArrayList<PairList>();
        for (String partition : partitionUniformPathMetadataMap.getFirstKeys()) {
            partitions.add(partition);
            metricValues.add(PairList.fromMap((Map)partitionUniformPathMetadataMap.getSecondMap((Object)partition)));
        }
        this.metricsIndex.setMetricValues(metricValues, partitions);
    }

    private static void collectMetadataMetrics(TwoDimHashMap<String, String, Serializable> partitionUniformPathMetadataMap, String uniformPath, IFileMetadata fileMetadata) {
        for (Pair metric : fileMetadata.getMetrics()) {
            if (!partitionUniformPathMetadataMap.containsKey((Object)((String)metric.getFirst()), (Object)uniformPath)) {
                partitionUniformPathMetadataMap.putValue((Object)((String)metric.getFirst()), (Object)uniformPath, (Object)((Serializable)metric.getSecond()));
                continue;
            }
            LOGGER.error("The metadata metric {} of the file {} has been defined twice. Only the first value will be used.", metric.getFirst(), (Object)uniformPath);
        }
    }

    private void synchronizeDeleted() throws StorageException {
        ListMap<String, IFileMetadata> uniformPathWithMetadata = this.previousMetadataIndex.getMetadataForKeys((List<StorageKey>)this.metadataDelta.getDeletedKeys());
        Set partitions = ((List)uniformPathWithMetadata.getValues()).stream().map(IFileMetadata::getMetrics).flatMap(pairList -> pairList.getFirstList().stream()).collect(Collectors.toSet());
        this.metricsIndex.removeEntries((Collection)uniformPathWithMetadata.getKeys(), partitions);
    }
}

