/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.DashboardMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion189DashboardParameterTypes
extends DashboardMigratorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern CATEGORY_SEPARATOR = Pattern.compile(", ");
    private static final Set<String> SINGLE_COLOR_PARAMETER_NAMES = Set.of("Ownership color", "Coverage Sources 1 Color", "Coverage Sources 2 Color", "Overlap Color", "Text color", "Filtered methods color", "Minimum reference count color", "Maximum reference count color", "Minimum findings count color", "Maximum findings count color", "Uncovered Color", "Fully Covered Color", "Default Marker Color", "Color", "Outline color");

    public String migrateDescriptorJSON(String descriptorJSON) throws MigrationException {
        return new DashboardMigratorBase.SafeJsonWidgetMigrator(MigrateVersion189DashboardParameterTypes::migrateParameterTypes).migrate(descriptorJSON);
    }

    private static ObjectNode migrateParameterTypes(ObjectNode widget) {
        MigrateVersion189DashboardParameterTypes.mergeCrossAnnotationWithPartitionSelection(widget);
        MigrateVersion189DashboardParameterTypes.removeIsArchitectureField(widget);
        MigrateVersion189DashboardParameterTypes.migrateTypeFilterParameterValues(widget);
        MigrateVersion189DashboardParameterTypes.migrateAssessmentFilterParameterValues(widget);
        MigrateVersion189DashboardParameterTypes.migrateColorParameter(widget);
        MigrateVersion189DashboardParameterTypes.migrateFindingCategories(widget);
        MigrateVersion189DashboardParameterTypes.removeUnusedParameters(widget);
        return widget;
    }

    private static void removeIsArchitectureField(ObjectNode widget) {
        widget.valueStream().forEach(value -> {
            if (value instanceof ObjectNode) {
                ObjectNode object = (ObjectNode)value;
                object.remove("isArchitecture");
            }
        });
    }

    private static void mergeCrossAnnotationWithPartitionSelection(ObjectNode widget) {
        ObjectNode coverageSources;
        if (widget.has("Coverage Sources 1")) {
            coverageSources = (ObjectNode)widget.get("Coverage Sources 1");
            MigrateVersion189DashboardParameterTypes.migrateCoverageSources(coverageSources);
        }
        if (widget.has("Coverage Sources 2")) {
            coverageSources = (ObjectNode)widget.get("Coverage Sources 2");
            MigrateVersion189DashboardParameterTypes.migrateCoverageSources(coverageSources);
        }
        if (widget.has("Coverage Sources")) {
            coverageSources = (ObjectNode)widget.get("Coverage Sources");
            MigrateVersion189DashboardParameterTypes.migrateCoverageSources(coverageSources);
            if (widget.has("Cross-annotate execution")) {
                ArrayNode crossAnnotateExecution = (ArrayNode)widget.get("Cross-annotate execution");
                coverageSources.set("crossAnnotationProjects", (JsonNode)crossAnnotateExecution);
                widget.remove("Cross-annotate execution");
            }
        }
    }

    private static void migrateCoverageSources(ObjectNode coverageSources) {
        coverageSources.set("partitions", coverageSources.get("selectedCoverageSources"));
        coverageSources.remove("selectedCoverageSources");
        coverageSources.set("crossAnnotationProjects", (JsonNode)JsonUtils.getObjectMapper().createArrayNode());
    }

    private static void migrateTypeFilterParameterValues(ObjectNode widget) {
        String oldValue;
        if (!widget.has("Type filter")) {
            return;
        }
        String newValue = switch (oldValue = widget.get("Type filter").asText()) {
            case "Hide false positives and tolerations" -> "EXCLUDED";
            case "Show all" -> "ALL";
            case "Show tolerations" -> "ONLY_TOLERATED";
            case "Show false positives" -> "ONLY_FALSE_POSITIVES";
            case "Show false positives and tolerations" -> "ONLY_BLACKLISTED";
            case "Hide false positives" -> "HIDE_FALSE_POSITIVES";
            case "Hide tolerations" -> "HIDE_TOLERATED";
            default -> (String)CCSMAssert.fail((String)("Unexpected value for 'Type filter': " + oldValue));
        };
        widget.put("Type filter", newValue);
    }

    private static void migrateAssessmentFilterParameterValues(ObjectNode widget) {
        String oldValue;
        if (!widget.has("Assessment filter")) {
            return;
        }
        String newValue = switch (oldValue = widget.get("Assessment filter").asText()) {
            case "Show all" -> "none";
            case "Show only red findings" -> "red";
            case "Show only yellow findings" -> "yellow";
            default -> (String)CCSMAssert.fail((String)("Unexpected value for 'Type filter': " + oldValue));
        };
        widget.put("Assessment filter", newValue);
    }

    private static void migrateColorParameter(ObjectNode widget) {
        SINGLE_COLOR_PARAMETER_NAMES.forEach(parameterName -> {
            if (widget.has(parameterName)) {
                JsonNode parameterValue = widget.get(parameterName);
                if (parameterValue.isArray()) {
                    if (parameterValue.size() != 1) {
                        LOGGER.warn("Expected exactly one color value for parameter '{}', but found: {}", parameterName, (Object)parameterValue.size());
                    }
                    if (!parameterValue.isEmpty()) {
                        widget.put(parameterName, parameterValue.get(0).asText());
                        return;
                    }
                }
                widget.put(parameterName, parameterValue.asText());
            }
        });
    }

    private static void migrateFindingCategories(ObjectNode widget) {
        if (!widget.has("Selected categories")) {
            return;
        }
        String parameterValue = widget.get("Selected categories").asText();
        ArrayNode arrayNode = JsonUtils.getObjectMapper().createArrayNode();
        for (String category : CATEGORY_SEPARATOR.split(parameterValue)) {
            if (category.isEmpty()) continue;
            arrayNode.add(category);
        }
        widget.set("Selected categories", (JsonNode)arrayNode);
    }

    private static void removeUnusedParameters(ObjectNode widget) {
        if (!widget.has("widget-id")) {
            return;
        }
        String widgetId = widget.get("widget-id").asText();
        if ("commit-chart".equals(widgetId)) {
            widget.remove("Upper Y axis value");
            widget.remove("Colors");
        } else if ("tga-trend".equals(widgetId)) {
            widget.remove("Colors");
        }
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V189;
    }
}

