/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.MigrationException;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.NonNull;

public class ProjectVersion55AddBranchingConfigurationMigration
implements IJsonMigrator {
    private static final String BRANCHING_CONFIGURATION_PROPERTY = "branchingConfiguration";
    private static final String BRANCH_CONFIGURATIONS_PROPERTY = "branchConfigurations";
    private static final String BRANCH_PATTERN_PROPERTY = "branchNamePattern";
    private static final String START_DATE_PROPERTY = "startDate";

    @Language(value="JSON")
    public @NonNull String migrate(@Language(value="JSON") String json) throws MigrationException {
        try {
            ObjectNode projectConfiguration = (ObjectNode)JsonUtils.deserializeFromJson((String)json, ObjectNode.class);
            if (projectConfiguration.has(BRANCHING_CONFIGURATION_PROPERTY)) {
                return json;
            }
            ObjectNode branchingConfiguration = ProjectVersion55AddBranchingConfigurationMigration.createBranchingConfigurationWithNoRestriction();
            projectConfiguration.set(BRANCHING_CONFIGURATION_PROPERTY, (JsonNode)branchingConfiguration);
            return JsonUtils.serializeToJSON((Object)projectConfiguration);
        }
        catch (JsonSerializationException e) {
            throw new MigrationException((Throwable)e);
        }
    }

    private static ObjectNode createBranchingConfigurationWithNoRestriction() {
        ObjectMapper mapper = JsonUtils.getObjectMapper();
        ObjectNode branchingConfig = mapper.createObjectNode();
        ArrayNode branchConfigurationsArray = mapper.createArrayNode();
        ObjectNode catchAllBranches = mapper.createObjectNode();
        catchAllBranches.set(BRANCH_PATTERN_PROPERTY, mapper.valueToTree((Object)".*"));
        catchAllBranches.set(START_DATE_PROPERTY, mapper.valueToTree((Object)"no restriction"));
        branchConfigurationsArray.add((JsonNode)catchAllBranches);
        branchingConfig.set(BRANCH_CONFIGURATIONS_PROPERTY, (JsonNode)branchConfigurationsArray);
        return branchingConfig;
    }
}

