/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.intellij.lang.annotations.Language;

public class ProjectVersion56RenameRepositoryIdentifierAndConnectorOptions {
    private static final Map<String, String> OPTION_NAME_RENAMES = Map.of("Repository identifier", "Connector Identifier", "Repository name", "Repository Path", "Prepend repository identifier", "Prepend Connector Identifier", "Issue Connector identifier", "Issue Connector Identifier", "Requirements Connector identifier", "Requirements Connector Identifier", "SCA Connector identifier", "SCA Connector Identifier");

    public static String migrate(@Language(value="JSON") String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion56RenameRepositoryIdentifierAndConnectorOptions::renameConnectorOptions);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration renameConnectorOptions(ConnectorConfiguration connectorConfiguration) {
        String identifierOptionName = connectorConfiguration.getIdentifierOptionName();
        String newIdentifierOptionName = OPTION_NAME_RENAMES.getOrDefault(identifierOptionName, identifierOptionName);
        ConnectorConfiguration migratedConfig = new ConnectorConfiguration(connectorConfiguration.getRawType(), newIdentifierOptionName);
        for (Map.Entry option : Objects.requireNonNull(connectorConfiguration.getOptions()).entrySet()) {
            String optionName = OPTION_NAME_RENAMES.getOrDefault(option.getKey(), (String)option.getKey());
            migratedConfig.setOptionValue(optionName, (String)option.getValue());
        }
        return migratedConfig;
    }
}

