/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v116_dashboards;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v116_dashboards.V116DashboardAccessEntryUnmigrated;
import com.teamscale.index.migration.v116_dashboards.V116DashboardDescriptorBase;
import com.teamscale.index.migration.v116_dashboards.V116DashboardDescriptorMigrated;
import com.teamscale.index.migration.v116_dashboards.V116DashboardDescriptorUnmigrated;
import com.teamscale.index.migration.v116_dashboards.V116DashboardTemplateDescriptor;
import com.teamscale.index.migration.v116_dashboards.V116EBasicPermissionScope;
import com.teamscale.index.migration.v116_dashboards.V116EBasicRole;
import com.teamscale.index.migration.v116_dashboards.V116EDashboardAccessRightUnmigrated;
import com.teamscale.index.migration.v116_dashboards.V116EGlobalPermission;
import com.teamscale.index.migration.v116_dashboards.V116EProjectPermission;
import com.teamscale.index.migration.v116_dashboards.V116ESubjectType;
import com.teamscale.index.migration.v116_dashboards.V116GlobalRole;
import com.teamscale.index.migration.v116_dashboards.V116InternalProjectId;
import com.teamscale.index.migration.v116_dashboards.V116ProjectIdBase;
import com.teamscale.index.migration.v116_dashboards.V116ProjectRole;
import com.teamscale.index.migration.v116_dashboards.V116PublicProjectId;
import com.teamscale.index.migration.v116_dashboards.V116RoleBase;
import com.teamscale.index.migration.v116_dashboards.V116SubjectRoleAssignments;
import com.teamscale.index.migration.v116_dashboards.V116User;
import com.teamscale.index.migration.v116_dashboards.V116UserResolvedDashboardAccessEntryUnmigrated;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class MigrateVersion116DashboardIndex
implements IMultiStoreMigrator {
    private static final String KEY_VALUE_SEPARATOR = ">#>";
    private static final String PERMISSION_INDEX_KEY_DELIMITER = "#";
    private static final String ENTRY_SEPARATOR = "!,!";
    private static final String DASHBOARD_INDEX_NAME = "dashboards";
    private static final String USER_OPTION_INDEX_NAME = "user-options";
    private static final String DASHBOARD_TEMPLATE_INDEX_NAME = "dashboard-templates";
    private static final String PERMISSION_INDEX_NAME = "permissions";
    private static final String FAVORITES_INDEX_NAME = "user-dashboard-favorites";
    private static final byte[] LAST_CHANGE_TIMESTAMP_KEY = StringUtils.stringToBytes((String)"last-change-timestamp-key");
    private final ClassNameMigrator dashboardClassNameMigrator = new ClassNameMigrator();
    private final ClassNameMigrator permissionClassNameMigrator = new ClassNameMigrator();

    public MigrateVersion116DashboardIndex() {
        this.dashboardClassNameMigrator.registerUnmigratedClass("com.teamscale.index.dashboard.DashboardDescriptor", V116DashboardDescriptorUnmigrated.class);
        this.dashboardClassNameMigrator.registerMigratedClass("com.teamscale.index.dashboard.DashboardDescriptor", V116DashboardDescriptorMigrated.class);
        this.dashboardClassNameMigrator.registerUnmigratedClass("com.teamscale.index.dashboard.DashboardAccessEntry", V116DashboardAccessEntryUnmigrated.class);
        this.dashboardClassNameMigrator.registerUnmigratedClass("com.teamscale.index.dashboard.UserResolvedDashboardAccessEntry", V116UserResolvedDashboardAccessEntryUnmigrated.class);
        this.dashboardClassNameMigrator.registerUnmigratedClass("org.conqat.engine.service.shared.data.User", V116User.class);
        this.dashboardClassNameMigrator.registerUnmigratedClass("com.teamscale.index.dashboard.EDashboardAccessRight", V116EDashboardAccessRightUnmigrated.class);
        this.dashboardClassNameMigrator.registerIntermediateClass("com.teamscale.index.dashboard.DashboardDescriptorBase", V116DashboardDescriptorBase.class);
        this.dashboardClassNameMigrator.registerIntermediateClass("com.teamscale.index.dashboard.templates.DashboardTemplateDescriptor", V116DashboardTemplateDescriptor.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.GlobalRole", V116GlobalRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.EGlobalPermission", V116EGlobalPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.EProjectPermission", V116EProjectPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.RoleBase", V116RoleBase.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.SubjectRoleAssignments", V116SubjectRoleAssignments.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.EBasicPermissionScope", V116EBasicPermissionScope.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.EBasicRole", V116EBasicRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.service.permissions.roles.ProjectRole", V116ProjectRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ESubjectType", V116ESubjectType.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.InternalProjectId", V116InternalProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.PublicProjectId", V116PublicProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ProjectIdBase", V116ProjectIdBase.class);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V116;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public Set<String> getInputStoreNames() {
        return Set.of(DASHBOARD_INDEX_NAME, USER_OPTION_INDEX_NAME, DASHBOARD_TEMPLATE_INDEX_NAME, PERMISSION_INDEX_NAME, FAVORITES_INDEX_NAME);
    }

    public Set<String> getOutputStoreNames() {
        return Set.of(DASHBOARD_INDEX_NAME, USER_OPTION_INDEX_NAME, DASHBOARD_TEMPLATE_INDEX_NAME, PERMISSION_INDEX_NAME, FAVORITES_INDEX_NAME);
    }

    public void migrate(Map<String, IStore> inputStoresByName, Map<String, IStore> outputStoresByName) throws StorageException {
        this.migrateDashboardDescriptors(inputStoresByName.get(DASHBOARD_TEMPLATE_INDEX_NAME), outputStoresByName.get(DASHBOARD_TEMPLATE_INDEX_NAME), null);
        ListMap roleAssignments = new ListMap();
        Map<String, UUID> qualifiedDashboardNameToId = this.migrateDashboardDescriptors(inputStoresByName.get(DASHBOARD_INDEX_NAME), outputStoresByName.get(DASHBOARD_INDEX_NAME), (ListMap<Pair<V116ESubjectType, String>, Pair<String, V116EBasicRole>>)roleAssignments);
        MigrateVersion116DashboardIndex.migrateLastOpenedDashboardOption(inputStoresByName.get(USER_OPTION_INDEX_NAME), outputStoresByName.get(USER_OPTION_INDEX_NAME), qualifiedDashboardNameToId);
        MigrateVersion116DashboardIndex.migrateDashboardFavorites(inputStoresByName.get(FAVORITES_INDEX_NAME), outputStoresByName.get(FAVORITES_INDEX_NAME), qualifiedDashboardNameToId);
        outputStoresByName.put(PERMISSION_INDEX_NAME, inputStoresByName.get(PERMISSION_INDEX_NAME));
        this.migratePermissionStore((ListMap<Pair<V116ESubjectType, String>, Pair<String, V116EBasicRole>>)roleAssignments, outputStoresByName.get(PERMISSION_INDEX_NAME));
    }

    private void migratePermissionStore(ListMap<Pair<V116ESubjectType, String>, Pair<String, V116EBasicRole>> roleAssignments, IStore store) throws StorageException {
        ConvenientStore permissionStore = new ConvenientStore((IStore)new CompressingStore(store));
        this.insertRoleAssignmentsIntoPermissionStore(roleAssignments, permissionStore);
        V116GlobalRole DASHBOARD_CREATOR = new V116GlobalRole("Dashboard Creator", "The project creator role allows creating new projects, analysis profiles, metric threshold configurations and quality reports.", V116EGlobalPermission.CREATE_DASHBOARDS, V116EGlobalPermission.CREATE_DASHBOARD_TEMPLATES);
        permissionStore.putWithString(MigrateVersion116DashboardIndex.createGlobalRoleKey(DASHBOARD_CREATOR.getReadableName()), this.permissionClassNameMigrator.serialize(DASHBOARD_CREATOR));
        PairList updatedAssignments = new PairList();
        HashSet<String> dashboardAdminRoles = new HashSet<String>(Set.of("Instance Admin"));
        PairList globalRoles = permissionStore.getEntriesStartingWith("GLOBAL_ROLE");
        ArrayList<byte[]> entriesToDelete = new ArrayList<byte[]>();
        HashSet<String> rolesToRemove = new HashSet<String>();
        for (Pair globalRolePair : globalRoles) {
            V116GlobalRole globalRole = (V116GlobalRole)this.permissionClassNameMigrator.deserialize((byte[])globalRolePair.getSecond());
            boolean dashboardAdminRole = globalRole.getPermissions().remove((Object)V116EGlobalPermission.ADMIN_DASHBOARDS);
            if (dashboardAdminRole) {
                dashboardAdminRoles.add(globalRole.getReadableName());
            }
            if (globalRole.getPermissions().isEmpty()) {
                entriesToDelete.add((byte[])globalRolePair.getFirst());
                rolesToRemove.add(globalRole.getReadableName());
                continue;
            }
            updatedAssignments.add((Object)((byte[])globalRolePair.getFirst()), (Object)this.permissionClassNameMigrator.serialize(globalRole));
        }
        PairList roleAssignments1 = permissionStore.getEntriesStartingWith("ROLE_ASSIGNMENTS");
        for (Pair roleAssignmentPair : roleAssignments1) {
            boolean hadDashboardAdminRights;
            V116SubjectRoleAssignments roleAssignment = (V116SubjectRoleAssignments)this.permissionClassNameMigrator.deserialize((byte[])roleAssignmentPair.getSecond());
            roleAssignment.addGlobalRole(DASHBOARD_CREATOR);
            boolean bl = hadDashboardAdminRights = !CollectionUtils.intersectionSet(roleAssignment.getGlobalRoleNames(), (Collection[])new Collection[]{dashboardAdminRoles}).isEmpty();
            if (hadDashboardAdminRights) {
                roleAssignment.addGlobalBasicRole(V116EBasicPermissionScope.DASHBOARDS, V116EBasicRole.OWNER);
                roleAssignment.addGlobalBasicRole(V116EBasicPermissionScope.DASHBOARD_TEMPLATES, V116EBasicRole.OWNER);
            }
            roleAssignment.getGlobalRoleNames().removeAll(rolesToRemove);
            updatedAssignments.add((Object)((byte[])roleAssignmentPair.getFirst()), (Object)this.permissionClassNameMigrator.serialize(roleAssignment));
        }
        permissionStore.put(updatedAssignments);
        permissionStore.remove(entriesToDelete);
    }

    private void insertRoleAssignmentsIntoPermissionStore(ListMap<Pair<V116ESubjectType, String>, Pair<String, V116EBasicRole>> roleAssignments, ConvenientStore permissionStore) throws StorageException {
        ArrayList subjects = new ArrayList(roleAssignments.getKeys());
        List subjectKeys = CollectionUtils.map(subjects, subject -> MigrateVersion116DashboardIndex.createRoleAssignmentKey((V116ESubjectType)((Object)((Object)subject.getFirst())), (String)subject.getSecond()));
        List values = permissionStore.getWithStrings(subjectKeys);
        PairList updatedAssignments = new PairList();
        CollectionUtils.forEachWithException(subjects, (Collection)values, (subject, value) -> {
            V116SubjectRoleAssignments roleAssignment = value == null ? new V116SubjectRoleAssignments((V116ESubjectType)((Object)((Object)subject.getFirst())), (String)subject.getSecond()) : (V116SubjectRoleAssignments)this.permissionClassNameMigrator.deserialize((byte[])value);
            for (Pair instanceIdAndRole : (List)roleAssignments.getCollection(subject)) {
                roleAssignment.addBasicRole(V116EBasicPermissionScope.DASHBOARDS, (String)instanceIdAndRole.getFirst(), (V116EBasicRole)instanceIdAndRole.getSecond());
            }
            updatedAssignments.add((Object)MigrateVersion116DashboardIndex.createRoleAssignmentKey((V116ESubjectType)((Object)((Object)subject.getFirst())), (String)subject.getSecond()), (Object)this.permissionClassNameMigrator.serialize(roleAssignment));
        });
        permissionStore.putWithStrings(updatedAssignments);
    }

    private static String createGlobalRoleKey(String roleId) {
        return "GLOBAL_ROLE#" + roleId;
    }

    private static String createRoleAssignmentKey(V116ESubjectType subjectType, String subjectId) {
        return "ROLE_ASSIGNMENTS#" + String.valueOf((Object)subjectType) + PERMISSION_INDEX_KEY_DELIMITER + subjectId;
    }

    private @NonNull Map<String, UUID> migrateDashboardDescriptors(IStore inputStore, IStore outputStore, ListMap<Pair<V116ESubjectType, String>, Pair<String, V116EBasicRole>> roleAssignments) throws StorageException {
        ConvenientStore unmigratedDashboardStore = new ConvenientStore((IStore)new CompressingStore(inputStore));
        HashMap<String, UUID> qualifiedDashboardNameToId = new HashMap<String, UUID>();
        PairList dashboards = unmigratedDashboardStore.getEntriesStartingWith("");
        PairList migratedDashboards = new PairList();
        for (int i = 0; i < dashboards.size(); ++i) {
            UUID id;
            String qualifiedDashboardName = StringUtils.bytesToString((byte[])((byte[])dashboards.getFirst(i)));
            V116DashboardDescriptorBase dashboardDescriptor = (V116DashboardDescriptorBase)this.dashboardClassNameMigrator.deserialize((byte[])dashboards.getSecond(i));
            dashboardDescriptor.id = id = UUID.nameUUIDFromBytes(qualifiedDashboardName.getBytes(StandardCharsets.UTF_8));
            qualifiedDashboardNameToId.put(qualifiedDashboardName, id);
            if (dashboardDescriptor instanceof V116DashboardDescriptorUnmigrated) {
                V116DashboardDescriptorUnmigrated dashboard = (V116DashboardDescriptorUnmigrated)dashboardDescriptor;
                MigrateVersion116DashboardIndex.addRolesForSubjectType(V116ESubjectType.USER, dashboard.userAccessEntries, id, roleAssignments);
                MigrateVersion116DashboardIndex.addRolesForSubjectType(V116ESubjectType.GROUP, dashboard.groupAccessEntries, id, roleAssignments);
                MigrateVersion116DashboardIndex.addRolesForSubjectType(V116ESubjectType.PROJECT, dashboard.projectAccessEntries, id, roleAssignments);
                roleAssignments.add((Object)new Pair((Object)V116ESubjectType.USER, (Object)dashboardDescriptor.owner), (Object)new Pair((Object)id.toString(), (Object)V116EBasicRole.OWNER));
                dashboardDescriptor = new V116DashboardDescriptorMigrated(dashboard);
            }
            migratedDashboards.add((Object)id.toString(), (Object)this.dashboardClassNameMigrator.serialize(dashboardDescriptor));
        }
        ConvenientStore migratedDashboardStore = new ConvenientStore((IStore)new CompressingStore(outputStore));
        migratedDashboardStore.putWithStrings(migratedDashboards);
        return qualifiedDashboardNameToId;
    }

    private static void addRolesForSubjectType(V116ESubjectType subjectType, @Nullable ArrayList<V116DashboardAccessEntryUnmigrated> accessEntries, UUID id, ListMap<Pair<V116ESubjectType, String>, Pair<String, V116EBasicRole>> roleAssignments) {
        if (accessEntries == null) {
            return;
        }
        for (V116DashboardAccessEntryUnmigrated userAccessEntry : accessEntries) {
            roleAssignments.add((Object)new Pair((Object)subjectType, (Object)userAccessEntry.userOrGroup), (Object)new Pair((Object)id.toString(), (Object)MigrateVersion116DashboardIndex.getRoleName(userAccessEntry)));
        }
    }

    private static V116EBasicRole getRoleName(V116DashboardAccessEntryUnmigrated userAccessEntry) {
        return userAccessEntry.accessRight == V116EDashboardAccessRightUnmigrated.READ_WRITE ? V116EBasicRole.EDITOR : V116EBasicRole.VIEWER;
    }

    private static void migrateLastOpenedDashboardOption(IStore inputStore, IStore outputStore, Map<String, UUID> qualifiedDashboardNameToId) throws StorageException {
        ConvenientStore userOptionStore = new ConvenientStore((IStore)new CompressingStore(inputStore));
        PairList userOptions = userOptionStore.getEntriesStartingWith("");
        for (int i = 0; i < userOptions.size(); ++i) {
            try {
                SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])((byte[])userOptions.getSecond(i)));
                SerializedClass entityPoolClass = entityPool.findClass("com.teamscale.ui.option.LastDashboardOpenedByUserOption");
                for (SerializedObject option : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPoolClass, (SerializedEntityPool)entityPool)) {
                    SerializedStringObject projectDashboardMappingObject = (SerializedStringObject)entityPool.getEntity(((Integer)option.getFieldValue("projectDashboardMapping")).intValue(), SerializedStringObject.class);
                    String projectDashboardMapping = projectDashboardMappingObject.getValue();
                    String migratedProjectDashboardMapping = MigrateVersion116DashboardIndex.migrateProjectToDashboardMapping(projectDashboardMapping, qualifiedDashboardNameToId);
                    projectDashboardMappingObject.setValue(migratedProjectDashboardMapping);
                }
                userOptions.setSecond(i, (Object)SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities()));
                continue;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        ConvenientStore migratedUserOptionsStore = new ConvenientStore((IStore)new CompressingStore(outputStore));
        migratedUserOptionsStore.put(userOptions);
    }

    private static void migrateDashboardFavorites(IStore inputStore, IStore outputStore, Map<String, UUID> qualifiedDashboardNameToId) throws StorageException {
        ConvenientStore dashboardFavoritesStore = new ConvenientStore(inputStore);
        PairList userToFavorites = dashboardFavoritesStore.getEntriesStartingWith("");
        for (int i = 0; i < userToFavorites.size(); ++i) {
            if (Arrays.equals((byte[])userToFavorites.getFirst(i), LAST_CHANGE_TIMESTAMP_KEY)) continue;
            try {
                SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])((byte[])userToFavorites.getSecond(i)));
                SerializedClass entityPoolClass = entityPool.findClass("com.teamscale.core.utils.TimestampedInteraction");
                for (SerializedObject option : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPoolClass, (SerializedEntityPool)entityPool)) {
                    SerializedStringObject projectDashboardMappingObject = (SerializedStringObject)entityPool.getEntity(((Integer)option.getFieldValue("identifier")).intValue(), SerializedStringObject.class);
                    String dashboardName = projectDashboardMappingObject.getValue();
                    UUID dashboardId = qualifiedDashboardNameToId.get(dashboardName);
                    if (dashboardId == null) continue;
                    projectDashboardMappingObject.setValue(dashboardId.toString());
                }
                userToFavorites.setSecond(i, (Object)SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities()));
                continue;
            }
            catch (IOException e) {
                throw new StorageException("Failed to migrate key " + StringUtils.bytesToString((byte[])((byte[])userToFavorites.getFirst(i))), (Throwable)e);
            }
        }
        ConvenientStore migratedUserOptionsStore = new ConvenientStore(outputStore);
        migratedUserOptionsStore.put(userToFavorites);
    }

    private static String migrateProjectToDashboardMapping(String projectDashboardMapping, Map<String, UUID> qualifiedDashboardNameToId) {
        Object result = "";
        if (StringUtils.isEmpty((String)projectDashboardMapping)) {
            return result;
        }
        List rawEntries = StringUtils.splitToList((String)projectDashboardMapping, (String)ENTRY_SEPARATOR);
        for (String rawEntry : rawEntries) {
            if (!rawEntry.contains(KEY_VALUE_SEPARATOR)) continue;
            String[] keyAndValue = rawEntry.split(KEY_VALUE_SEPARATOR, 2);
            String project = keyAndValue[0];
            String dashboardName = keyAndValue[1];
            UUID dashboardId = qualifiedDashboardNameToId.get(dashboardName);
            if (dashboardId == null) continue;
            if (!"".equals(result)) {
                result = (String)result + ENTRY_SEPARATOR;
            }
            result = (String)result + project + KEY_VALUE_SEPARATOR + String.valueOf(dashboardId);
        }
        return result;
    }
}

