/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.mail.MailSender;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.user.User;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.blacklisting.FindingExclusionApprovalOption;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotifierBase;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.user.UserAliasLookup;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class FindingExclusionRejectionNotifier
extends NotifierBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TeamscaleCommitLinkProvider teamscaleLinkProvider;
    private final FindingBlacklistStagingIndex findingBlacklistStagingIndex;
    private final TrackedFindingsByIdIndex findingsByIdIndex;

    public FindingExclusionRejectionNotifier(NotificationContext notificationContext, UserAliasLookup userAliasLookup) throws StorageException {
        super(notificationContext, userAliasLookup);
        String baseUrl = BaseUrlOption.getBaseUrl((GlobalStorageSystem)notificationContext.getGlobalStorageSystem());
        this.teamscaleLinkProvider = new TeamscaleCommitLinkProvider(baseUrl, notificationContext.getPrimaryPublicId(), notificationContext.getCommit().toUnresolvedCommitDescriptor());
        this.findingBlacklistStagingIndex = (FindingBlacklistStagingIndex)notificationContext.getProjectStorageSystem().openProjectIndex(FindingBlacklistStagingIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)notificationContext.getCommit()));
        this.findingsByIdIndex = (TrackedFindingsByIdIndex)notificationContext.getIndexLayer().openProjectIndex((IProjectId)notificationContext.getInternalId(), TrackedFindingsByIdIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)notificationContext.getCommit()));
    }

    @Override
    public void checkConditionsAndNotify() throws StorageException {
        if (this.areNotificationsSuppressed()) {
            return;
        }
        FindingBlacklistCommit commitInfo = (FindingBlacklistCommit)((Object)this.findingBlacklistStagingIndex.getCommitInfo());
        if (commitInfo == null || !this.notificationContext.getCommit().equals((Object)commitInfo.getCommit())) {
            return;
        }
        ListMap rejectedTolerationsByRequestor = new ListMap();
        ListMap rejectedFalsePositivesByRequestor = new ListMap();
        commitInfo.getBlacklistEvents().stream().filter(FindingExclusionRejectionNotifier::isRejection).forEach(event -> FindingExclusionRejectionNotifier.collectRejection(event, (ListMap<String, FindingBlacklistInfo>)rejectedTolerationsByRequestor, (ListMap<String, FindingBlacklistInfo>)rejectedFalsePositivesByRequestor));
        try {
            this.processRejectionsByRequestor((ListMap<String, FindingBlacklistInfo>)rejectedTolerationsByRequestor, (ListMap<String, FindingBlacklistInfo>)rejectedFalsePositivesByRequestor);
        }
        catch (MailSender.MailException e) {
            throw new StorageException("Error sending mail for finding exclusion rejection notification: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    private boolean areNotificationsSuppressed() throws StorageException {
        ProjectOptionIndex projectOptionIndex = (ProjectOptionIndex)this.notificationContext.getProjectStorageSystem().openProjectIndex(ProjectOptionIndex.class, null);
        return FindingExclusionApprovalOption.getInstance(projectOptionIndex).shouldSuppressMailNotifications();
    }

    private void processRejectionsByRequestor(ListMap<String, FindingBlacklistInfo> rejectedTolerationsByRequestor, ListMap<String, FindingBlacklistInfo> rejectedFalsePositivesByRequestor) throws StorageException, MailSender.MailException {
        HashSet requestors = CollectionUtils.unionSet((Collection)rejectedTolerationsByRequestor.getKeys(), (Collection[])new Collection[]{rejectedFalsePositivesByRequestor.getKeys()});
        for (String requestor : requestors) {
            Optional<User> resolvedUser = this.userAliasLookup.resolveUser(requestor);
            if (resolvedUser.isEmpty()) {
                LOGGER.info("Skipping notification e-mail for user not existing in Teamscale: {}", (Object)requestor);
                continue;
            }
            String emailAddress = resolvedUser.get().getEmailAddress();
            if (StringUtils.isEmpty((String)emailAddress)) {
                LOGGER.warn("Could not send notification e-mail due to missing e-mail address for user: {}", (Object)requestor);
                continue;
            }
            if (!this.mayAccessProject(resolvedUser.get(), (IProjectId)this.notificationContext.getPrimaryPublicId())) {
                LOGGER.info("Skipping notification e-mail for user {} due to missing permission for project {}", (Object)requestor, (Object)this.notificationContext.getProjectReadableName());
                continue;
            }
            this.sendNotificationMail(emailAddress, rejectedTolerationsByRequestor.getCollectionOrEmpty((Object)requestor), rejectedFalsePositivesByRequestor.getCollectionOrEmpty((Object)requestor), resolvedUser.get());
        }
    }

    private void sendNotificationMail(String emailAddress, Collection<FindingBlacklistInfo> rejectedTolerations, Collection<FindingBlacklistInfo> rejectedFalsePositives, User requestor) throws StorageException, MailSender.MailException {
        StringBuilder mailContent = new StringBuilder();
        this.appendStartOfMail(requestor.getFullName(), mailContent, rejectedTolerations, rejectedFalsePositives);
        this.processBlacklistInfos(rejectedTolerations, mailContent, requestor);
        this.processBlacklistInfos(rejectedFalsePositives, mailContent, requestor);
        mailContent.append("</ul>");
        mailContent.append("If you have any questions, please get in touch with the reviewer.<br><br>");
        mailContent.append("<i>This e-mail was automatically generated by Teamscale.</i>");
        String subject = FindingExclusionRejectionNotifier.getMailSubject(rejectedTolerations, rejectedFalsePositives);
        this.notificationContext.getMailSender().sendHtmlMail(List.of(emailAddress), subject, mailContent.toString(), this.notificationContext.getGlobalStorageSystem());
    }

    private void appendStartOfMail(String userFullName, StringBuilder mailContent, Collection<FindingBlacklistInfo> rejectedTolerations, Collection<FindingBlacklistInfo> rejectedFalsePositives) {
        mailContent.append("Hello " + userFullName + ",<br><br>");
        mailContent.append("Your following pending ");
        if (rejectedTolerations.isEmpty()) {
            mailContent.append(FindingExclusionRejectionNotifier.getFalsePositivesLabel(rejectedFalsePositives) + " ");
        } else if (rejectedFalsePositives.isEmpty()) {
            mailContent.append(FindingExclusionRejectionNotifier.getTolerationsLabel(rejectedTolerations) + " ");
        } else {
            mailContent.append(FindingExclusionRejectionNotifier.getTolerationsLabel(rejectedTolerations) + "/" + FindingExclusionRejectionNotifier.getFalsePositivesLabel(rejectedFalsePositives) + " ");
        }
        String hasBeen = rejectedFalsePositives.size() + rejectedTolerations.size() > 1 ? "have" : "has";
        mailContent.append(String.format("in the Teamscale project <b>%s</b> %s been rejected:<br><ul>", this.notificationContext.getProjectReadableName(), hasBeen));
    }

    private static String getFalsePositivesLabel(Collection<FindingBlacklistInfo> rejectedFalsePositives) {
        return rejectedFalsePositives.size() > 1 ? "false positives" : "false positive";
    }

    private static String getTolerationsLabel(Collection<FindingBlacklistInfo> rejectedTolerations) {
        return rejectedTolerations.size() > 1 ? "tolerations" : "toleration";
    }

    private static @NonNull String getMailSubject(Collection<FindingBlacklistInfo> rejectedTolerations, Collection<FindingBlacklistInfo> rejectedFalsePositives) {
        if (rejectedTolerations.isEmpty()) {
            return "Pending " + FindingExclusionRejectionNotifier.getFalsePositivesLabel(rejectedFalsePositives) + " rejected";
        }
        if (rejectedFalsePositives.isEmpty()) {
            return "Pending " + FindingExclusionRejectionNotifier.getTolerationsLabel(rejectedTolerations) + " rejected";
        }
        return "Pending " + FindingExclusionRejectionNotifier.getTolerationsLabel(rejectedTolerations) + "/" + FindingExclusionRejectionNotifier.getFalsePositivesLabel(rejectedFalsePositives) + " rejected";
    }

    private void processBlacklistInfos(Collection<FindingBlacklistInfo> blacklistInfos, StringBuilder mailContent, User requestor) {
        blacklistInfos.forEach(blacklistInfo -> {
            FindingBlacklistInfo.IApprovalState patt1$temp = blacklistInfo.getApprovalState();
            if (patt1$temp instanceof FindingBlacklistInfo.IApprovalState.Rejected) {
                String patt4$temp;
                String by;
                FindingBlacklistInfo.IApprovalState.Rejected $b$0 = (FindingBlacklistInfo.IApprovalState.Rejected)patt1$temp;
                try {
                    String patt2$temp;
                    by = patt2$temp = $b$0.by();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                long patt2$temp = $b$0.at();
                String rationale = patt4$temp = $b$0.rationale();
                this.appendRejectionInformation(mailContent, (FindingBlacklistInfo)blacklistInfo, by, rationale, requestor);
            }
        });
    }

    private void appendRejectionInformation(StringBuilder mailContent, FindingBlacklistInfo blacklistInfo, String rejectedByUsername, String rationale, User requestor) {
        try {
            TrackedFinding finding = this.findingsByIdIndex.getFinding(blacklistInfo.getFindingId());
            if (finding != null) {
                this.appendRejectedFindingContent(mailContent, blacklistInfo, rejectedByUsername, rationale, finding, requestor);
            } else {
                LOGGER.error("Could not resolve finding with id '{}'", (Object)blacklistInfo.getFindingId());
                FindingExclusionRejectionNotifier.appendRejectionInformationForUnresolvedFinding(blacklistInfo, rationale, mailContent);
            }
        }
        catch (StorageException e) {
            LOGGER.error("Error fetching finding: {}", (Object)blacklistInfo.getFindingId(), (Object)e);
            FindingExclusionRejectionNotifier.appendRejectionInformationForUnresolvedFinding(blacklistInfo, rationale, mailContent);
        }
    }

    private void appendRejectedFindingContent(StringBuilder mailContent, FindingBlacklistInfo blacklistInfo, String rejectedByUsername, String rationale, TrackedFinding finding, User requestor) throws StorageException {
        mailContent.append("<li>" + finding.getMessage());
        mailContent.append("<ul>");
        mailContent.append(String.format("<li>Link: <a href=\"%s\">View the finding</a></li>", this.teamscaleLinkProvider.createFindingsDetailLink(blacklistInfo.getFindingId())));
        mailContent.append(String.format("<li>%s date: %s</li>", blacklistInfo.getType() == EFindingBlacklistType.FALSE_POSITIVE ? "False positive" : "Toleration", DateTimeUtils.getUiFormattedDateString((long)blacklistInfo.getTimestamp())));
        String locationLink = this.teamscaleLinkProvider.createLinkToFile(finding.getLocation().getUniformPath());
        ElementLocation elementLocation = finding.getLocation();
        if (elementLocation instanceof TextRegionLocation) {
            TextRegionLocation textRegionLocation = (TextRegionLocation)elementLocation;
            locationLink = this.teamscaleLinkProvider.createLinkToFile(finding.getLocation().getUniformPath(), new LineBasedRegion(textRegionLocation.getRawStartLine(), textRegionLocation.getRawEndLine()));
        }
        mailContent.append(String.format("<li>Location: <a href=\"%s\">%s</a></li>", locationLink, finding.getLocationString()));
        this.appendReviewerInformation(mailContent, rejectedByUsername, requestor);
        mailContent.append(String.format("<li>Rejection rationale: %s</li>", StringUtils.isEmpty((String)rationale) ? "<i>no rationale given</i>" : rationale));
        mailContent.append("</ul>");
        mailContent.append("</li>");
    }

    private void appendReviewerInformation(StringBuilder mailContent, String rejectedByUsername, User requestor) throws StorageException {
        Object rejectedByFullName = this.userAliasLookup.resolveUserFullName(rejectedByUsername);
        if (this.mayAccessUser(requestor, (IProjectId)this.notificationContext.getPrimaryPublicId(), rejectedByUsername)) {
            Optional<User> rejectedByUser = this.userAliasLookup.resolveUser(rejectedByUsername);
            if (rejectedByUser.isPresent()) {
                String rejectedByEmailAddress = rejectedByUser.get().getEmailAddress();
                rejectedByFullName = (String)rejectedByFullName + " (<a href=\"mailto:" + rejectedByEmailAddress + "\">" + rejectedByEmailAddress + "</a>)";
            }
        } else if (!((String)rejectedByFullName).equals(rejectedByUsername)) {
            rejectedByFullName = (String)rejectedByFullName + "(" + rejectedByUsername + ")";
        }
        mailContent.append(String.format("<li>Reviewer: %s</li>", rejectedByFullName));
    }

    private static void appendRejectionInformationForUnresolvedFinding(FindingBlacklistInfo blacklistInfo, String rationale, StringBuilder mailContent) {
        mailContent.append(String.format("Finding exclusion for %s with rationale %s\n", blacklistInfo.getFindingId(), rationale));
    }

    private static boolean isRejection(FindingBlacklistEvent findingBlacklistEvent) {
        return findingBlacklistEvent.getExtendedType() == FindingBlacklistEvent.EExtendedBlacklistChangeType.REJECTION;
    }

    private static void collectRejection(FindingBlacklistEvent blacklistEvent, ListMap<String, FindingBlacklistInfo> rejectedTolerationsByRequestor, ListMap<String, FindingBlacklistInfo> rejectedFalsePositivesByRequestor) {
        if (blacklistEvent.getBlacklistInfo().isEmpty()) {
            return;
        }
        FindingBlacklistInfo blacklistInfo = blacklistEvent.getBlacklistInfo().get();
        if (blacklistInfo.getApprovalState() instanceof FindingBlacklistInfo.IApprovalState.Rejected) {
            switch (blacklistInfo.getType()) {
                case TOLERATION: {
                    rejectedTolerationsByRequestor.add((Object)blacklistInfo.getUser(), (Object)blacklistInfo);
                    break;
                }
                case FALSE_POSITIVE: {
                    rejectedFalsePositivesByRequestor.add((Object)blacklistInfo.getUser(), (Object)blacklistInfo);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected blacklist type: " + String.valueOf((Object)blacklistInfo.getType()));
                }
            }
        }
    }
}

