/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.mail.MailSender;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.UserPermissionsProvider;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.user.UserAliasLookup;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public abstract class NotifierBase {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final NotificationContext notificationContext;
    protected UserAliasLookup userAliasLookup;

    protected NotifierBase(NotificationContext notificationContext, UserAliasLookup userAliasLookup) {
        this.notificationContext = notificationContext;
        this.userAliasLookup = userAliasLookup;
    }

    protected boolean mayAccessProject(@NonNull User user, IProjectId projectName) throws StorageException {
        ServicePermissions servicePermissions = this.getServicePermissions(user, projectName);
        return servicePermissions.mayReadProject(projectName);
    }

    private @NonNull ServicePermissions getServicePermissions(@NonNull User user, IProjectId projectName) throws StorageException {
        SynchronizedCacheAccess permissionCacheAccess = this.notificationContext.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(PermissionCache.class);
        PermissionIndex permissionIndex = (PermissionIndex)this.notificationContext.getGlobalStorageSystem().openGlobalIndex(PermissionIndex.class);
        UserGroupIndex groupIndex = this.notificationContext.getUserGroupIndex();
        ProjectIndex projectIndex = (ProjectIndex)this.notificationContext.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        UserPermissionsProvider userPermissionsProvider = new UserPermissionsProvider(groupIndex, permissionIndex, permissionCacheAccess);
        return new ServicePermissions(userPermissionsProvider.getUserPermissions(user), projectName, projectIndex, permissionIndex);
    }

    protected boolean mayAccessUser(User accessingUser, IProjectId projectName, String accessedUser) throws StorageException {
        return this.getServicePermissions(accessingUser, projectName).hasBasicPermission(EBasicPermissionScope.USERS, accessedUser, EBasicPermission.VIEW);
    }

    protected void sendEmail(User user, String subject, String mailContent) throws StorageException {
        String emailAddress = user.getEmailAddress();
        if (StringUtils.isEmpty((String)emailAddress)) {
            LOGGER.warn("Can not send notification email to user {} because no email address was provided.", (Object)user.getUsername());
            return;
        }
        try {
            this.notificationContext.getMailSender().sendHtmlMail(Collections.singletonList(emailAddress), subject, mailContent, this.notificationContext.getGlobalStorageSystem());
        }
        catch (MailSender.MailException e) {
            LOGGER.error("Email sending failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public abstract void checkConditionsAndNotify() throws StorageException;
}

