/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class MetricBarChartSlide
extends ReportSlideBase<MetricBarChartSlideParameters, MetricBarChartSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.METRIC_ASSESSMENT;
    }

    @IndexValueClass(containedInBackup=true)
    public static class SingleMetricResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String METRIC_NAME_PROPERTY = "metricName";
        private static final String BASELINE_VALUE_PROPERTY = "baselineValue";
        private static final String REPORT_END_VALUE_PROPERTY = "reportEndValue";
        private static final String METRIC_ASSESSMENT_PROPERTY = "metricAssessment";
        @JsonProperty(value="metricName")
        public String metricName;
        @JsonProperty(value="baselineValue")
        public @Nullable MetricValueBase<?> baselineValue;
        @JsonProperty(value="reportEndValue")
        public @Nullable MetricValueBase<?> reportEndValue;
        @JsonProperty(value="metricAssessment")
        public MetricAssessment metricAssessment;

        @JsonCreator
        public SingleMetricResult(@JsonProperty(value="metricName") String metricName, @JsonProperty(value="baselineValue") @Nullable MetricValueBase<?> baselineValue, @JsonProperty(value="reportEndValue") @Nullable MetricValueBase<?> reportEndValue, @JsonProperty(value="metricAssessment") MetricAssessment metricAssessment) {
            this.metricName = metricName;
            this.baselineValue = baselineValue;
            this.reportEndValue = reportEndValue;
            this.metricAssessment = metricAssessment;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class MetricBarChartSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String METRIC_RESULTS_PROPERTY = "metricResults";
        private static final String PROPERTY_COMMENTS = "comments";
        @JsonProperty(value="metricResults")
        private List<SingleMetricResult> metricResults;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public MetricBarChartSlideResult(@JsonProperty(value="metricResults") List<SingleMetricResult> metricResults, @JsonProperty(value="comments") List<SlideCommentRenderData> comments) {
            this.metricResults = metricResults;
            this.comments = comments;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class MetricBarChartSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="projectBranchPath")
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        private ProjectBranchPath projectBranchPath;
        @JsonProperty(value="slideTitle")
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        private String slideTitle;
        @JsonProperty(value="metricNames")
        @SlideParameter(formattedName="Metric(s)", inputHint="Select one or two", type=ESlideOptionType.NUMERIC_OR_ASSESSMENT_METRIC)
        private List<String> metricNames = Collections.singletonList("Files");
        @JsonProperty(value="hideTargetThreshold")
        @SlideParameter(formattedName="Hide target threshold", type=ESlideOptionType.BOOLEAN)
        private boolean hideTargetThreshold;
        @JsonProperty(value="hideAssessmentColors")
        @SlideParameter(formattedName="Hide assessment colors", type=ESlideOptionType.BOOLEAN)
        private boolean hideAssessmentColors;
        @JsonProperty(value="comments")
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        private List<ISlideComment> comments;

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<String> getMetricNames() {
            return this.metricNames;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }
    }
}

