/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Striped;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsDeletionFilterUtils;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.input.FindingLocationAdjuster;
import com.teamscale.index.external.input.IntegrateImportedAnalysisResultsTrigger;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoProbeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.info.IContentAdjustable;
import com.teamscale.index.external.input.info.ILineAdjustable;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.report.AnalysisReportIntegrator;
import com.teamscale.index.report.ParsedReportIndex;
import com.teamscale.index.report.ParsedReportIndexCache;
import com.teamscale.index.report.ReportResultByCodePathIndex;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorManager;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CodeFileToCoverageReportIndex;
import com.teamscale.index.resource.LightTokenElementInfo;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.SimpleValidLinesFilter;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class AnalysisReportPersister
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static int REPORT_PROCESS_CHUNK_SIZE = Integer.getInteger("com.teamscale.analysis-report.report-process-chunk-size", 200);
    private static final int UNIFORM_PATH_PROCESS_CHUNK_SIZE = Integer.getInteger("com.teamscale.analysis-report.uniform-path-process-chunk-size", 100);
    private static final String REPORT_CACHE_SIZE_PROPERTY_NAME = "com.teamscale.analysis-report.report-cache-size-mb";
    private static final long REPORT_CACHE_SIZE_IN_MB = Long.getLong("com.teamscale.analysis-report.report-cache-size-mb", ByteUnit.GIBIBYTES.toMebiBytes(1L));
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ParsedReportIndex parsedReportIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private ParsedReportIndex previousParsedReportIndex;
    @DeltaSource(value=ParsedReportIndex.class)
    private KeyDelta parsedReportDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CodeFileToCoverageReportIndex codeFileToCoverageReportIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisStatusIndex statusIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ReportResultByCodePathIndex reportResultByCodePathIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    public TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalResultsPartitionLastUpdateIndex partitionLastUpdateIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisPartitionIndex partitionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodLastTestedIndex methodLastTestedIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkModelInfoIndex simulinkModelInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected ElementHistoryIndex elementHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogFileIndex logFileIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected MetaIndex projectMetaIndex;
    private FindingLocationAdjuster findingLocationAdjuster;
    private final Set<EExternalAnalysisResultType> types = EnumSet.noneOf(EExternalAnalysisResultType.class);
    private final Map<String, Boolean> keepExistingDataInPartition = new ConcurrentHashMap<String, Boolean>();
    private final LoadingCache<@NonNull Class<? extends ExternalAnalysisImportInfo>, Set<PartitionAndPath>> newPartitionAndPaths = Caffeine.newBuilder().build(key -> Collections.newSetFromMap(new ConcurrentHashMap()));
    @StepParameterObject
    private final ExternalAnalysisResultProcessorManager processorManager = new ExternalAnalysisResultProcessorManager();
    private Set<String> deletedFilesInContentDelta;
    private final SetMap<String, EExternalAnalysisResultType> partitions = new SetMap();
    private final Striped<@NonNull Lock> lockStriped = Striped.lock((int)64);
    private ParsedReportIndexCache parsedReportIndexCache;

    public void execute() throws StorageException, ExecutionException {
        this.preprocessDelta();
        try {
            this.initialize();
            this.cleanupDeletedFiles();
            ProcessedReportsResult result = this.processChangedReports();
            this.cleanupRemovedReports(result.removedPartitionAndPaths());
            this.updatePartitionData();
            this.processChangedPaths(result.addedOrChangedUniformPathDelta());
            this.checkCache();
            this.reportStatus(null);
        }
        catch (ConQATException e) {
            this.reportStatus(e);
            throw new StorageException((Throwable)e);
        }
        catch (Throwable t) {
            this.reportStatusSorter(t);
            throw t;
        }
    }

    private void initialize() {
        this.parsedReportIndexCache = new ParsedReportIndexCache(this.parsedReportIndex, REPORT_CACHE_SIZE_IN_MB, ByteUnit.MEBIBYTES);
        this.findingLocationAdjuster = new FindingLocationAdjuster(this.simulinkModelInfoIndex);
    }

    private void checkCache() throws StorageException {
        CacheStats cacheStats = this.parsedReportIndexCache.getCacheStats();
        if (cacheStats.missCount() > (long)this.parsedReportDelta.size()) {
            long requiredCacheSize = this.getNecessaryCacheSizeBytes();
            LOGGER.warn("Cache had more misses than expected: {}/{}. Cache stats: {}", (Object)cacheStats.missCount(), (Object)this.parsedReportDelta.size(), (Object)cacheStats.toString());
            LOGGER.warn("A cache size of at least  {}MB would be required. You can set the cache size by adding -Dcom.teamscale.analysis-report.report-cache-size-mb={} in config/jvm.properties to JVM_EXTRA_ARGS.", (Object)ByteUnit.BYTES.toMebiBytes(requiredCacheSize), (Object)ByteUnit.BYTES.toMebiBytes(requiredCacheSize));
        }
    }

    private void updatePartitionData() throws StorageException {
        for (Map.Entry partition : this.partitions.entrySet()) {
            this.partitionIndex.addPartition((String)partition.getKey(), this.getSchedulingCommit(), (Set)partition.getValue());
            this.partitionLastUpdateIndex.setPartitionLastUpdated((String)partition.getKey(), this.getSchedulingCommit());
            this.methodLastTestedIndex.setPartitionsLastUpload((String)partition.getKey(), this.getSchedulingCommit());
        }
    }

    private void processChangedPaths(Set<String> addedOrChangedUniformPathDelta) throws StorageException {
        this.persistLogAndElementHistory(addedOrChangedUniformPathDelta);
    }

    private ProcessedReportsResult processChangedReports() throws ExecutionException, StorageException {
        Set uniformPathsToUpdate = Collections.synchronizedSet(new HashSet());
        Set<PartitionAndPath> removedPartitionAndPaths = Collections.synchronizedSet(new HashSet());
        this.executeInParallelBatches(this.parsedReportDelta.getAllKeysAsStrings(), chunk -> this.collectUniformPathsToUpdate((List<String>)chunk, removedPartitionAndPaths, uniformPathsToUpdate));
        Set<String> addedOrChangedUniformPathDelta = Collections.synchronizedSet(new HashSet());
        this.executeInParallelBatches(new ArrayList(uniformPathsToUpdate), elementsToUpdateChunk -> this.processUniformPathChunk((List<String>)elementsToUpdateChunk, addedOrChangedUniformPathDelta), UNIFORM_PATH_PROCESS_CHUNK_SIZE);
        this.processorManager.persistAll(this.getSchedulingCommit());
        return new ProcessedReportsResult(removedPartitionAndPaths, addedOrChangedUniformPathDelta);
    }

    private void cleanupRemovedReports(Set<PartitionAndPath> removedPartitionAndPaths) throws StorageException {
        this.handleExternalAnalysisResultDeletions(removedPartitionAndPaths);
    }

    private void cleanupDeletedFiles() throws StorageException {
        this.deletedFilesInContentDelta = new HashSet<String>(this.contentDelta.getDeletedKeysAsStrings());
        this.removeResultsForDeletedFiles();
    }

    private void removeResultsForDeletedFiles() throws StorageException {
        if (!this.contentDelta.getDeletedKeys().isEmpty()) {
            this.reportResultByCodePathIndex.removeAnalysisResults(this.contentDelta.getDeletedKeysAsStrings());
            this.codeFileToCoverageReportIndex.removeCodePaths(this.contentDelta.getDeletedKeysAsStrings());
        }
    }

    private void preprocessDelta() {
        this.parsedReportDelta = this.parsedReportIndex.resolveDelta(this.parsedReportDelta);
    }

    private long getNecessaryCacheSizeBytes() throws StorageException {
        long cacheSize = 0L;
        for (List chunk : Iterables.partition((Iterable)this.parsedReportDelta.getAddedOrChangedKeysAsStrings(), (int)REPORT_PROCESS_CHUNK_SIZE)) {
            List values = this.parsedReportIndexCache.getValues(chunk);
            for (ParsedReportIndexCache.ParsedReportWithMap value : values) {
                if (value == null) continue;
                cacheSize += value.getEstimatedSizeBytes();
            }
        }
        return cacheSize;
    }

    private void collectUniformPathsToUpdate(List<String> updatedReportNames, Set<PartitionAndPath> removedPartitionAndPaths, Set<String> uniformPathsToUpdate) throws StorageException {
        List changedReports = CollectionUtils.map((Collection)this.parsedReportIndexCache.getValues(updatedReportNames), ParsedReportIndexCache.ParsedReportWithMap::getReportOrNull);
        List<ParsedReportIndex.ParsedReport> previousReports = this.previousParsedReportIndex.getReports(updatedReportNames);
        this.updateCodeFileToCoverageReportIndex(updatedReportNames, previousReports, changedReports);
        this.insertPathsFromInfos(changedReports, uniformPathsToUpdate, null);
        this.insertPathsFromInfos(previousReports, uniformPathsToUpdate, removedPartitionAndPaths);
        HashSet<String> updatedReportNamesSet = new HashSet<String>(updatedReportNames);
        CCSMAssert.isTrue((updatedReportNamesSet.size() == updatedReportNames.size() ? 1 : 0) != 0, () -> "Duplicate updated/deleted keys: %s".formatted(CollectionUtils.getDuplicates((List)updatedReportNames)));
    }

    private void processUniformPathChunk(List<String> elementsToUpdateChunk, Set<String> addedOrChangedUniformPathDelta) throws StorageException {
        List currentElements = CollectionUtils.map(this.contentIndex.getTokenElements(elementsToUpdateChunk), tokenElementInfo -> {
            if (tokenElementInfo == null) {
                return null;
            }
            return new LightTokenElementInfo((TokenElementInfo)((Object)tokenElementInfo));
        });
        HashMap<String, LightTokenElementInfo> currentElementByPath = new HashMap<String, LightTokenElementInfo>();
        HashMap<String, SimpleValidLinesFilter> adjusterByPath = HashMap.newHashMap(currentElements.size());
        for (LightTokenElementInfo currentElement : currentElements) {
            if (currentElement == null) continue;
            currentElementByPath.put(currentElement.getUniformPath(), currentElement);
            adjusterByPath.put(currentElement.getUniformPath(), new SimpleValidLinesFilter(StringUtils.countLines((String)currentElement.getText())));
        }
        List allUpdatedReportNames = this.parsedReportDelta.getAllKeysAsStrings();
        Map<String, ExternalAnalysisImportInfos> resultsByCodePath = this.loadAndFilterImportInfos(elementsToUpdateChunk, new HashSet<String>(allUpdatedReportNames));
        for (List updatedReportNames : Iterables.partition((Iterable)allUpdatedReportNames, (int)REPORT_PROCESS_CHUNK_SIZE)) {
            List changedReports = this.parsedReportIndexCache.getValues(updatedReportNames);
            CollectionUtils.forEach((Iterable)updatedReportNames, (Iterable)changedReports, (reportName, report) -> AnalysisReportPersister.processReport(reportName, report, currentElementByPath, adjusterByPath, resultsByCodePath));
        }
        this.persistExternalAnalysisImportInfos(addedOrChangedUniformPathDelta, resultsByCodePath);
    }

    private void updateCodeFileToCoverageReportIndex(List<String> changedReportPaths, List<ParsedReportIndex.ParsedReport> previousReports, List<ParsedReportIndex.ParsedReport> changedReports) throws StorageException {
        HashSet<CodeFileToCoverageReportIndex.CodeFileToCoverageReportAssociation> associationsToAdd = new HashSet<CodeFileToCoverageReportIndex.CodeFileToCoverageReportAssociation>();
        HashSet<CodeFileToCoverageReportIndex.CodeFileToCoverageReportAssociation> associationsToRemove = new HashSet<CodeFileToCoverageReportIndex.CodeFileToCoverageReportAssociation>();
        for (int i = 0; i < changedReports.size(); ++i) {
            if (changedReports.get(i) != null) {
                associationsToAdd.addAll(AnalysisReportPersister.extractCodeFileToCoverageReportAssociations(changedReportPaths.get(i), changedReports.get(i)));
            }
            if (previousReports.get(i) == null) continue;
            associationsToRemove.addAll(AnalysisReportPersister.extractCodeFileToCoverageReportAssociations(changedReportPaths.get(i), previousReports.get(i)));
        }
        associationsToRemove.removeIf(association -> this.deletedFilesInContentDelta.contains(association.codePath()));
        associationsToRemove.removeAll(associationsToAdd);
        this.codeFileToCoverageReportIndex.insertAssociations(associationsToAdd);
        this.codeFileToCoverageReportIndex.removeAssociations(associationsToRemove);
    }

    private static Collection<CodeFileToCoverageReportIndex.CodeFileToCoverageReportAssociation> extractCodeFileToCoverageReportAssociations(String reportPath, ParsedReportIndex.ParsedReport report) {
        return CollectionUtils.map(AnalysisReportPersister.extractCodePathsForCoverageData(report), codePath -> new CodeFileToCoverageReportIndex.CodeFileToCoverageReportAssociation((String)codePath, reportPath, report.connectorId()));
    }

    private static Set<String> extractCodePathsForCoverageData(ParsedReportIndex.ParsedReport report) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(CollectionUtils.map(report.importInfos().filterByType(ExternalAnalysisImportInfoLineCoverage.class), ExternalAnalysisImportInfo::getUniformPath));
        result.addAll(CollectionUtils.map(report.importInfos().filterByType(ExternalAnalysisImportInfoProbeCoverage.class), ExternalAnalysisImportInfo::getUniformPath));
        return result;
    }

    private static void processReport(String reportName, ParsedReportIndexCache.ParsedReportWithMap report, Map<String, LightTokenElementInfo> currentElementByPath, Map<String, ILineAdjuster> adjusterByPath, Map<String, ExternalAnalysisImportInfos> resultsByCodePath) {
        if (report == null) {
            return;
        }
        for (Map.Entry<String, ExternalAnalysisImportInfos> codePath2 : resultsByCodePath.entrySet()) {
            String codePath = codePath2.getKey();
            ExternalAnalysisImportInfos existingExternalAnalysisImportInfos = codePath2.getValue();
            List<ExternalAnalysisImportInfo<?>> externalAnalysisImportInfosFromReport = report.importInfosByUniformPath().get(codePath);
            if (externalAnalysisImportInfosFromReport == null) continue;
            boolean foundCurrentElement = currentElementByPath.get(codePath) != null;
            for (ExternalAnalysisImportInfo<?> externalAnalysisImportInfo : externalAnalysisImportInfosFromReport) {
                externalAnalysisImportInfo.addUniformPath(reportName);
                if (foundCurrentElement) {
                    AnalysisReportPersister.adjustLocations(externalAnalysisImportInfo, adjusterByPath.get(codePath), currentElementByPath.get(codePath));
                }
                existingExternalAnalysisImportInfos.addInfo(externalAnalysisImportInfo);
            }
        }
    }

    private Map<String, ExternalAnalysisImportInfos> loadAndFilterImportInfos(List<String> uniformPathsToUpdate, Set<String> changedReportPaths) throws StorageException {
        List<ExternalAnalysisImportInfos> analysisImportInfosList = this.reportResultByCodePathIndex.getAnalysisResults(uniformPathsToUpdate);
        HashMap<String, ExternalAnalysisImportInfos> resultsByCodePath = new HashMap<String, ExternalAnalysisImportInfos>();
        for (int i = 0; i < uniformPathsToUpdate.size(); ++i) {
            ExternalAnalysisImportInfos externalAnalysisImportInfos = Optional.ofNullable(analysisImportInfosList.get(i)).orElse(new ExternalAnalysisImportInfos());
            externalAnalysisImportInfos.removeIf(info -> info.getReportUniformPaths().stream().anyMatch(changedReportPaths::contains));
            resultsByCodePath.put(uniformPathsToUpdate.get(i), externalAnalysisImportInfos);
        }
        return resultsByCodePath;
    }

    private static void adjustLocations(ExternalAnalysisImportInfo<?> info, ILineAdjuster adjuster, LightTokenElementInfo currentElement) {
        if (info instanceof ExternalAnalysisImportInfoLineCoverage) {
            ((ExternalAnalysisImportInfoLineCoverage)info).adjustCoverage(adjuster, currentElement.getUniformPath());
        } else if (info instanceof ExternalAnalysisImportInfoFindings) {
            ExternalAnalysisImportInfoFindings infoFindings = (ExternalAnalysisImportInfoFindings)info;
            infoFindings.adjustFindings(adjuster);
            infoFindings.retainMatching(FindingsDeletionFilterUtils.createDeletionFilter(currentElement.getFilterDeletions(), (int)currentElement.getText().length()));
        }
    }

    private void insertPathsFromInfos(List<ParsedReportIndex.ParsedReport> reportValues, Set<String> uniformPathsToUpdate, @Nullable Set<PartitionAndPath> partitionAndPaths) {
        reportValues.stream().filter(Objects::nonNull).map(report -> report.importInfos().getInfos()).flatMap(Collection::stream).filter(entry -> !this.deletedFilesInContentDelta.contains(entry.getUniformPath())).forEach(entry -> {
            uniformPathsToUpdate.add(entry.getUniformPath());
            if (partitionAndPaths != null) {
                partitionAndPaths.add(new PartitionAndPath(entry.getPartition(), entry.getUniformPath()));
            }
        });
    }

    private void persistExternalAnalysisImportInfos(Set<String> addedOrChangedCodePathsDelta, Map<String, ExternalAnalysisImportInfos> resultsByCodePath) throws StorageException {
        PairList<String, ExternalAnalysisImportInfos> newValues = new PairList<String, ExternalAnalysisImportInfos>();
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry<String, ExternalAnalysisImportInfos> entry : resultsByCodePath.entrySet()) {
            String codePath = entry.getKey();
            if (entry.getValue() == null) continue;
            ExternalAnalysisImportInfos importInfo = entry.getValue();
            if (importInfo.isEmpty()) {
                toDelete.add(codePath);
                continue;
            }
            newValues.add((Object)codePath, (Object)importInfo);
            addedOrChangedCodePathsDelta.add(codePath);
        }
        if (!(newValues = ExternalAnalysisImportInfos.merge(newValues)).isEmpty()) {
            this.reportResultByCodePathIndex.setAnalysisResults(newValues);
            this.processChangedExternalAnalysisInfos(newValues);
        }
        if (!toDelete.isEmpty()) {
            this.reportResultByCodePathIndex.removeAnalysisResults(toDelete);
        }
    }

    private void reportStatusSorter(Throwable error) throws StorageException {
        this.statusIndex.runWithLock(lockedIndex -> {
            ExternalAnalysisStatusInfo oldStatus = lockedIndex.getStatus(this.getSchedulingCommit());
            ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy(oldStatus, () -> new ExternalAnalysisStatusInfo(this.getSchedulingCommit(), false, 0L, false));
            ExternalAnalysisProcessingStepInfo step = AnalysisReportIntegrator.createStepInfo(EExternalAnalysisProcessingStatus.PROCESSING, error);
            status.addProcessingStep(step);
            lockedIndex.updateStatusWithKnownOldStatus(oldStatus, status);
        });
    }

    private void persistLogAndElementHistory(Set<String> addedOrChangedDelta) throws StorageException {
        PairList elements = new PairList();
        ArrayList<RepositoryLogFileEntry> logFileEntries = new ArrayList<RepositoryLogFileEntry>();
        for (String codePath : addedOrChangedDelta) {
            elements.add((Object)codePath, (Object)new ElementHistoryEntry(EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD, this.getSchedulingCommit(), EChangeEntryOrigin.EXTERNAL_UPLOAD));
            logFileEntries.add(new RepositoryLogFileEntry(this.getSchedulingCommit(), UniformPathCompatibilityUtil.convert((String)codePath), ECommitType.EXTERNAL_ANALYSIS, null, false));
        }
        this.logFileIndex.insertEntries(logFileEntries);
        this.elementHistoryIndex.insertAndMergeHistoryEntries((PairList<String, ElementHistoryEntry>)elements);
    }

    private void reportStatus(@Nullable Throwable error) throws StorageException {
        if (error != null) {
            LOGGER.error(error.toString(), error);
        }
        this.statusIndex.runWithLock(lockedIndex -> this.reportStatus((ExternalAnalysisStatusIndex.LockedIndexAccess)lockedIndex, error));
    }

    private void reportStatus(ExternalAnalysisStatusIndex.LockedIndexAccess statusIndexAccess, @Nullable Throwable error) throws StorageException {
        ExternalAnalysisStatusInfo oldStatus = statusIndexAccess.getStatus(this.getSchedulingCommit());
        if (oldStatus == null) {
            return;
        }
        ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy(oldStatus, () -> (ExternalAnalysisStatusInfo)CCSMAssert.fail((String)"Should never happen"));
        ExternalAnalysisProcessingStepInfo step = AnalysisReportIntegrator.createStepInfo(EExternalAnalysisProcessingStatus.PROCESSED, error);
        status.addProcessingStep(step);
        this.types.forEach(status::addType);
        statusIndexAccess.updateStatusWithKnownOldStatus(oldStatus, status);
    }

    private void processChangedExternalAnalysisInfos(PairList<String, ExternalAnalysisImportInfos> changedValues) throws StorageException {
        try {
            Map<String, BasicTokenElementInfo> basicTokenElementLookup = AnalysisReportPersister.buildElementLookupByInstanceType(changedValues, IContentAdjustable.class, this.basicTokenElementIndex::getTokenElementsByPath);
            Map<String, TokenElementLineInfo> lineInfoElementLookup = AnalysisReportPersister.buildElementLookupByInstanceType(changedValues, ILineAdjustable.class, this.tokenElementLineInfoIndex::getLineInfosByPaths);
            CommitDescriptor reportForCommit = this.getSchedulingCommit();
            ChangedPathProcessor changedPathProcessor = new ChangedPathProcessor(this.keepExistingDataInPartition, this.getSchedulingCommit(), reportForCommit, this.types, this.parsedReportDelta.getAddedOrChangedKeysAsStrings(), this.newPartitionAndPaths, this.findingLocationAdjuster, this.partitions, this.lockStriped);
            for (int i = 0; i < changedValues.size(); ++i) {
                this.processExternalAnalysisInfosForPath((String)changedValues.getFirst(i), (ExternalAnalysisImportInfos)changedValues.getSecond(i), basicTokenElementLookup, lineInfoElementLookup, changedPathProcessor);
            }
        }
        catch (ConQATException e) {
            throw new StorageException("Problem loading content for paths " + String.valueOf(changedValues.extractFirstList()), (Throwable)e);
        }
    }

    private void processExternalAnalysisInfosForPath(String path, ExternalAnalysisImportInfos analysisImportInfos, Map<String, BasicTokenElementInfo> basicTokenElementLookup, Map<String, TokenElementLineInfo> lineInfoElementLookup, ChangedPathProcessor changedPathProcessor) throws ConQATException {
        if (analysisImportInfos == null) {
            LOGGER.error("Skipping change entry due to missing report information for path '{}'.", (Object)path);
            return;
        }
        BasicTokenElementInfo content = basicTokenElementLookup.get(path);
        TokenElementLineInfo tokenElementLineInfo = lineInfoElementLookup.get(path);
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)path);
        for (ExternalAnalysisImportInfo<?> info : analysisImportInfos) {
            ExternalAnalysisResultProcessorBase processor = this.processorManager.getProcessorForImportClass(info.getClass());
            if (!processor.isRelevantPath(uniformPath)) continue;
            if (!ExternalAnalysisImportInfo.hasRequiredDataForAdjustment(content, tokenElementLineInfo, info)) {
                LOGGER.error("Skipping change entry due to missing file content: {}. The class {} expects the file's content to be not null.", (Object)path, (Object)info.getClass().getSimpleName());
                continue;
            }
            changedPathProcessor.processChangedPath(info, uniformPath, processor, content, tokenElementLineInfo);
        }
    }

    private static <T> Map<String, T> buildElementLookupByInstanceType(PairList<String, ExternalAnalysisImportInfos> changedValues, Class<?> clazz, FunctionWithException<List<String>, Map<String, T>, StorageException> indexFunction) throws StorageException {
        ArrayList<String> contentAdjustablePaths = new ArrayList<String>();
        for (int i = 0; i < changedValues.size(); ++i) {
            if (!((ExternalAnalysisImportInfos)changedValues.getSecond(i)).containsInstancesOf(clazz)) continue;
            contentAdjustablePaths.add((String)changedValues.getFirst(i));
        }
        return (Map)indexFunction.apply(contentAdjustablePaths);
    }

    private void handleExternalAnalysisResultDeletions(Set<PartitionAndPath> removedPartitionAndPaths) throws StorageException {
        Set entriesToHandle = removedPartitionAndPaths.stream().filter(entry -> this.keepExistingDataInPartition.getOrDefault(entry.getPartition(), false) == false).collect(Collectors.toSet());
        for (Class<? extends ExternalAnalysisImportInfo<?>> clazz : this.processorManager.getSupportedExternalAnalysisImportInfoClasses()) {
            ExternalAnalysisResultProcessorBase processor = this.processorManager.getProcessorForImportClass(clazz);
            HashSet<PartitionAndPath> entriesToRemoveForSpecificProcessor = new HashSet<PartitionAndPath>();
            for (PartitionAndPath removedEntry : entriesToHandle) {
                if (Optional.ofNullable((Set)this.newPartitionAndPaths.getIfPresent(clazz)).map(set -> set.contains(removedEntry)).orElse(false).booleanValue() || !processor.isRelevantPath(removedEntry.toUniformPath())) continue;
                entriesToRemoveForSpecificProcessor.add(removedEntry);
            }
            processor.processDeleted(entriesToRemoveForSpecificProcessor, this.getSchedulingCommit());
            if (entriesToRemoveForSpecificProcessor.isEmpty()) continue;
            this.types.add(processor.getResultType());
        }
    }

    private record ProcessedReportsResult(Set<PartitionAndPath> removedPartitionAndPaths, Set<String> addedOrChangedUniformPathDelta) {
    }

    @VisibleForTesting
    record ChangedPathProcessor(Map<String, Boolean> keepExistingDataInPartition, CommitDescriptor schedulingCommit, CommitDescriptor reportForCommit, Set<EExternalAnalysisResultType> types, List<String> addedOrChangedReportNames, LoadingCache<Class<? extends ExternalAnalysisImportInfo>, Set<PartitionAndPath>> newPartitionAndPaths, FindingLocationAdjuster findingLocationAdjuster, SetMap<String, EExternalAnalysisResultType> partitions, Striped<@NonNull Lock> lockStriped) {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processChangedPath(ExternalAnalysisImportInfo<?> info, UniformPath uniformPath, ExternalAnalysisResultProcessorBase processor, BasicTokenElementInfo content, TokenElementLineInfo tokenElementLineInfo) throws ConQATException {
            boolean containsResultData;
            String stringUniformPath;
            ExternalAnalysisResult<?> analysisResult;
            String partition = info.getPartition();
            if (processor.isPartOfPartialReport(partition, analysisResult = this.getExternalAnalysisResult(content, tokenElementLineInfo, info, stringUniformPath = info.getUniformPath()))) {
                this.keepExistingDataInPartition.put(partition, true);
            }
            if (processor.isThreadSafe()) {
                containsResultData = processor.extract(partition, uniformPath, analysisResult, this.schedulingCommit, this.reportForCommit, content);
            } else {
                Lock lock = (Lock)this.lockStriped.get(info.getClass());
                lock.lock();
                try {
                    containsResultData = processor.extract(partition, uniformPath, analysisResult, this.schedulingCommit, this.reportForCommit, content);
                }
                finally {
                    lock.unlock();
                }
            }
            if (info.getReportUniformPaths().stream().anyMatch(this.addedOrChangedReportNames::contains)) {
                SetMap<String, EExternalAnalysisResultType> setMap = this.partitions;
                synchronized (setMap) {
                    this.partitions.add((Object)partition, (Object)processor.getResultType());
                }
            }
            if (containsResultData) {
                this.types.add(processor.getResultType());
                Objects.requireNonNull((Set)this.newPartitionAndPaths.get(info.getClass())).add(new PartitionAndPath(partition, stringUniformPath));
            }
        }

        private ExternalAnalysisResult<?> getExternalAnalysisResult(BasicTokenElementInfo content, TokenElementLineInfo tokenElementLineInfo, ExternalAnalysisImportInfo<?> info, String uniformPath) throws ConQATException {
            CodeScopeName codeScopeName = content != null ? CodeScopeDetail.getCodeScopeNameFromTokenElement(content) : CodeScopeName.DEFAULT;
            ExternalAnalysisResult<?> analysisResult = info.createAdjustedAnalysisResult(content, tokenElementLineInfo, uniformPath, codeScopeName, this.findingLocationAdjuster::createFindingsAdjuster, IntegrateImportedAnalysisResultsTrigger::createDependencyAdjuster);
            if (analysisResult instanceof ExternalAnalysisResultLineCoverage) {
                LineCoverageInfo resultData = ((ExternalAnalysisResultLineCoverage)analysisResult).getData();
                resultData.setUploadCommitTimestamp(((ExternalAnalysisImportInfoLineCoverage)info).getData().getUploadCommitTimestamp());
            }
            return analysisResult;
        }
    }
}

