/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.report.base.OffsetConvertingFindingReportParserBase;
import com.teamscale.index.upload.parasoft.ParasoftCppTestRule;
import com.teamscale.index.upload.parasoft.ParasoftCppTestRuleParser;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParasoftCppTestReportParser
extends OffsetConvertingFindingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ParasoftCppTestViolation> violations = new ArrayList<ParasoftCppTestViolation>();

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            this.violations.clear();
            XMLUtils.parseSAX((String)report, (DefaultHandler)new ParasoftFindingsHandler(this, new ParasoftCppTestRuleParser().parse(report)));
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (ParasoftCppTestViolation violation : this.violations) {
            Optional<String> path = this.resolvePath(violation.file);
            if (!path.isPresent()) continue;
            Optional<TextRegionLocation> location = this.createTextRegionLocation(path.get(), violation.startLine, violation.startColumn, violation.endLine, violation.endColumn);
            if (!location.isPresent()) {
                LOGGER.error("Ignored violation '" + violation.message + "' in '" + path.get() + "' because its line location could not be mapped.");
                continue;
            }
            String ruleId = violation.rule;
            DetachedFinding finding = ParasoftCppTestReportParser.createFindingWithLocation(ruleId, ruleId, EAnalysisTool.PARASOFT_CPP_TEST.getReadableName(), violation.message, (ElementLocation)location.get());
            this.addFindingForPath(path.get(), finding);
        }
    }

    private class ParasoftFindingsHandler
    extends DefaultHandler {
        private final Map<String, String> parasoftRuleToCategory;
        final /* synthetic */ ParasoftCppTestReportParser this$0;

        public ParasoftFindingsHandler(ParasoftCppTestReportParser parasoftCppTestReportParser, Map<ParasoftCppTestRule, String> rules) {
            ParasoftCppTestReportParser parasoftCppTestReportParser2 = parasoftCppTestReportParser;
            Objects.requireNonNull(parasoftCppTestReportParser2);
            this.this$0 = parasoftCppTestReportParser2;
            this.parasoftRuleToCategory = new HashMap<String, String>();
            rules.entrySet().stream().forEach(entry -> this.parasoftRuleToCategory.put(((ParasoftCppTestRule)entry.getKey()).getId(), (String)entry.getValue()));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (localName) {
                case "StdViol": 
                case "FlowViol": {
                    this.handleViloation(attributes);
                    break;
                }
            }
        }

        private void handleViloation(Attributes attributes) {
            String locationType = attributes.getValue("locType");
            if (!"sr".equals(locationType)) {
                LOGGER.error("Skipping violation with unsupported location type of " + locationType);
                return;
            }
            try {
                this.this$0.violations.add(new ParasoftCppTestViolation(attributes, this.parasoftRuleToCategory));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Skipped violation with invalid numbers in offsets: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class ParasoftCppTestViolation {
        private final String message;
        private final String file;
        private final String rule;
        private final String category;
        private int startLine;
        private int endLine;
        private int startColumn;
        private int endColumn;

        public ParasoftCppTestViolation(Attributes attributes, Map<String, String> parasoftRuleToCategory) {
            this.message = attributes.getValue("msg");
            this.file = attributes.getValue("locFile");
            this.rule = attributes.getValue("rule");
            this.category = parasoftRuleToCategory.get(this.rule);
            this.startLine = Integer.parseInt(attributes.getValue("locStartln"));
            this.endLine = Integer.parseInt(attributes.getValue("locEndLn"));
            this.startColumn = Integer.parseInt(attributes.getValue("locStartPos"));
            this.endColumn = Integer.parseInt(attributes.getValue("locEndPos"));
        }
    }
}

