/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.metrics;

import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class MetricEntryUpdater
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MetricsIndex metricsIndex;
    private final MetricSchemaIndex metricSchemaIndex;
    private final List<IMetricSource> metricSources;
    private final List<MetricDirectorySchemaEntry> schemaEntries;
    private final UnmodifiableList<String> allFiles;

    private MetricEntryUpdater(MetricsIndex metricsIndex, MetricSchemaIndex metricSchemaIndex, List<IMetricSource> oldMetricSources, List<MetricDirectorySchemaEntry> oldSchemaEntries, UnmodifiableList<String> allFiles) {
        this.metricsIndex = metricsIndex;
        this.metricSchemaIndex = metricSchemaIndex;
        this.allFiles = allFiles;
        this.metricSources = MetricEntryUpdater.asMutableList(oldMetricSources);
        this.schemaEntries = MetricEntryUpdater.asMutableList(oldSchemaEntries);
    }

    public static void updateMetricEntries(Collection<MetricSchemaChangeEntry> metricSchemaChangeEntries, MetricsIndex metricsIndex, MetricSchemaIndex metricSchemaIndex, BasicTokenElementIndex basicTokenElementIndex) throws StorageException {
        if (metricSchemaChangeEntries.isEmpty()) {
            return;
        }
        try (MetricEntryUpdater metricEntryUpdater = new MetricEntryUpdater(metricsIndex, metricSchemaIndex, MetricEntryUpdater.getMetricSources(metricSchemaIndex), MetricEntryUpdater.getMetricDirectorySchemaEntries(metricSchemaIndex), (UnmodifiableList<String>)UnmodifiableList.of(basicTokenElementIndex.getAllUniformPaths()));){
            for (MetricSchemaChangeEntry entry : metricSchemaChangeEntries) {
                metricEntryUpdater.update(entry);
            }
        }
    }

    private void update(MetricSchemaChangeEntry entry) throws StorageException {
        if (this.metricSources.stream().anyMatch(source -> source instanceof IndexMetricSource && ((IndexMetricSource)source).getMetricPartition().equals(entry.getMetricId()))) {
            LOGGER.warn("The metric {} is already present in the project. Skipping.", (Object)entry.getMetricId());
            return;
        }
        IndexMetricSource newMetricSource = new IndexMetricSource(entry.getMetricId());
        this.metricSources.add((IMetricSource)newMetricSource);
        this.schemaEntries.add(entry.getMetricDirectoryEntry());
        PairList newValues = new PairList();
        Serializable defaultValue = (Serializable)entry.getMetricDirectoryEntry().getValueType().getDefaultValue();
        for (String file : this.allFiles) {
            newValues.add((Object)file, (Object)defaultValue);
        }
        this.metricsIndex.setMetricValues(newValues, newMetricSource.getMetricPartition());
    }

    @Override
    public void close() throws StorageException {
        this.metricSchemaIndex.setSchema(new MetricDirectorySchema(this.schemaEntries));
        this.metricSchemaIndex.setMetricSources(this.metricSources);
    }

    private static List<IMetricSource> getMetricSources(MetricSchemaIndex metricSchemaIndex) throws StorageException {
        return Objects.requireNonNullElseGet(metricSchemaIndex.getMetricSources(), Collections::emptyList);
    }

    private static List<MetricDirectorySchemaEntry> getMetricDirectorySchemaEntries(MetricSchemaIndex metricSchemaIndex) throws StorageException {
        return (List)Optional.ofNullable(metricSchemaIndex.getSchema(false)).map(MetricDirectorySchema::getAllEntries).orElseGet(CollectionUtils::emptyList);
    }

    private static <T> ArrayList<T> asMutableList(List<T> list) {
        return new ArrayList<T>(list);
    }
}

