/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.boost;

import com.teamscale.index.report.testexecution.TestReportParserBase;
import com.teamscale.index.report.testexecution.junit.JUnitReportParser;
import com.teamscale.index.utils.LocaleIndependentDoubleParser;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BoostReportParser
extends TestReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TESTLOG_ELEMENT = "TestLog";
    private static final String TESTCASE_ELEMENT = "TestCase";
    private static final String CONTEXT_ELEMENT = "Context";
    private static final String FRAME_ELEMENT = "Frame";
    private static final String TESTSUITE_ELEMENT = "TestSuite";
    private static final String TESTINGTIME_ELEMENT = "TestingTime";
    private static final String FAILURE_ELEMENT = "Failure";
    private static final String ERROR_ELEMENT = "Error";
    private static final String SKIPPED_ELEMENT = "Skipped";
    private static final String ABORTED_ELEMENT = "Aborted";
    private static final String NAME_ATTRIBUTE = "name";

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            XMLUtils.parseSAX((String)report, (DefaultHandler)new BoostSaxHandler(this));
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private class BoostSaxHandler
    extends DefaultHandler {
        private final StringBuilder currentTestSuiteName;
        private TestExecution.Builder currentTestCase;
        private final StringBuilder currentText;
        private String errorMessage;
        final /* synthetic */ BoostReportParser this$0;

        private BoostSaxHandler(BoostReportParser boostReportParser) {
            BoostReportParser boostReportParser2 = boostReportParser;
            Objects.requireNonNull(boostReportParser2);
            this.this$0 = boostReportParser2;
            this.currentTestSuiteName = new StringBuilder();
            this.currentText = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!BoostReportParser.CONTEXT_ELEMENT.equals(localName) && !BoostReportParser.FRAME_ELEMENT.equals(localName)) {
                this.currentText.setLength(0);
            }
            if (BoostReportParser.TESTCASE_ELEMENT.equals(localName)) {
                this.enterTestCase(attributes);
            } else if (BoostReportParser.TESTSUITE_ELEMENT.equals(localName)) {
                this.enterTestSuite(attributes);
            } else if (BoostReportParser.FRAME_ELEMENT.equals(localName)) {
                this.errorMessage = this.currentText.toString();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (localName) {
                case "TestCase": {
                    this.this$0.reportTestExecution(this.currentTestCase);
                    this.currentTestCase = null;
                    break;
                }
                case "TestingTime": {
                    this.currentTestCase.setDurationInSeconds(LocaleIndependentDoubleParser.parseDouble(this.currentText.toString()));
                    break;
                }
                case "Failure": {
                    this.handleFailedTest(ETestExecutionResult.FAILURE);
                    break;
                }
                case "Error": {
                    this.handleFailedTest(ETestExecutionResult.ERROR);
                    break;
                }
                case "Skipped": {
                    this.currentTestCase.setResult(ETestExecutionResult.SKIPPED);
                    break;
                }
                case "Aborted": {
                    this.currentTestCase.setResult(ETestExecutionResult.ERROR);
                    break;
                }
                case "Frame": 
                case "Context": 
                case "TestSuite": 
                case "TestLog": {
                    break;
                }
                default: {
                    LOGGER.warn("Unsupported tag <" + localName + "> received. Continuing parsing ...");
                }
            }
        }

        private void handleFailedTest(ETestExecutionResult failure) throws SAXException {
            if (this.currentTestCase == null) {
                throw new SAXException("Encountered failure or error element outside of testcase element!");
            }
            this.currentTestCase.setResult(failure);
            this.currentTestCase.setFailureMessage(this.errorMessage);
        }

        private void enterTestCase(Attributes attributes) throws SAXException {
            if (this.currentTestCase != null) {
                throw new SAXException("Not expecting nested test cases!");
            }
            this.currentTestCase = TestExecution.Builder.fromClassAndName((String)this.currentTestSuiteName.toString(), (String)JUnitReportParser.truncateLongParameterizedTests(attributes.getValue(BoostReportParser.NAME_ATTRIBUTE)));
            this.currentTestCase.setResult(ETestExecutionResult.PASSED);
        }

        private void enterTestSuite(Attributes attributes) {
            if (!this.currentTestSuiteName.isEmpty()) {
                this.currentTestSuiteName.append(UniformPathUtils.SEPARATOR);
            }
            this.currentTestSuiteName.append(attributes.getValue(BoostReportParser.NAME_ATTRIBUTE));
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currentTestCase != null) {
                this.currentText.append(ch, start, length);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

