/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.mstest;

import com.teamscale.index.report.testexecution.TestReportParserBase;
import com.teamscale.index.report.testexecution.mstest.ETrxAttribute;
import com.teamscale.index.report.testexecution.mstest.ETrxElement;
import com.teamscale.index.report.testexecution.mstest.ETrxResult;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.ElementEnumSaxHandler;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MsTestReportParser
extends TestReportParserBase {
    private final HashMap<String, TestExecution.Builder> testExecutionsById = new HashMap();
    private TestExecution.Builder currentTest;
    private final ElementEnumSaxHandler.ElementHandler<ETrxElement> unitTestHandler = new ElementEnumSaxHandler.ElementHandler<ETrxElement>(this){
        private String currentTestId;
        final /* synthetic */ MsTestReportParser this$0;
        {
            MsTestReportParser msTestReportParser = this$0;
            Objects.requireNonNull(msTestReportParser);
            this.this$0 = msTestReportParser;
        }

        public void onStartElement(ETrxElement element, Attributes attributes) {
            if (element == ETrxElement.UNITTEST) {
                this.currentTestId = attributes.getValue(ETrxAttribute.id.name());
            } else {
                String className = StringUtils.getFirstParts((String)attributes.getValue(ETrxAttribute.className.name()), (int)1, (char)',');
                String testName = attributes.getValue(ETrxAttribute.name.name());
                this.this$0.testExecutionsById.put(this.currentTestId, TestExecution.Builder.fromClassAndName((String)className, (String)testName));
            }
        }
    };
    private final ElementEnumSaxHandler.TextElementHandler<ETrxElement> testResultHandler = new ElementEnumSaxHandler.TextElementHandler<ETrxElement>(this){
        final /* synthetic */ MsTestReportParser this$0;
        {
            MsTestReportParser msTestReportParser = this$0;
            Objects.requireNonNull(msTestReportParser);
            this.this$0 = msTestReportParser;
        }

        public void onStartElement(ETrxElement element, Attributes attributes) throws SAXException {
            String testId = attributes.getValue(ETrxAttribute.testId.name());
            this.this$0.currentTest = this.this$0.testExecutionsById.get(testId);
            if (this.this$0.currentTest == null) {
                throw new SAXException("Unknown test with ID: " + testId);
            }
            String outcome = attributes.getValue(ETrxAttribute.outcome.name());
            this.this$0.currentTest.setResult(ETrxResult.getFromResultString(outcome).orElse(ETestExecutionResult.ERROR));
            MsTestReportParser.parseExecutionTime(attributes).ifPresent(arg_0 -> ((TestExecution.Builder)this.this$0.currentTest).setDuration(arg_0));
        }

        public void onEndElement(ETrxElement eTrxElement) {
            this.this$0.reportTestExecution(this.this$0.currentTest);
        }
    };
    private final ElementEnumSaxHandler.TextElementHandler<ETrxElement> errorInfoHandler = new ElementEnumSaxHandler.TextElementHandler<ETrxElement>(this){
        final /* synthetic */ MsTestReportParser this$0;
        {
            MsTestReportParser msTestReportParser = this$0;
            Objects.requireNonNull(msTestReportParser);
            this.this$0 = msTestReportParser;
        }

        public void onText(ETrxElement element, String text) {
            this.this$0.currentTest.setFailureMessage(text);
        }
    };

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        String textContent = XMLUtils.fixIllegalXmlChars((String)report);
        ElementEnumSaxHandler saxHandler = new ElementEnumSaxHandler((Enum)ETrxElement.TESTRUN);
        saxHandler.setElementHandler((Enum)ETrxElement.UNITTEST, this.unitTestHandler);
        saxHandler.setElementHandler((Enum)ETrxElement.TESTMETHOD, this.unitTestHandler);
        MsTestReportParser.parseSax((ElementEnumSaxHandler<ETrxElement>)saxHandler, textContent);
        saxHandler = new ElementEnumSaxHandler((Enum)ETrxElement.TESTRUN);
        saxHandler.setElementHandler((Enum)ETrxElement.UNITTESTRESULT, this.testResultHandler);
        saxHandler.setElementHandler((Enum)ETrxElement.ERRORINFO, this.errorInfoHandler);
        MsTestReportParser.parseSax((ElementEnumSaxHandler<ETrxElement>)saxHandler, textContent);
    }

    private static void parseSax(ElementEnumSaxHandler<ETrxElement> saxHandler, String textContent) throws ReportParserException {
        try {
            XMLUtils.parseSAX((InputSource)XMLUtils.toInputSource((String)textContent), saxHandler);
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private static Optional<Duration> parseExecutionTime(Attributes attributes) throws SAXException {
        String durationString = attributes.getValue(ETrxAttribute.duration.name());
        if (durationString == null) {
            return Optional.empty();
        }
        try {
            LocalTime duration = LocalTime.parse(durationString);
            return Optional.of(Duration.ofNanos(duration.toNanoOfDay()));
        }
        catch (DateTimeParseException e) {
            throw new SAXException("Unexpected execution time format: " + durationString, e);
        }
    }
}

