/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.nunit;

import com.teamscale.index.report.testexecution.TestReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Objects;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class NUnitReportParser
extends TestReportParserBase {
    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            XMLUtils.parseSAX((String)report, (DefaultHandler)new NUnitSaxHandler(this));
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private class NUnitSaxHandler
    extends DefaultHandler {
        private static final String TEST_CASE_ELEMENT = "test-case";
        private static final String MESSAGE_ELEMENT = "message";
        private static final String STACK_TRACE_ELEMENT = "stack-trace";
        private static final String FAILURE_ELEMENT = "failure";
        private TestExecution.Builder currentTestCase;
        private final StringBuilder currentText;
        private final StringBuilder currentFailureMessage;
        final /* synthetic */ NUnitReportParser this$0;

        private NUnitSaxHandler(NUnitReportParser nUnitReportParser) {
            NUnitReportParser nUnitReportParser2 = nUnitReportParser;
            Objects.requireNonNull(nUnitReportParser2);
            this.this$0 = nUnitReportParser2;
            this.currentText = new StringBuilder();
            this.currentFailureMessage = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentText.setLength(0);
            if (TEST_CASE_ELEMENT.equals(localName)) {
                this.enterTestCase(attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (localName) {
                case "test-case": {
                    this.this$0.reportTestExecution(this.currentTestCase);
                    this.currentTestCase = null;
                    break;
                }
                case "failure": {
                    this.setFailureMessage();
                    break;
                }
                case "message": 
                case "stack-trace": {
                    this.appendToFailureMessage(localName);
                    break;
                }
            }
        }

        private void appendToFailureMessage(String localName) {
            if (this.currentTestCase == null) {
                return;
            }
            if (localName.equals(MESSAGE_ELEMENT)) {
                this.currentFailureMessage.append((CharSequence)this.currentText);
            } else if (localName.equals(STACK_TRACE_ELEMENT)) {
                this.currentFailureMessage.append("\n").append((CharSequence)this.currentText);
            }
        }

        private void setFailureMessage() {
            if (this.currentTestCase == null) {
                return;
            }
            this.currentTestCase.setFailureMessage(this.currentFailureMessage.toString());
        }

        private void enterTestCase(Attributes attributes) throws SAXException {
            String result;
            if (this.currentTestCase != null) {
                throw new SAXException("Not expecting nested test cases!");
            }
            this.currentFailureMessage.setLength(0);
            this.initializeCurrentTestCase(attributes);
            this.setDuration(attributes);
            switch (result = attributes.getValue("result")) {
                case "Passed": 
                case "Success": {
                    this.currentTestCase.setResult(ETestExecutionResult.PASSED);
                    break;
                }
                case "Failed": 
                case "Failure": {
                    this.currentTestCase.setResult(ETestExecutionResult.FAILURE);
                    break;
                }
                case "Error": {
                    this.currentTestCase.setResult(ETestExecutionResult.ERROR);
                    break;
                }
                case "Inconclusive": {
                    this.currentTestCase.setResult(ETestExecutionResult.INCONCLUSIVE);
                    break;
                }
                case "Skipped": {
                    this.currentTestCase.setResult(ETestExecutionResult.SKIPPED);
                    break;
                }
                default: {
                    this.currentTestCase.setResult(ETestExecutionResult.IGNORED);
                }
            }
        }

        private void initializeCurrentTestCase(Attributes attributes) {
            String name = attributes.getValue("fullname");
            if (name == null) {
                name = attributes.getValue("name");
            }
            String path = NUnitSaxHandler.convertNameToPath(name);
            this.currentTestCase = TestExecution.Builder.fromRelativePath((String)path);
        }

        private static String convertNameToPath(String name) {
            int parenthesesNestingDepth = 0;
            StringBuilder path = new StringBuilder();
            for (char c : name.toCharArray()) {
                if (c == '(') {
                    ++parenthesesNestingDepth;
                } else if (c == ')') {
                    --parenthesesNestingDepth;
                }
                if (c == '.' && parenthesesNestingDepth == 0) {
                    path.append("/");
                    continue;
                }
                if (c == '.' && parenthesesNestingDepth > 0) {
                    path.append(c);
                    continue;
                }
                path.append(UniformPath.escapeSegment((String)String.valueOf(c)));
            }
            return path.toString();
        }

        private void setDuration(Attributes attributes) {
            String duration = attributes.getValue("duration");
            String time = attributes.getValue("time");
            if (duration != null) {
                this.currentTestCase.setDurationInSeconds(Double.parseDouble(duration));
            } else if (time != null) {
                this.currentTestCase.setDurationInSeconds(Double.parseDouble(time));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currentTestCase != null) {
                this.currentText.append(ch, start, length);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

