/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.xunit;

import com.teamscale.index.report.testexecution.TestReportParserBase;
import com.teamscale.index.report.testexecution.xunit.EXUnitAttribute;
import com.teamscale.index.report.testexecution.xunit.EXUnitElement;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Objects;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.ElementEnumSaxHandler;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XUnitReportParser
extends TestReportParserBase {
    private TestExecution.Builder currentResult;
    private final ElementEnumSaxHandler.ElementHandler<EXUnitElement> failureHandler = new ElementEnumSaxHandler.TextElementHandler<EXUnitElement>(this){
        final /* synthetic */ XUnitReportParser this$0;
        {
            XUnitReportParser xUnitReportParser = this$0;
            Objects.requireNonNull(xUnitReportParser);
            this.this$0 = xUnitReportParser;
        }

        public void onText(EXUnitElement element, String text) {
            this.this$0.currentResult.setFailureMessage(text);
        }
    };
    private final ElementEnumSaxHandler.ElementHandler<EXUnitElement> testHandler = new ElementEnumSaxHandler.ElementHandler<EXUnitElement>(this){
        final /* synthetic */ XUnitReportParser this$0;
        {
            XUnitReportParser xUnitReportParser = this$0;
            Objects.requireNonNull(xUnitReportParser);
            this.this$0 = xUnitReportParser;
        }

        public void onStartElement(EXUnitElement element, Attributes attributes) throws SAXException {
            if (this.this$0.currentResult != null) {
                throw new SAXException("Not expecting nested test cases!");
            }
            String className = XUnitReportParser.getAttribute(attributes, EXUnitAttribute.TYPE);
            String qualifiedName = XUnitReportParser.getAttribute(attributes, EXUnitAttribute.NAME);
            String name = StringUtils.stripPrefix((String)qualifiedName, (String)(className + "."));
            this.this$0.currentResult = TestExecution.Builder.fromClassAndName((String)className, (String)name);
            String result = XUnitReportParser.getAttribute(attributes, EXUnitAttribute.RESULT);
            this.this$0.currentResult.setResult(this.testOutcomeToResult(result));
            String timeString = XUnitReportParser.getAttribute(attributes, EXUnitAttribute.TIME);
            if (!StringUtils.isEmpty((String)timeString)) {
                this.this$0.currentResult.setDurationInSeconds(Double.parseDouble(timeString));
            }
        }

        public void onEndElement(EXUnitElement exUnitElement) throws SAXException {
            this.this$0.reportTestExecution(this.this$0.currentResult);
            this.this$0.currentResult = null;
        }

        private ETestExecutionResult testOutcomeToResult(String testOutcome) {
            switch (testOutcome) {
                case "Pass": {
                    return ETestExecutionResult.PASSED;
                }
                case "Skip": {
                    return ETestExecutionResult.SKIPPED;
                }
                case "Fail": {
                    return ETestExecutionResult.FAILURE;
                }
            }
            return ETestExecutionResult.IGNORED;
        }
    };

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        ElementEnumSaxHandler saxHandler = new ElementEnumSaxHandler((Enum)EXUnitElement.TEST);
        saxHandler.setElementHandler((Enum)EXUnitElement.TEST, this.testHandler);
        saxHandler.setElementHandler((Enum)EXUnitElement.FAILURE, this.failureHandler);
        try {
            XMLUtils.parseSAX((String)report, (DefaultHandler)saxHandler);
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private static String getAttribute(Attributes attributes, Enum<?> name) {
        return attributes.getValue(name.name().toLowerCase());
    }
}

