/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.RepositoryChangeEntry;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ReportMappingSupport {
    public static final String REPORT_MAPPING_PARAMETER = "report-mapping";
    @StepParameter(value="report-mapping", optional=true)
    private final PairList<String, EReportFormat> reportMapping = new PairList();
    private PairList<Pattern, EReportFormat> compiledReportMapping;

    public Optional<EReportFormat> determineReportFormat(RepositoryChangeEntry changeEntry) throws ConQATException {
        return this.determineReportFormat(changeEntry.getRepositoryPath());
    }

    public Optional<EReportFormat> determineReportFormat(UniformPath repositoryPath) throws ConQATException {
        if (this.compiledReportMapping == null) {
            this.compiledReportMapping = this.reportMapping.mapFirst(s -> AntPatternUtils.convertPatternSafe((String)s, (boolean)false));
        }
        for (int i = 0; i < this.compiledReportMapping.size(); ++i) {
            if (!((Pattern)this.compiledReportMapping.getFirst(i)).matcher(repositoryPath.toString()).matches()) continue;
            return Optional.of((EReportFormat)((Object)this.compiledReportMapping.getSecond(i)));
        }
        return Optional.empty();
    }

    public boolean isReportPath(RepositoryChangeEntry entry) throws ConQATException {
        return this.determineReportFormat(entry).isPresent();
    }

    public boolean hasCoverageOrTestExecutionsReportsEnabled() {
        return CollectionUtils.anyMatch((Collection)this.reportMapping.extractSecondList(), reportFormat -> reportFormat.containsCoverage() || reportFormat.containsTestExecutions());
    }
}

