/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.ICommitDescriptorSerializer;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class RepositoryChangeIndexBase
extends IndexBase
implements IRollbackableIndex {
    private static final String SEPARATOR = ";-;";
    private static final String FILES_KEY_PREFIX = "files:";
    private static final byte[] ROLLBACK_KEY_PREFIX = org.conqat.lib.commons.string.StringUtils.stringToBytes((String)"rollback:");
    private static final ICommitDescriptorSerializer COMMIT_DESCRIPTOR_SERIALIZER = ICommitDescriptorSerializer.BranchTimestamp.COMPACT;

    protected RepositoryChangeIndexBase(IStore store) {
        super(store);
    }

    public static List<String> getPathAndRevisionsFromKeys(List<String> keys) {
        return CollectionUtils.filterAndMap(keys, key -> key.startsWith(FILES_KEY_PREFIX), key -> org.conqat.lib.commons.string.StringUtils.stripPrefix((String)key, (String)FILES_KEY_PREFIX));
    }

    public void addChangedFiles(List<RepositoryChangeEntry> entries) throws StorageException {
        PairList values = new PairList();
        for (RepositoryChangeEntry entry : entries) {
            UniformPath originPath = entry.getOriginPath();
            String valueAsString = entry.getChangeType().name() + SEPARATOR + String.valueOf(entry.getCommit()) + SEPARATOR + entry.getChangeEntryOrigin().name();
            if (originPath != null) {
                valueAsString = valueAsString + SEPARATOR + String.valueOf(Objects.requireNonNull(entry.getOriginCommit())) + SEPARATOR + String.valueOf(originPath);
            }
            byte[] fileKey = org.conqat.lib.commons.string.StringUtils.stringToBytes((String)RepositoryChangeIndexBase.makeFileKey(entry.getRepositoryPath(), entry.getRevision(), entry.getCommit().getBranchName()));
            values.add((Object)fileKey, (Object)org.conqat.lib.commons.string.StringUtils.stringToBytes((String)valueAsString));
            values.add((Object)RepositoryChangeIndexBase.makeRollbackKey(entry.getCommit(), fileKey), (Object)fileKey);
        }
        this.store.put(values);
    }

    private static byte[] makeRollbackKey(CommitDescriptor commit, byte[] fileKey) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ROLLBACK_KEY_PREFIX, COMMIT_DESCRIPTOR_SERIALIZER.serialize(commit), ByteArrayUtils.longToByteArray((long)XXHashUtils.xxhash64((byte[])fileKey))});
    }

    public static String makeFileKey(UniformPath path, String revision, String branchName) {
        return FILES_KEY_PREFIX + path.toString() + SEPARATOR + revision + SEPARATOR + branchName;
    }

    public List<RepositoryChangeEntry> getEntries(List<String> pathAndRevisions, boolean preserveNull) throws StorageException {
        ArrayList<CallSite> keys = new ArrayList<CallSite>();
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> revisions = new ArrayList<String>();
        for (String pathAndRevision : pathAndRevisions) {
            String revision = RepositoryChangeIndexBase.getRevisionPart(pathAndRevision);
            revisions.add(revision);
            String path = RepositoryChangeIndexBase.getPathPart(pathAndRevision);
            paths.add(path);
            keys.add((CallSite)((Object)(FILES_KEY_PREFIX + pathAndRevision)));
        }
        List bytes = this.store.getWithStrings(keys);
        ArrayList<RepositoryChangeEntry> result = new ArrayList<RepositoryChangeEntry>();
        for (int i = 0; i < bytes.size(); ++i) {
            if (bytes.get(i) != null) {
                result.add(RepositoryChangeIndexBase.buildEntry((String)paths.get(i), (String)revisions.get(i), (byte[])bytes.get(i)));
                continue;
            }
            if (!preserveNull) continue;
            result.add(null);
        }
        return result;
    }

    public List<RepositoryChangeEntry> getEntriesForCommit(CommitDescriptor commit) throws StorageException {
        ArrayList fileKeys = new ArrayList();
        this.store.scan(ByteArrayUtils.concat((byte[][])new byte[][]{ROLLBACK_KEY_PREFIX, COMMIT_DESCRIPTOR_SERIALIZER.serialize(commit)}), (key, value) -> {
            List list = fileKeys;
            synchronized (list) {
                fileKeys.add(value);
            }
        });
        List values = this.store.get(fileKeys);
        ArrayList<RepositoryChangeEntry> entries = new ArrayList<RepositoryChangeEntry>();
        for (int i = 0; i < fileKeys.size(); ++i) {
            String[] parts = StringUtils.splitByWholeSeparator((String)org.conqat.lib.commons.string.StringUtils.stripPrefix((String)org.conqat.lib.commons.string.StringUtils.bytesToString((byte[])((byte[])fileKeys.get(i))), (String)FILES_KEY_PREFIX), (String)SEPARATOR);
            entries.add(RepositoryChangeIndexBase.buildEntry(parts[0], parts[1], (byte[])values.get(i)));
        }
        return entries;
    }

    private static String getPathPart(String pathAndRevision) {
        return StringUtils.splitByWholeSeparator((String)pathAndRevision, (String)SEPARATOR, (int)2)[0];
    }

    private static String getRevisionPart(String pathAndRevision) {
        return pathAndRevision.split(SEPARATOR, 3)[1];
    }

    private static RepositoryChangeEntry buildEntry(String path, String revision, byte[] valueBytes) {
        String valueAsString = org.conqat.lib.commons.string.StringUtils.bytesToString((byte[])valueBytes);
        String[] parts = StringUtils.splitByWholeSeparator((String)valueAsString, (String)SEPARATOR);
        ERepositoryChangeType changeType = Enum.valueOf(ERepositoryChangeType.class, parts[0]);
        CommitDescriptor commit = CommitDescriptor.fromStringRepresentation((String)parts[1]);
        EChangeEntryOrigin changeEntryOrigin = Enum.valueOf(EChangeEntryOrigin.class, parts[2]);
        CommitDescriptor originCommit = null;
        UniformPath originPath = null;
        if (parts.length == 5) {
            originCommit = CommitDescriptor.fromStringRepresentation((String)parts[3]);
            originPath = UniformPath.parse((String)parts[4]);
        }
        return new RepositoryChangeEntry(UniformPath.parse((String)path), revision, changeType, commit, originPath, originCommit, changeEntryOrigin);
    }

    public Set<RepositoryChangeEntry> getChanges() throws StorageException {
        HashSet<RepositoryChangeEntry> result = new HashSet<RepositoryChangeEntry>();
        this.store.scan(FILES_KEY_PREFIX, (key, value) -> {
            String pathAndRevision = org.conqat.lib.commons.string.StringUtils.stripPrefix((String)org.conqat.lib.commons.string.StringUtils.bytesToString((byte[])key), (String)FILES_KEY_PREFIX);
            Set set = result;
            synchronized (set) {
                result.add(RepositoryChangeIndexBase.buildEntry(RepositoryChangeIndexBase.getPathPart(pathAndRevision), RepositoryChangeIndexBase.getRevisionPart(pathAndRevision), value));
            }
        });
        return result;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        List deleteKeys = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<String, Long> branchAndPreserveTimestamp : timestampByBranch.entrySet()) {
            long preserveTimestamp = branchAndPreserveTimestamp.getValue();
            byte[] prefix = ByteArrayUtils.concat((byte[][])new byte[][]{ROLLBACK_KEY_PREFIX, org.conqat.lib.commons.string.StringUtils.stringToBytes((String)branchAndPreserveTimestamp.getKey())});
            int expectedLength = prefix.length + 16;
            this.store.scan(prefix, (key, value) -> {
                if (key.length == expectedLength && RepositoryChangeIndexBase.extractTimestampFromRollbackKey(key) > preserveTimestamp) {
                    deleteKeys.add(key);
                    deleteKeys.add(value);
                }
            });
        }
        if (!deleteKeys.isEmpty()) {
            this.store.remove(deleteKeys);
        }
    }

    private static long extractTimestampFromRollbackKey(byte[] key) {
        byte[] part = Arrays.copyOfRange(key, key.length - 16, key.length - 8);
        return ByteArrayUtils.byteArrayToLong((byte[])part);
    }
}

