/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.committree.CommitSchedulingResult;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class RepositoryChangeRetrieverUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<IPostTriggerAction.IChangeRetrieverPostTriggerAction> extractResultCommitAndPersist(CommitTreeNode commitTreeNode, IChangeRetrieverCommitTree commitTree, ICommitTreeNodeAdjuster commitTreeNodeAdjuster, Predicate<CommitTreeNode> skipOracle, ICommitTreeExpansion expandCommitTree, int pollingIntervalSeconds) throws StorageException, RepositoryException, RescheduleRequestedException {
        if (!commitTree.wasExpandedWithinTimespan(pollingIntervalSeconds) && (RepositoryChangeRetrieverUtils.isLastNodeOnBranch(commitTreeNode, commitTree) || RepositoryChangeRetrieverUtils.isTreeExhausted(commitTree))) {
            LOGGER.debug("Performing commit tree expansion during extractResultCommitAndPersist");
            RepositoryChangeRetrieverUtils.expandCommitTree(commitTree, expandCommitTree);
            commitTreeNodeAdjuster.adjustTimestamps(commitTree.getAllRawNodes());
        }
        CommitSchedulingResult commitSchedulingResult = commitTree.extractAndUpdateSchedulableCommits(skipOracle);
        commitTree.persist();
        List actions = commitSchedulingResult.actions(false);
        LOGGER.debug("Resulting actions: {}.", (Object)actions);
        return actions;
    }

    public static CommitTreeExpansionResult expandCommitTree(IChangeRetrieverCommitTree commitTree, ICommitTreeExpansion expandCommitTree) throws RepositoryException, RescheduleRequestedException {
        CommitTreeExpansionResult expansionResult = expandCommitTree.apply(commitTree);
        if (expansionResult.fullyExpanded) {
            commitTree.setLastExpanded(Instant.now().toEpochMilli());
        } else {
            commitTree.resetLastExpandedTimestamp();
        }
        return expansionResult;
    }

    private static boolean isTreeExhausted(IChangeRetrieverCommitTree commitTree) {
        return !commitTree.hasSchedulableNodes() && !commitTree.hasScheduledNodes();
    }

    private static boolean isLastNodeOnBranch(CommitTreeNode commitTreeNode, IChangeRetrieverCommitTree commitTree) {
        String revision = commitTreeNode.getRevision().getRevision();
        return commitTree.getLatestContainedRevisionForBranch((ICommitTreeNode)commitTreeNode).map(revision::equals).orElse(false);
    }

    public static Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> resetCommitTreeWithRollbackAction(CommitDescriptor originalInputCommit, CommitTreeIndex commitTreeIndex, @Nullable BranchRenamingCommitTreeFacade branchRenamingFacade, RepositoryNeedsRollbackException ... previousRollbackExceptions) throws StorageException {
        ArrayList<RepositoryNeedsRollbackException> allRollbackExceptions = new ArrayList<RepositoryNeedsRollbackException>(Arrays.asList(previousRollbackExceptions));
        UUID rollbackId = RepositoryChangeRetrieverUtils.extractRollbackId(allRollbackExceptions);
        try {
            RepositoryChangeRetrieverUtils.resetCommitTree(originalInputCommit, commitTreeIndex, rollbackId);
        }
        catch (RepositoryNeedsRollbackException e) {
            allRollbackExceptions.add(e);
        }
        if (allRollbackExceptions.isEmpty()) {
            return Collections.emptyList();
        }
        RollbackRequest rollbackRequest = RepositoryChangeRetrieverUtils.createRollbackRequestForExceptions(allRollbackExceptions, rollbackId, branchRenamingFacade);
        LOGGER.warn(rollbackRequest.reason());
        return List.of(new IPostTriggerAction.RequestRollback(rollbackRequest));
    }

    private static UUID extractRollbackId(List<RepositoryNeedsRollbackException> rollbackExceptions) {
        Set rollbackIds = CollectionUtils.mapToSet(rollbackExceptions, RepositoryNeedsRollbackException::getRollbackId);
        if (rollbackIds.isEmpty()) {
            return UUID.randomUUID();
        }
        if (rollbackIds.size() > 1) {
            LOGGER.warn("Clashing rollback IDs: {}", (Object)StringUtils.concat((Iterable)rollbackIds, (String)", "));
        }
        return (UUID)CollectionUtils.getAny((Iterable)rollbackIds);
    }

    private static RollbackRequest createRollbackRequestForExceptions(List<RepositoryNeedsRollbackException> exceptions, UUID rollbackId, @Nullable BranchRenamingCommitTreeFacade branchRenamingCommitTreeFacade) {
        HashSet rollbackCommits = new HashSet();
        StringBuilder rollbackReason = new StringBuilder();
        for (RepositoryNeedsRollbackException exception : exceptions) {
            rollbackCommits.addAll(exception.getRollbackToAsSchedulingHints());
            rollbackReason.append(exception.getMessage()).append(" Rollback requested to:\n").append(exception.getRollbackToAsSchedulingHints()).append("\n");
        }
        if (branchRenamingCommitTreeFacade != null) {
            HashSet renamedCommitDescriptors = HashSet.newHashSet(rollbackCommits.size());
            for (CommitDescriptor commitDescriptor : rollbackCommits) {
                String renamedBranch = branchRenamingCommitTreeFacade.renameBranch(commitDescriptor.getBranchName());
                renamedCommitDescriptors.add(new CommitDescriptor(renamedBranch, commitDescriptor.getTimestamp()));
            }
            rollbackCommits.addAll(renamedCommitDescriptors);
        }
        return new RollbackRequest(rollbackCommits, rollbackReason.toString(), rollbackId);
    }

    private static void resetCommitTree(CommitDescriptor originalInputCommit, CommitTreeIndex commitTreeIndex, UUID rollbackId) throws StorageException, RepositoryNeedsRollbackException {
        if (originalInputCommit == null) {
            return;
        }
        CommitTree commitTree = commitTreeIndex.loadTree();
        if (commitTree.hasScheduledAdjustedCommit(originalInputCommit)) {
            CommitTreeNode scheduledNode = commitTree.findScheduledNodeByAdjustedCommitDescriptor(originalInputCommit, rollbackId);
            scheduledNode.resetScheduledNode();
        }
        commitTree.resetLastExpandedTimestamp();
        commitTree.persist();
    }

    public static CommitTreeNode extractNextCommitTreeNode(IChangeRetrieverCommitTree commitTree, CommitDescriptor inputCommit, ICommitTreeExpansion expandCommitTree, ICommitTreeNodeAdjuster commitTreeNodeAdjuster, int pollingIntervalSeconds) throws StorageException, RescheduleRequestedException, RepositoryException {
        CommitTreeNode commitTreeNode = null;
        if (inputCommit != null) {
            commitTreeNode = commitTree.findScheduledNodeByAdjustedCommitDescriptor(inputCommit);
            if (commitTreeNode == null) {
                LOGGER.error("Had direct scheduling of commit {} for which no scheduled node exists in commit tree. Falling back to finding another node that can be scheduled.", (Object)inputCommit);
            } else if (commitTreeNode.getState() != ECommitTreeNodeState.SCHEDULED) {
                String message = "Had direct scheduling of commit " + String.valueOf(inputCommit) + " which is not in state SCHEDULED.";
                LOGGER.error(() -> message + " Performing rollback to restore valid state.");
                throw new RepositoryNeedsRollbackException(message, Map.of(inputCommit.getBranchName(), inputCommit.getTimestamp() - 1L));
            }
        }
        if (commitTreeNode == null) {
            LOGGER.debug("No scheduled node found, searching for schedulable node");
            commitTreeNode = commitTree.getNextSchedulableNode();
            if (commitTreeNode == null && !commitTree.wasExpandedWithinTimespan(pollingIntervalSeconds)) {
                LOGGER.debug("No schedulable node found, expanding commit tree");
                RepositoryChangeRetrieverUtils.expandCommitTree(commitTree, expandCommitTree);
                commitTreeNodeAdjuster.adjustTimestamps(commitTree.getAllRawNodes());
                commitTreeNode = commitTree.getNextSchedulableNode();
                commitTree.persist();
            }
        }
        LOGGER.debug("Selected commit tree node: {}", (Object)commitTreeNode);
        return commitTreeNode;
    }

    public static List<? extends ICommitTreeNode> determineNonEmptyParentsIncludingForkInformation(ICommitTreeNode commitTreeNode, IRepositoryConnection repositoryConnection, CommitDescriptorIndex commitDescriptorIndex, BranchRenamingCommitTreeFacade branchRenamingFacade) throws StorageException {
        List<ICommitTreeNode> nonEmptyParents = commitTreeNode.getNonEmptyParents();
        if (nonEmptyParents.isEmpty()) {
            LOGGER.debug("No non empty parents for commit revision {} found. Parent revisions: {}", (Object)commitTreeNode.getRevision(), (Object)commitTreeNode.getParentRevisions());
        }
        if (nonEmptyParents.isEmpty() && repositoryConnection.shouldInheritForkInformation()) {
            nonEmptyParents = RepositoryChangeRetrieverUtils.determineParentsFromInheritedForkInformation(commitTreeNode.getRevision().getBranchName(), commitDescriptorIndex, branchRenamingFacade);
        }
        return nonEmptyParents;
    }

    private static List<ICommitTreeNode> determineParentsFromInheritedForkInformation(String currentBranchName, CommitDescriptorIndex commitDescriptorIndex, BranchRenamingCommitTreeFacade branchRenamingFacade) throws StorageException {
        List allNodesOnBranch = commitDescriptorIndex.getCommitsForBranch(currentBranchName);
        if (allNodesOnBranch.isEmpty()) {
            return Collections.emptyList();
        }
        ParentedCommitDescriptor firstCommitOnBranch = (ParentedCommitDescriptor)allNodesOnBranch.getFirst();
        CommitDescriptor firstParentCommit = firstCommitOnBranch.getFirstParentCommit();
        if (firstParentCommit == null) {
            return Collections.emptyList();
        }
        if (firstParentCommit.isOnBranch(currentBranchName)) {
            throw new AssertionError((Object)("Expected first commit " + String.valueOf(firstCommitOnBranch) + " to have a parent from a different branch, but both are on the same branch."));
        }
        String otherBranchName = firstParentCommit.getBranchName();
        Optional<String> latestRevision = branchRenamingFacade.resolveLatestRevisionBefore(otherBranchName, firstParentCommit.getTimestamp());
        return latestRevision.map(s -> Collections.singletonList(branchRenamingFacade.getNodeByRevision(new CommitTreeRevision(s, otherBranchName)))).orElse(Collections.emptyList());
    }

    public static @Nullable RepositoryChangeSet determineChangeSet(ICommitTreeNode originalNode, ICommitTreeNode ancestorNode, BranchRenamingCommitTreeFacade branchRenamingFacade, IRepositoryConnection repositoryConnection) throws RepositoryException {
        if (!repositoryConnection.supportsSkipping() && originalNode.getParentRevisions().isEmpty()) {
            throw new RepositoryException("May not call this method for revision " + String.valueOf(originalNode.getRevision()) + " without parents!");
        }
        if (repositoryConnection.supportsSkipping() || ((CommitTreeRevision)originalNode.getParentRevisions().getFirst()).equals((Object)ancestorNode.getRevision())) {
            return repositoryConnection.getChangeSet(branchRenamingFacade.unrenameBranch(originalNode), branchRenamingFacade.unrenameBranch(ancestorNode));
        }
        return RepositoryChangeRetrieverUtils.collectChangeSetTransitively(originalNode, ancestorNode, branchRenamingFacade, repositoryConnection);
    }

    private static @Nullable RepositoryChangeSet collectChangeSetTransitively(ICommitTreeNode originalNode, ICommitTreeNode ancestorNode, BranchRenamingCommitTreeFacade branchRenamingFacade, IRepositoryConnection repositoryConnection) throws RepositoryException {
        LOGGER.traceEntry("Collecting changes for revisions {} to {}.", new Object[]{ancestorNode.getRevision().getRevision(), originalNode.getRevision().getRevision()});
        ArrayList<RepositoryChangeSet> changeSets = new ArrayList<RepositoryChangeSet>();
        ICommitTreeNode branchRenamingAncestorNode = branchRenamingFacade.getNodeByRevision(ancestorNode.getRevision());
        Preconditions.checkNotNull((Object)branchRenamingAncestorNode, (Object)("Failed to resolve ancestor node from " + String.valueOf(ancestorNode)));
        ICommitTreeNode node = originalNode;
        while (!node.getRevision().equals((Object)branchRenamingAncestorNode.getRevision())) {
            if (node.getParentRevisions().isEmpty()) {
                LOGGER.warn("Did not find expected parent {} while traversing parent history of {}.", (Object)ancestorNode.getRevision(), (Object)originalNode.getRevision());
                break;
            }
            ICommitTreeNode directParent = branchRenamingFacade.getNodeByRevision((CommitTreeRevision)node.getParentRevisions().getFirst());
            Preconditions.checkNotNull((Object)directParent, (Object)("Failed to resolve direct parent of " + String.valueOf(node)));
            RepositoryChangeSet localChange = repositoryConnection.getChangeSet(branchRenamingFacade.unrenameBranch(node), branchRenamingFacade.unrenameBranch(directParent));
            if (localChange != null) {
                LOGGER.debug("Adding changeset with ID {} to the list of changes between revisions {} and {}.", (Object)localChange.getRevision(), (Object)ancestorNode.getRevision().getRevision(), (Object)originalNode.getRevision().getRevision());
                changeSets.add(localChange);
            }
            node = directParent;
        }
        if (changeSets.isEmpty()) {
            return (RepositoryChangeSet)((Object)LOGGER.traceExit((Object)((RepositoryChangeSet)null)));
        }
        RepositoryChangeSet changeSet = ((RepositoryChangeSet)((Object)changeSets.getFirst())).cloneWithoutChanges();
        Collections.reverse(changeSets);
        changeSets.forEach(changeSet::applyChanges);
        return (RepositoryChangeSet)((Object)LOGGER.traceExit((Object)changeSet));
    }

    private RepositoryChangeRetrieverUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    @FunctionalInterface
    public static interface ICommitTreeExpansion {
        public CommitTreeExpansionResult apply(IChangeRetrieverCommitTree var1) throws RepositoryException, RescheduleRequestedException;
    }
}

