/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeIndexBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class RepositoryChangesProcessorBase
extends ChangeProcessorAnalysisStep {
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_ONLY)
    protected RepositoryChangeIndex changeIndex;
    @DeltaSource.Dynamic(value=RepositoryChangeIndex.class)
    protected KeyDelta changeDelta;

    public void execute() throws ConQATException, RepositoryException {
        List<String> pathAndRevisions = RepositoryChangeIndexBase.getPathAndRevisionsFromKeys(this.changeDelta.getAddedOrChangedKeysAsStrings());
        if (pathAndRevisions.isEmpty()) {
            return;
        }
        List<RepositoryChangeEntry> allEntries = this.changeIndex.getEntriesForCommit(this.getSchedulingCommit());
        if (pathAndRevisions.size() == 1 && pathAndRevisions.getFirst().startsWith(RepositoryChangeRetrieverBase.EMPTY_CHANGES_DUMMY_PATH.toString())) {
            this.processChangedEntries(new ArrayList<RepositoryChangeEntry>(), new ArrayList<RepositoryChangeEntry>(), true);
        } else {
            UniformPath firstPath = allEntries.stream().map(RepositoryChangeEntry::getRepositoryPath).min(Comparator.naturalOrder()).orElseThrow(() -> new ConQATException("Expected non-empty set of changed paths!"));
            List<RepositoryChangeEntry> entries = this.changeIndex.getEntries(pathAndRevisions, false);
            boolean entriesContainsFirstPath = entries.stream().map(RepositoryChangeEntry::getRepositoryPath).anyMatch(arg_0 -> ((UniformPath)firstPath).equals(arg_0));
            this.processChangedEntries(entries, allEntries, entriesContainsFirstPath);
        }
    }

    public boolean shouldRescheduleOnError() {
        return true;
    }

    protected abstract void processChangedEntries(List<RepositoryChangeEntry> var1, List<RepositoryChangeEntry> var2, boolean var3) throws ConQATException, RepositoryException;
}

