/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.utils.ExternalUploadUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class RepositoryLastChangeUtils {
    public static Optional<RepositoryLogEntryAggregate> findLastChangeForElement(String uniformPath, CommitDescriptor endCommit, boolean excludeNonCodeCommits, ProjectStorageSystem projectStorageSystem, Logger logger) throws StorageException {
        ElementHistoryIndex elementHistoryIndex = (ElementHistoryIndex)projectStorageSystem.openProjectIndex(ElementHistoryIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)endCommit));
        ElementHistoryEntry lastEntry = elementHistoryIndex.getHistoryEntry(uniformPath);
        if (lastEntry == null) {
            return Optional.empty();
        }
        RepositoryLogIndex repoLogIndex = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        RepositoryLogEntryAggregate result = (RepositoryLogEntryAggregate)repoLogIndex.getEntry(lastEntry.getCommit());
        if (result == null) {
            return Optional.empty();
        }
        if (!excludeNonCodeCommits || result.containsConnectorIdentifier(ExternalUploadUtils::isCodeCommit)) {
            return Optional.of(result);
        }
        return RepositoryLastChangeUtils.findCodeCommitInRawStore(uniformPath, endCommit, repoLogIndex, projectStorageSystem, logger);
    }

    public static Optional<RepositoryLogEntryAggregate> findLastRepositoryEntryOfType(CommitDescriptor endCommit, ECommitType commitType, SchemaAwareStorageSystem projectStorageSystem) throws StorageException {
        RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)projectStorageSystem.openIndex(RepositoryLogIndex.class);
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openIndex(CommitDescriptorIndex.class);
        return RepositoryLastChangeUtils.findLastRepositoryEntryOfType(endCommit, Set.of(commitType), repositoryLogIndex, commitDescriptorIndex);
    }

    private static Optional<RepositoryLogEntryAggregate> findLastRepositoryEntryOfType(CommitDescriptor endCommit, Set<ECommitType> commitTypes, RepositoryLogIndex repositoryLogIndex, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        LinkedList<CommitDescriptor> worklist = new LinkedList<CommitDescriptor>();
        worklist.push(endCommit);
        while (!worklist.isEmpty()) {
            CommitDescriptor work = (CommitDescriptor)worklist.pop();
            @Nullable ParentedCommitDescriptor workCommitDescriptor = commitDescriptorIndex.getCommit(work);
            if (workCommitDescriptor == null) {
                return Optional.empty();
            }
            @Nullable RepositoryLogEntryAggregate workCommitLog = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(work);
            if (workCommitLog != null && CollectionUtils.containsAny(workCommitLog.getCommitTypes(), commitTypes)) {
                return Optional.of(workCommitLog);
            }
            workCommitDescriptor.getParentCommits().forEach(worklist::push);
        }
        return Optional.empty();
    }

    public static Optional<CommitDescriptor> findLastCommitOfType(CommitDescriptor endCommit, ECommitType commitType, RepositoryLogIndex repositoryLogIndex, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        return RepositoryLastChangeUtils.findLastCommitOfType(endCommit, Set.of(commitType), repositoryLogIndex, commitDescriptorIndex);
    }

    public static Optional<CommitDescriptor> findLastCommitOfType(CommitDescriptor endCommit, Set<ECommitType> commitTypes, RepositoryLogIndex repositoryLogIndex, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        Optional<RepositoryLogEntryAggregate> result = RepositoryLastChangeUtils.findLastRepositoryEntryOfType(endCommit, commitTypes, repositoryLogIndex, commitDescriptorIndex);
        return result.map(CommitAssociatedObjectBase::getCommit);
    }

    public static Optional<RepositoryLogEntryAggregate> findLastChangeForElementExcludingExternalUploads(String uniformPath, CommitDescriptor endCommit, RepositoryLogIndex repoLogIndex, ProjectStorageSystem projectStorageSystem, Logger logger) throws StorageException {
        return RepositoryLastChangeUtils.findCodeCommitInRawStore(uniformPath, endCommit, repoLogIndex, projectStorageSystem, logger);
    }

    private static Optional<RepositoryLogEntryAggregate> findCodeCommitInRawStore(String uniformPath, CommitDescriptor endCommit, RepositoryLogIndex repoLogIndex, ProjectStorageSystem projectStorageSystem, Logger logger) throws StorageException {
        IBranchingLayer elementHistoryBranchingLayer = projectStorageSystem.openBranchingLayer("elementhistory", ElementHistoryIndex.class);
        List elementHistoryList = HistoryUtils.getEntryHistory((String)uniformPath, (CommitDescriptor)endCommit, (long)0L, (CommitDescriptorIndex)((CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null)), (IBranchingLayer)elementHistoryBranchingLayer);
        List commits = elementHistoryList.stream().map(CommitAssociatedObjectBase::getCommit).collect(Collectors.toList());
        List logEntries = repoLogIndex.getEntries(commits);
        for (int i = 0; i < commits.size(); ++i) {
            if (logEntries.get(i) == null) {
                logger.error("No repository log entry found for commit " + String.valueOf(commits.get(i)));
                continue;
            }
            if (!((RepositoryLogEntryAggregate)logEntries.get(i)).containsConnectorIdentifier(ExternalUploadUtils::isCodeCommit)) continue;
            return Optional.of((RepositoryLogEntryAggregate)logEntries.get(i));
        }
        logger.error("Did not find last change for " + uniformPath);
        return Optional.empty();
    }

    private RepositoryLastChangeUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

