/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitAssociationIndexBase;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Index(name="repository-log", options={EStorageOption.COMMIT_ISOLATED})
public class RepositoryLogIndex
extends CommitAssociationIndexBase<RepositoryLogEntryAggregate>
implements IProjectIndex {
    public static final String INDEX_NAME = "repository-log";
    public static final String INITIAL_COMMIT_AUTHOR = "Teamscale import";
    public static final String INITIAL_COMMIT_MESSAGE = "Teamscale import";

    public RepositoryLogIndex(IStore store) {
        super(store);
    }

    public void clear() throws StorageException {
        StorageUtils.clearStore((IStore)this.store);
    }

    public void setPrimaryLogEntry(RepositoryLogEntry repositoryLogEntry) throws StorageException {
        RepositoryLogEntryAggregate aggregateEntry = this.getOrCreateAggregateEntry(repositoryLogEntry.getCommit());
        aggregateEntry.setPrimaryLogEntry(repositoryLogEntry);
        this.setEntry(aggregateEntry);
    }

    public void addSecondaryLogEntry(RepositoryLogEntry repositoryLogEntry) throws StorageException {
        RepositoryLogEntryAggregate aggregateEntry = this.getOrCreateAggregateEntry(repositoryLogEntry.getCommit());
        aggregateEntry.addSecondaryLogEntry(repositoryLogEntry);
        this.setEntry(aggregateEntry);
    }

    private RepositoryLogEntryAggregate getOrCreateAggregateEntry(CommitDescriptor commit) throws StorageException {
        RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)this.getEntry(commit);
        if (entry != null) {
            return entry;
        }
        return new RepositoryLogEntryAggregate();
    }

    public void setEntry(RepositoryLogEntry entry) throws StorageException {
        this.setPrimaryLogEntry(entry);
    }
}

