/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.google.common.primitives.Longs;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.repository.artifact_store.EArtifactStoreScanType;
import com.teamscale.index.repository.artifact_store.GlobalArchiveContentIndexBase;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ArchiveIndexBase
extends ProjectIndexWithDynamicNameBase
implements IRollbackableIndex {
    private static final byte[] REVISION_TO_ARCHIVE_KEY_PREFIX = new byte[]{1};
    private static final byte[] ARCHIVE_PROCESSED_KEY_PREFIX = new byte[]{2};
    private static final byte[] ARCHIVE_PROCESSED_SUCCESSFULLY_VALUE = new byte[]{2};
    private static final byte ARCHIVE_FAILED_COUNT_OFFSET = 100;
    private static final byte[] PATH_KEY_PREFIX = new byte[]{3};
    private static final byte[] REVISION_TO_TIMESTAMP_KEY_PREFIX = new byte[]{4};
    private static final byte[] DEBUG_INFO_KEY = new byte[]{5};
    private static final byte[] UNMATCHED_PATHS_KEY = new byte[]{6};
    protected static final String LAST_FULL_SCAN_TIMESTAMP_KEY_PREFIX = "###last-full-scan###";
    private static final String LAST_SCAN_TIMESTAMP_KEY_PREFIX = "###last-scan###";
    private static final String LAST_SCAN_CACHED_ITEMS_KEY = "###items###";
    private static final String TOTAL_ARTIFACT_STORE_CONTENT_SIZE = "###total-artifact-store-content-size###";
    private static final String ANALYZED_ARTIFACT_STORE_CONTENT_SIZE = "###analyzed-artifact-store-content-size###";
    private static final String GARBAGE_ARTIFACT_STORE_CONTENT_SIZE = "###garbage-artifact-store-content-size###";
    private static final Logger LOGGER = LogManager.getLogger();

    protected ArchiveIndexBase(IStore store) {
        super(store);
    }

    public String getStoredDebugInfo() throws StorageException {
        return StringUtils.emptyIfNull((String)StringUtils.bytesToString((byte[])this.store.get(DEBUG_INFO_KEY)));
    }

    public void storeDebugInfo(@NonNull String info) {
        try {
            this.store.put(DEBUG_INFO_KEY, StringUtils.stringToBytes((String)info));
        }
        catch (Throwable e) {
            LOGGER.error("Failed to store debug info", e);
        }
    }

    public void removeArchivesForRevision(CommitTreeRevision revision) throws StorageException {
        this.store.remove(ArchiveIndexBase.makeRevisionToArchivesKey(revision));
    }

    public void storeTotalArtifactStoreSize(long size) throws StorageException {
        this.store.putWithString(TOTAL_ARTIFACT_STORE_CONTENT_SIZE, Longs.toByteArray((long)size));
    }

    public void storeAnalyzedArtifactStoreSize(long analyzedContentSize) throws StorageException {
        this.store.putWithString(ANALYZED_ARTIFACT_STORE_CONTENT_SIZE, Longs.toByteArray((long)analyzedContentSize));
    }

    public void storeGarbageSize(long garbageSize) throws StorageException {
        this.store.putWithString(GARBAGE_ARTIFACT_STORE_CONTENT_SIZE, Longs.toByteArray((long)garbageSize));
    }

    public @Nullable Long getTotalArtifactStoreSize() throws StorageException {
        byte[] storeSize = this.store.getWithString(TOTAL_ARTIFACT_STORE_CONTENT_SIZE);
        if (storeSize == null) {
            return null;
        }
        return Longs.fromByteArray((byte[])storeSize);
    }

    public @Nullable Long getAnalyzedArtifactStoreSize() throws StorageException {
        byte[] storeSize = this.store.getWithString(ANALYZED_ARTIFACT_STORE_CONTENT_SIZE);
        if (storeSize == null) {
            return null;
        }
        return Longs.fromByteArray((byte[])storeSize);
    }

    public @Nullable Long getGarbageArtifactStoreContentSize() throws StorageException {
        byte[] storeSize = this.store.getWithString(GARBAGE_ARTIFACT_STORE_CONTENT_SIZE);
        if (storeSize == null) {
            return null;
        }
        return Longs.fromByteArray((byte[])storeSize);
    }

    public boolean updateArchivesForRevision(CommitTreeRevision revision, Collection<String> archives, EArtifactStoreScanType scanType) throws StorageException {
        List knownArchives;
        byte[] key = ArchiveIndexBase.makeRevisionToArchivesKey(revision);
        ArrayList newArchives = CollectionUtils.sort(archives);
        if (ArchiveIndexBase.archivesAdded(newArchives, knownArchives = CollectionUtils.emptyIfNull((List)StorageUtils.deserializeStringList((byte[])this.store.get(key))))) {
            if (ArchiveIndexBase.isPartialScan(scanType)) {
                HashSet mergedArchives = CollectionUtils.unionSet((Collection)knownArchives, (Collection[])new Collection[]{newArchives});
                this.store.put(key, StorageUtils.serialize((Serializable)CollectionUtils.sort((Collection)mergedArchives)));
            } else {
                this.store.put(key, StorageUtils.serialize((Serializable)newArchives));
            }
            return true;
        }
        if (scanType == EArtifactStoreScanType.INCREMENTAL_ADDITIVE_SCAN && ArchiveIndexBase.existingArchivesUpdated(newArchives, knownArchives)) {
            return true;
        }
        if (ArchiveIndexBase.isPartialScan(scanType)) {
            return false;
        }
        HashSet removedArchives = CollectionUtils.differenceSet((Collection)knownArchives, (Collection[])new Collection[]{newArchives});
        if (removedArchives.isEmpty()) {
            return false;
        }
        this.store.put(key, StorageUtils.serialize((Serializable)newArchives));
        return this.determineIfRemovalCausesRealChanges(removedArchives);
    }

    private static boolean archivesAdded(List<String> newArchives, List<String> knownArchives) {
        return !CollectionUtils.differenceSet(newArchives, (Collection[])new Collection[]{knownArchives}).isEmpty();
    }

    private static boolean existingArchivesUpdated(List<String> newArchives, List<String> knownArchives) {
        return !CollectionUtils.intersectionSet(newArchives, (Collection[])new Collection[]{knownArchives}).isEmpty();
    }

    private static boolean isPartialScan(EArtifactStoreScanType scanType) {
        return scanType == EArtifactStoreScanType.INCREMENTAL_ADDITIVE_SCAN || scanType == EArtifactStoreScanType.TIME_RANGE_SCAN;
    }

    private boolean determineIfRemovalCausesRealChanges(Set<String> removedArchives) throws StorageException {
        for (byte[] processedInfo : this.store.get(CollectionUtils.map(removedArchives, ArchiveIndexBase::makeArchiveProcessedKey))) {
            if (processedInfo == null || processedInfo[0] != ARCHIVE_PROCESSED_SUCCESSFULLY_VALUE[0]) continue;
            if (processedInfo.length < 5) {
                return true;
            }
            int entryCount = ByteArrayUtils.byteArrayToInt((byte[])Arrays.copyOfRange(processedInfo, 1, 5));
            if (entryCount <= 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getArchivesForRevision(CommitTreeRevision revision) throws StorageException {
        return CollectionUtils.emptyIfNull((List)StorageUtils.deserializeStringList((byte[])this.store.get(ArchiveIndexBase.makeRevisionToArchivesKey(revision))));
    }

    public boolean isArchiveProcessed(String archiveName) throws StorageException {
        byte[] value = this.store.get(ArchiveIndexBase.makeArchiveProcessedKey(archiveName));
        return value != null && value[0] == ARCHIVE_PROCESSED_SUCCESSFULLY_VALUE[0];
    }

    public boolean isArchiveFailed(String archiveName) throws StorageException {
        byte[] value = this.store.get(ArchiveIndexBase.makeArchiveProcessedKey(archiveName));
        return value != null && value[0] >= 100 + this.getMaximumRetryCount();
    }

    protected abstract int getMaximumRetryCount();

    public void setArchiveProcessed(String archiveName, int containedEntries) throws StorageException {
        this.store.put(ArchiveIndexBase.makeArchiveProcessedKey(archiveName), ByteArrayUtils.concat((byte[][])new byte[][]{ARCHIVE_PROCESSED_SUCCESSFULLY_VALUE, ByteArrayUtils.intToByteArray((int)containedEntries)}));
    }

    public void setArchiveFailed(String archiveName, CommitTreeRevision revision, List<String> pathsToCleanUp) throws StorageException {
        byte[] currentValue = this.store.get(ArchiveIndexBase.makeArchiveProcessedKey(archiveName));
        if (currentValue == null || currentValue[0] == ARCHIVE_PROCESSED_SUCCESSFULLY_VALUE[0]) {
            currentValue = new byte[]{100};
        }
        currentValue[0] = (byte)(currentValue[0] + 1);
        this.store.put(ArchiveIndexBase.makeArchiveProcessedKey(archiveName), currentValue);
        this.removePathEntries(revision, pathsToCleanUp);
    }

    public void removeDataForRevision(CommitTreeRevision revision) throws StorageException {
        this.store.removeByPrefix(ArchiveIndexBase.makePathKey(revision, ""));
        this.store.remove(CollectionUtils.map(this.getArchivesForRevision(revision), ArchiveIndexBase::makeArchiveProcessedKey));
    }

    private void removePathEntries(CommitTreeRevision revision, List<String> paths) throws StorageException {
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
        for (String path : paths) {
            keysToRemove.add(ArchiveIndexBase.makePathKey(revision, path));
        }
        this.store.remove(keysToRemove);
    }

    public void setContent(CommitTreeRevision revision, String path, byte[] content, GlobalArchiveContentIndexBase globalArchiveContentIndex) throws StorageException {
        byte[] contentHash = globalArchiveContentIndex.setContent(content);
        this.store.put(ArchiveIndexBase.makePathKey(revision, path), contentHash);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<byte @Nullable []> getContent(CommitTreeRevision revision, List<String> paths, GlobalArchiveContentIndexBase globalArchiveContentIndex, ConsumerWithTwoExceptions<String, StorageException, RepositoryException> redownloadArchiveCallback) throws StorageException, RepositoryException {
        List pathKeys = CollectionUtils.map(paths, path -> ArchiveIndexBase.makePathKey(revision, path));
        @Nullable List contentHashes = this.store.get(pathKeys);
        this.handlePossibleNullContentHashes(paths, contentHashes, revision);
        List<byte[]> content = globalArchiveContentIndex.getContent(contentHashes);
        if (content.stream().noneMatch(Objects::isNull) || contentHashes.stream().anyMatch(Objects::isNull)) {
            return content;
        }
        List<String> archives = this.getArchivesForRevision(revision);
        for (String archive : archives) {
            redownloadArchiveCallback.accept((Object)archive);
        }
        return globalArchiveContentIndex.getContent(contentHashes);
    }

    private void handlePossibleNullContentHashes(List<String> paths, List<byte[]> contentHashes, CommitTreeRevision revision) throws StorageException {
        ArrayList<String> pathsWithoutHashes = new ArrayList<String>();
        for (int i = 0; i < paths.size(); ++i) {
            if (contentHashes.get(i) != null) continue;
            pathsWithoutHashes.add(paths.get(i));
        }
        if (pathsWithoutHashes.isEmpty()) {
            return;
        }
        LOGGER.error("Tried to retrieve content for paths that were unknown (no content hashes stored). This can happen when an artifact in an artifact store (such as Artifactory or S3) is updated after Teamscale has already downloaded and evaluated it.\nFor this commit, external data may be incomplete or out-of-date. However, this is typically resolved automatically when the next commit is evaluated.\nThe following paths could not be retrieved: {}", pathsWithoutHashes);
        List<String> archives = this.getArchivesForRevision(revision);
        for (String archive : archives) {
            this.setArchiveFailed(archive, revision, paths);
        }
    }

    public Map<String, byte[]> getAllPathsForRevision(CommitTreeRevision revision) throws StorageException {
        byte[] prefix = ArchiveIndexBase.makePathKey(revision, "");
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        this.store.scan(prefix, (key, value) -> {
            String path = StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, prefix.length, key.length));
            Map map = result;
            synchronized (map) {
                result.put(path, value);
            }
        });
        return result;
    }

    public Optional<Long> getTimestampForRevision(String revision) throws StorageException {
        byte[] value = this.store.get(ArchiveIndexBase.makeRevisionToTimestampKey(revision));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(ByteArrayUtils.byteArrayToLong((byte[])value));
    }

    public void setTimestampForRevision(String revision, long timestamp) throws StorageException {
        this.store.put(ArchiveIndexBase.makeRevisionToTimestampKey(revision), ByteArrayUtils.longToByteArray((long)timestamp));
    }

    private static byte[] makeRevisionToArchivesKey(CommitTreeRevision revision) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{REVISION_TO_ARCHIVE_KEY_PREFIX, revision.toStorageKey()});
    }

    private static byte[] makeArchiveProcessedKey(String archiveName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ARCHIVE_PROCESSED_KEY_PREFIX, StringUtils.stringToBytes((String)archiveName)});
    }

    private static byte[] makePathKey(CommitTreeRevision revision, String path) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{PATH_KEY_PREFIX, revision.toStorageKey(), PATH_KEY_PREFIX, StringUtils.stringToBytes((String)path)});
    }

    private static byte[] makeRevisionToTimestampKey(String revision) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{REVISION_TO_TIMESTAMP_KEY_PREFIX, StringUtils.stringToBytes((String)revision)});
    }

    private static byte[] makeUnmatchedPathsKey(Collection<String> unmatchedPaths) {
        String unmatchedPathsHash = XXHashUtils.xxhash64((List)CollectionUtils.sort(unmatchedPaths));
        return ByteArrayUtils.concat((byte[][])new byte[][]{UNMATCHED_PATHS_KEY, StringUtils.stringToBytes((String)unmatchedPathsHash)});
    }

    public @NonNull OptionalLong getLastFullScanTimestamp() throws StorageException {
        return this.getTimestamp(LAST_FULL_SCAN_TIMESTAMP_KEY_PREFIX);
    }

    public @NonNull OptionalLong getLastScanTimestamp() throws StorageException {
        return this.getTimestamp(LAST_SCAN_TIMESTAMP_KEY_PREFIX);
    }

    private @NonNull OptionalLong getTimestamp(String key) throws StorageException {
        byte[] value = this.store.getWithString(key);
        if (value == null) {
            return OptionalLong.empty();
        }
        long millis = ByteArrayUtils.byteArrayToLong((byte[])value);
        return OptionalLong.of(millis);
    }

    public void setLastScanTimestamp(@Nullable Long timestamp, boolean isFullScan) throws StorageException {
        this.setTimestamp(LAST_SCAN_TIMESTAMP_KEY_PREFIX, timestamp);
        if (isFullScan) {
            this.setTimestamp(LAST_FULL_SCAN_TIMESTAMP_KEY_PREFIX, timestamp);
        }
    }

    private void setTimestamp(String key, @Nullable Long timestamp) throws StorageException {
        if (timestamp == null) {
            this.store.removeWithString(key);
        } else {
            byte[] value = ByteArrayUtils.longToByteArray((long)timestamp);
            this.store.putWithString(key, value);
        }
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        this.setLastScanTimestamp(Math.min(this.getLastScanTimestamp().orElse(Long.MAX_VALUE), Collections.min(timestampByBranch.values())), false);
        this.ensureFullScanOnNextRun();
    }

    public void ensureFullScanOnNextRun() throws StorageException {
        this.store.removeWithString(LAST_FULL_SCAN_TIMESTAMP_KEY_PREFIX);
    }

    public void storeItemQueryResultData(ItemQueryResultData itemQueryResultData) throws StorageException {
        this.store.putWithString(LAST_SCAN_CACHED_ITEMS_KEY, itemQueryResultData.toByteArray());
    }

    public Optional<ItemQueryResultData> getItemQueryResultData() throws StorageException {
        return Optional.ofNullable(ItemQueryResultData.fromByteArray(this.store.getWithString(LAST_SCAN_CACHED_ITEMS_KEY)));
    }

    private int getUnmatchedPathsRetryCount(Collection<String> unmatchedPaths) throws StorageException {
        byte[] value = this.store.get(ArchiveIndexBase.makeUnmatchedPathsKey(unmatchedPaths));
        if (value == null) {
            return 0;
        }
        return ByteArrayUtils.byteArrayToInt((byte[])value);
    }

    public int registerUnmatchedPaths(Collection<String> unmatchedPaths) throws StorageException {
        int existingRetryCount = this.getUnmatchedPathsRetryCount(unmatchedPaths);
        int updatedRetryCount = existingRetryCount + 1;
        this.store.put(ArchiveIndexBase.makeUnmatchedPathsKey(unmatchedPaths), ByteArrayUtils.intToByteArray((int)updatedRetryCount));
        return updatedRetryCount;
    }
}

