/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.artifact_store.ArtifactIncludeExcludePatterns;
import com.teamscale.index.repository.artifact_store.ArtifactStoreCommitResolutionCacheIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.GlobalArchiveContentIndexBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryArchiveIndex;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryCommitResolutionCacheIndex;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryGlobalArchiveContentIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ArtifactoryRepositoryInfo
extends ArtifactStoreRepositoryInfoBase {
    public static final String PUBLIC_CONTEXT_PATH_PARAMETER = "public-context-path";
    public static final String NAME_SEARCH_PATTERN_PARAMETER = "name-search-pattern";
    public static final String PATH_SEARCH_PATTERN_PARAMETER = "path-search-pattern";
    public static final String ZIP_EXCLUDE_PATTERN_PARAMETER = "zip-exclude-pattern";
    public static final String FULL_SCAN_INTERVAL_PARAMETER = "full-scan-interval";
    @StepParameter(value="repository-path")
    private String repositoryPath;
    @StepParameter(value="public-context-path", optional=true)
    private String publicContextPath;
    @StepParameter(value="name-search-pattern", optional=true)
    private final List<String> nameSearchPatterns = new ArrayList<String>();
    @StepParameter(value="path-search-pattern", optional=true)
    private final List<String> pathSearchPatterns = new ArrayList<String>();
    @StepParameter(value="zip-exclude-pattern", optional=true)
    private final List<String> zipExcludePatterns = new ArrayList<String>();
    @StepParameter(value="full-scan-interval", optional=true)
    private long fullScanIntervalInSeconds;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    protected ArtifactoryArchiveIndex artifactoryArchiveIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArtifactoryGlobalArchiveContentIndex artifactoryGlobalArchiveContentIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    protected ArtifactoryCommitResolutionCacheIndex artifactoryCommitResolutionCacheIndex;

    public String getPublicContextPath() {
        return this.publicContextPath;
    }

    public void setPublicContextPath(String publicContextPath) {
        this.publicContextPath = publicContextPath;
    }

    @Override
    protected ArtifactStoreCommitResolutionCacheIndexBase getArtifactStoreCommitResolutionCacheIndex() {
        return this.artifactoryCommitResolutionCacheIndex;
    }

    private void setArtifactoryArchiveIndex(ArtifactoryArchiveIndex artifactoryArchiveIndex) {
        this.artifactoryArchiveIndex = artifactoryArchiveIndex;
    }

    private void setArtifactoryCommitResolutionCacheIndex(ArtifactoryCommitResolutionCacheIndex artifactoryCommitResolutionCacheIndex) {
        this.artifactoryCommitResolutionCacheIndex = artifactoryCommitResolutionCacheIndex;
    }

    protected ArtifactoryArchiveIndex getArchiveIndex() {
        return this.artifactoryArchiveIndex;
    }

    @Override
    protected GlobalArchiveContentIndexBase getGlobalArchiveContentIndex() {
        return this.artifactoryGlobalArchiveContentIndex;
    }

    @Override
    public String getRepositoryOrBucketName() {
        return this.repositoryPath;
    }

    @Override
    public ArtifactIncludeExcludePatterns getKeyIncludeExcludePatterns() {
        if (!this.zipExcludePatterns.isEmpty()) {
            return ArtifactIncludeExcludePatterns.createWithExcludedPathsPatterns(this.zipExcludePatterns);
        }
        return ArtifactIncludeExcludePatterns.createWithDefaultPatterns();
    }

    @Override
    public void setRepositoryOrBucketName(ConnectorConfiguration connectorConfiguration) {
        this.repositoryPath = connectorConfiguration.getOptionValue("Repository");
    }

    @Override
    public void setRepositoryOrBucketName(String repositoryName) {
        this.repositoryPath = repositoryName;
    }

    @Override
    public void setIncludeAndExcludePatterns(ConnectorConfiguration connectorConfiguration) {
        String nameSearchPattern = StringUtils.emptyIfNull((String)connectorConfiguration.getOptionValue("Name Search Pattern"));
        String pathSearchPattern = StringUtils.emptyIfNull((String)connectorConfiguration.getOptionValue("Path Search Pattern"));
        String zipExcludePattern = StringUtils.emptyIfNull((String)connectorConfiguration.getOptionValue("Zip Exclude Pattern"));
        this.nameSearchPatterns.addAll(Arrays.asList(nameSearchPattern.split("[,\\n]")));
        this.pathSearchPatterns.addAll(Arrays.asList(pathSearchPattern.split("[,\\n]")));
        this.zipExcludePatterns.addAll(Arrays.asList(zipExcludePattern.split("[,\\n]")));
    }

    @Override
    public void initializeInMemoryIndexes() {
        this.setArtifactoryArchiveIndex(new ArtifactoryArchiveIndex((IStore)new InMemoryStore()));
        this.setArtifactoryCommitResolutionCacheIndex(new ArtifactoryCommitResolutionCacheIndex((IStore)new InMemoryStore()));
    }

    public List<String> getNameSearchPatterns() {
        return CollectionUtils.filter(this.nameSearchPatterns, s -> !StringUtils.isEmpty((String)s));
    }

    public List<String> getPathSearchPatterns() {
        return CollectionUtils.filter(this.pathSearchPatterns, s -> !StringUtils.isEmpty((String)s));
    }

    public long getFullScanIntervalInSeconds() {
        return this.fullScanIntervalInSeconds;
    }
}

