/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.repository.base.BranchPointerHistoryIndex;
import com.teamscale.index.repository.base.IncludeExcludeStepParameter;
import java.util.List;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class RepositoryConnectorBaseParameterStep {
    public static final String PATH_SUFFIX_PARAMETER = "path-suffix";
    public static final String START_REVISION_PARAMETER = "start-revision";
    public static final String END_REVISION_PARAMETER = "end-revision";
    public static final String MINIMAL_START_TIMESTAMP_PARAMETER = "minimal-start-timestamp";
    public static final String DEFAULT_BRANCH_NAME_PARAMETER = "default-branch-name";
    public static final String BRANCHING_PARAMETER = "branching";
    public static final String BRANCH_PATH_SUFFIX_PARAMETER = "branch-path-suffix";
    public static final String INTERNAL_PROJECT_ID_PARAMETER = "internal-project-id";
    public static final String CONNECTION_IDENTIFIER_PARAMETER = "connection-identifier";
    public static final String POLLING_INTERVAL_SECONDS_PARAMETER = "polling-interval";
    private static final String CODE_INCLUDE_EXCLUDE_PATTERN = "code-";
    public static final String CODE_EXCLUDE_PATTERN_PARAMETER = "code-exclude-pattern";
    public static final String CODE_INCLUDE_PATTERN_PARAMETER = "code-include-pattern";
    private static final String BRANCH_INCLUDE_EXCLUDE_PATTERN = "branch-";
    public static final String BRANCH_EXCLUDE_PATTERN_PARAMETER = "branch-exclude-pattern";
    public static final String BRANCH_INCLUDE_PATTERN_PARAMETER = "branch-include-pattern";
    private static final String TEST_CODE_INCLUDE_EXCLUDE_PATTERN = "test-code-";
    public static final String TEST_CODE_EXCLUDE_PATTERN_PARAMETER = "test-code-exclude-pattern";
    public static final String TEST_CODE_INCLUDE_PATTERN_PARAMETER = "test-code-include-pattern";
    public static final int DEFAULT_POLLING_INTERVAL_SECONDS = 60;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private BranchPointerHistoryIndex branchPointerHistoryIndex;
    @StepParameter(value="internal-project-id")
    private InternalProjectId projectId;
    @StepParameter(value="path-suffix", optional=true)
    private String pathSuffix = "";
    @StepParameter(value="start-revision", optional=true)
    private String startDateOrRevision;
    @StepParameter(value="minimal-start-timestamp", optional=true)
    private long minimalStartTimestamp = 0L;
    @StepParameter(value="end-revision", optional=true)
    private String endDateOrRevision;
    @StepParameter(value="default-branch-name")
    private String defaultBranchName;
    @StepParameter(value="branching", optional=true)
    private boolean branchingEnabled;
    @StepParameter(value="branch-path-suffix", optional=true)
    private String branchPathSuffix = "";
    @StepParameterObject(namePrefix="code-")
    private final IncludeExcludeStepParameter<IncludeExcludeAntPatternSupport> codePatternSupport = new IncludeExcludeStepParameter<IncludeExcludeAntPatternSupport>(IncludeExcludeAntPatternSupport::new);
    @StepParameterObject(namePrefix="branch-")
    private final IncludeExcludeStepParameter<IncludeExcludeRegexSupport> branchPatternSupport = new IncludeExcludeStepParameter<IncludeExcludeRegexSupport>(IncludeExcludeRegexSupport::new);
    @StepParameterObject(namePrefix="test-code-")
    private final IncludeExcludeStepParameter<IncludeExcludeAntPatternSupport> testCodePatternSupport = new IncludeExcludeStepParameter<IncludeExcludeAntPatternSupport>(IncludeExcludeAntPatternSupport::new);
    @StepParameter(value="polling-interval", optional=true)
    public int pollingIntervalSeconds = 60;
    @StepParameter(value="connection-identifier")
    private String connectionIdentifier;

    @ApiStatus.Experimental
    public BranchPointerHistoryIndex getBranchPointerHistoryIndex() {
        return this.branchPointerHistoryIndex;
    }

    public IncludeExcludeAntPatternSupport getCodePatternSupport() {
        return this.codePatternSupport.get();
    }

    public IncludeExcludeRegexSupport getBranchPatternSupport() {
        return this.branchPatternSupport.get();
    }

    public IncludeExcludeAntPatternSupport getTestCodePatternSupport() {
        return this.testCodePatternSupport.get();
    }

    public String getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public String getBranchPathSuffix() {
        return this.branchPathSuffix;
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    public @Nullable String getStartDateOrRevision() {
        return this.startDateOrRevision;
    }

    public @Nullable String getEndDateOrRevision() {
        return this.endDateOrRevision;
    }

    public long getMinimalStartTimestamp() {
        return this.minimalStartTimestamp;
    }

    public int getPollingIntervalSeconds() {
        return this.pollingIntervalSeconds;
    }

    public String getDefaultBranchName() {
        return this.defaultBranchName;
    }

    public boolean isBranchingEnabled() {
        return this.branchingEnabled;
    }

    public static RepositoryConnectorBaseParameterStepBuilder builder(String connectionIdentifier, String defaultBranchName) {
        return new RepositoryConnectorBaseParameterStepBuilder(connectionIdentifier, defaultBranchName);
    }

    public InternalProjectId getProjectId() {
        return this.projectId;
    }

    public static class RepositoryConnectorBaseParameterStepBuilder {
        private final RepositoryConnectorBaseParameterStep parameter = new RepositoryConnectorBaseParameterStep();

        private RepositoryConnectorBaseParameterStepBuilder(String connectionIdentifier, String defaultBranchName) {
            this.parameter.connectionIdentifier = connectionIdentifier;
            this.parameter.defaultBranchName = defaultBranchName;
        }

        public RepositoryConnectorBaseParameterStepBuilder withCodePattern(IncludeExcludeAntPatternSupport codePatternSupport) {
            RepositoryConnectorBaseParameterStepBuilder.assertPatternsAreEmpty(this.parameter.codePatternSupport, "code");
            this.parameter.codePatternSupport.addPatterns((List<String>)codePatternSupport.getIncludePatterns(), (List<String>)codePatternSupport.getExcludePatterns());
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withTestCodePattern(IncludeExcludeAntPatternSupport testCodePatternSupport) {
            RepositoryConnectorBaseParameterStepBuilder.assertPatternsAreEmpty(this.parameter.testCodePatternSupport, "test");
            this.parameter.testCodePatternSupport.addPatterns((List<String>)testCodePatternSupport.getIncludePatterns(), (List<String>)testCodePatternSupport.getExcludePatterns());
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withBranchPattern(IncludeExcludeRegexSupport branchPatternSupport) {
            return this.withBranchPattern((List<String>)branchPatternSupport.getIncludePatterns(), (List<String>)branchPatternSupport.getExcludePatterns());
        }

        public RepositoryConnectorBaseParameterStepBuilder withBranchPattern(List<String> includePatterns, List<String> excludePatterns) {
            RepositoryConnectorBaseParameterStepBuilder.assertPatternsAreEmpty(this.parameter.branchPatternSupport, "branch");
            this.parameter.branchPatternSupport.addPatterns(includePatterns, excludePatterns);
            return this;
        }

        private static void assertPatternsAreEmpty(IncludeExcludeStepParameter<?> includeExcludeStepParameter, String type) {
            CCSMAssert.isTrue((boolean)includeExcludeStepParameter.isEmpty(), (String)("Can only add " + type + " patterns to the builder once."));
        }

        public RepositoryConnectorBaseParameterStepBuilder withStartRevision(String startDateOrRevision) {
            this.parameter.startDateOrRevision = startDateOrRevision;
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withEndRevision(String endDateOrRevision) {
            this.parameter.endDateOrRevision = endDateOrRevision;
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withBranchingEnabled(boolean branchingEnabled) {
            this.parameter.branchingEnabled = branchingEnabled;
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withPathSuffix(String pathSuffix) {
            this.parameter.pathSuffix = pathSuffix;
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withBranchPathSuffix(String branchPathSuffix) {
            this.parameter.branchPathSuffix = branchPathSuffix;
            return this;
        }

        public RepositoryConnectorBaseParameterStepBuilder withPollingIntervalSeconds(int pollingIntervalSeconds) {
            this.parameter.pollingIntervalSeconds = pollingIntervalSeconds;
            return this;
        }

        public RepositoryConnectorBaseParameterStep build() {
            CCSMAssert.isNotNull((Object)this.parameter.connectionIdentifier, (String)"Connection identifier must be set.");
            CCSMAssert.isNotNull((Object)this.parameter.defaultBranchName, (String)"Default branch name must be set.");
            return this.parameter;
        }
    }
}

