/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import java.util.Map;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="git-branch-pointers-placeholder", options={EStorageOption.BRANCHED}, valueClasses={String.class})
public class GitBranchPointerIndex
extends ProjectIndexWithDynamicNameBase {
    public static final String PLACEHOLDER = "git-branch-pointers-placeholder";
    public static final String BRANCH_NAME = "d";

    public GitBranchPointerIndex(IStore store) {
        super(store);
    }

    public void storeBranchPointerLookup(Map<String, String> branchToCommitLookup) throws StorageException {
        PairList valuesToWrite = new PairList();
        branchToCommitLookup.forEach((branch, sha) -> valuesToWrite.add((Object)StringUtils.stringToBytes((String)branch), (Object)StringUtils.stringToBytes((String)sha)));
        this.store.put(valuesToWrite);
    }

    public @Nullable String getCommitForBranchPointer(String branch) throws StorageException {
        return StringUtils.bytesToString((byte[])this.store.getWithString(branch));
    }

    public PairList<String, String> getAllEntries() throws StorageException {
        PairList result = new PairList();
        this.store.scan("", (key, value) -> {
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)StringUtils.bytesToString((byte[])key), (Object)StringUtils.bytesToString((byte[])value));
            }
        });
        return result;
    }

    public static String createIndexName(String repositoryIdentifier) {
        return IProjectIndexWithDynamicName.createIndexName((String)repositoryIdentifier, (String)PLACEHOLDER);
    }
}

