/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.committree.AdjustAllCommits;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.debug_dump.dump.GitConnectorConfigurationDump;
import com.teamscale.index.repository.git.debug_dump.replay.GitDebugDumpRepositoryConnection;
import com.teamscale.index.repository.git.debug_dump.replay.GitRepositoryDebugDumpReader;
import com.teamscale.index.repository.git.labeling.GitRepositoryInfoDumper;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.options.OptionHandler;
import org.jspecify.annotations.Nullable;

public abstract class GitCommandLineToolBase
extends CommandLineBase<Exception> {
    private static final Logger LOGGER = LogManager.getLogger();
    private IncludeExcludeRegexSupport branchIncludesExcludes = new IncludeExcludeRegexSupport();
    private final PatternList importantBranches = new PatternList();
    private String startDateOrRevision = "";
    private String endDateOrRevision = "";
    protected String defaultBranchName = "master";
    protected URI repositoryPath;
    private boolean branchingEnabled = true;
    private boolean keepResurrectedBranchHistory = true;
    protected @Nullable Path debugDumpPath;
    @OptionHandler
    private final GitRepositoryInfoDumper.GitInfoStoreOptions gitInfoStoreOptions = new GitRepositoryInfoDumper.GitInfoStoreOptions();

    @Option(shortName=114, longName="repository", description="sets the repository path")
    public void setRepositoryPath(String path) {
        try {
            if (!((String)path).startsWith("file://")) {
                path = "file://" + (String)path;
            }
            this.repositoryPath = new URI((String)path);
        }
        catch (URISyntaxException e) {
            CCSMAssert.fail((String)"Invalid repository path", (Throwable)e);
        }
    }

    @Option(shortName=100, longName="default", description="sets the default branch name")
    public void setDefaultBranchName(String defaultBranchName) {
        this.defaultBranchName = defaultBranchName;
    }

    @Option(longName="important", description="adds an important branch pattern")
    public void addImportantBranch(String pattern) {
        this.importantBranches.add((Object)Pattern.compile(pattern));
    }

    @Option(shortName=98, longName="branching-enabled", description="whether branching is enabled")
    public void setBranchingEnabled(String branchingEnabled) {
        this.branchingEnabled = Boolean.parseBoolean(branchingEnabled);
    }

    @Option(shortName=105, longName="include", description="adds a branch include pattern")
    public void addBranchInclude(String pattern) {
        this.branchIncludesExcludes.addIncludePattern(pattern);
    }

    @Option(shortName=120, longName="exclude", description="adds a branch exclude pattern")
    public void addBranchExclude(String pattern) {
        this.branchIncludesExcludes.addExcludePattern(pattern);
    }

    @Option(shortName=115, longName="start", description="the start date/revision")
    public void setStartDateOrRevision(String startDateOrRevision) {
        this.startDateOrRevision = startDateOrRevision;
    }

    @Option(shortName=101, longName="end", description="the end date/revision")
    public void setEndDateOrRevision(String endDateOrRevision) {
        this.endDateOrRevision = endDateOrRevision;
    }

    @Option(shortName=117, longName="debug-dump", description="the debug dump directory to import")
    public void setDebugDumpPath(String debugDumpPath) {
        this.debugDumpPath = Path.of(debugDumpPath, new String[0]);
    }

    @Option(shortName=107, longName="keep-resurrected-branch-history", description="whether to keep the resurrected branch history")
    public void setKeepResurrectedBranchHistory(boolean keepResurrectedBranchHistory) {
        this.keepResurrectedBranchHistory = keepResurrectedBranchHistory;
    }

    protected GitRepositoryConnection createGitRepositoryConnection() throws RepositoryException, StorageException {
        if (this.repositoryPath == null && this.debugDumpPath == null) {
            GitCommandLineToolBase.printError((String)"Repository path/debug dump path missing!");
            this.printUsageAndExit();
        }
        this.setArgumentsFromDebugDump();
        RepositoryConnectorBaseParameterStep baseParameters = RepositoryConnectorBaseParameterStep.builder("test", this.defaultBranchName).withBranchPattern(this.branchIncludesExcludes).withBranchingEnabled(true).withStartRevision(this.startDateOrRevision).withEndRevision(this.endDateOrRevision).withBranchingEnabled(this.branchingEnabled).build();
        GitRepositoryConnectorParameterStep gitParameters = GitRepositoryConnectorParameterStep.builder(this.createIndices(), (IBranchingLayer)new CommitLayeringBranchingLayer((IStore)new InMemoryStore(), null)).withImportantBranchPatterns(this.importantBranches.asStringList()).withCloneDirectory(FileSystemUtils.getTmpDir().toPath()).withConnectorType(ERepositoryConnector.GIT).build();
        if (this.debugDumpPath == null) {
            return new GitRepositoryConnection(baseParameters, gitParameters, new GitCredentials("", null, this.repositoryPath, null), ICancelable.neverCanceled());
        }
        return new GitDebugDumpRepositoryConnection(baseParameters, gitParameters, this.debugDumpPath, "", null, null, ICancelable.neverCanceled(), this.keepResurrectedBranchHistory);
    }

    private void setArgumentsFromDebugDump() {
        if (this.debugDumpPath == null) {
            return;
        }
        LOGGER.warn("Using connector configuration from debug dump config file, command line options will be overwritten.");
        GitConnectorConfigurationDump configuration = GitRepositoryDebugDumpReader.readConfigFile(this.debugDumpPath);
        this.branchingEnabled = configuration.branchingEnabled;
        this.defaultBranchName = configuration.defaultBranchName;
        this.startDateOrRevision = configuration.startRevisionOrDate;
        this.endDateOrRevision = configuration.endRevisionOrDate;
        this.keepResurrectedBranchHistory = configuration.keepResurrectedBranchHistory;
        this.branchIncludesExcludes = new IncludeExcludeRegexSupport();
        configuration.branchIncludePatterns.forEach(arg_0 -> ((IncludeExcludeRegexSupport)this.branchIncludesExcludes).addIncludePattern(arg_0));
        configuration.branchExcludePatterns.forEach(arg_0 -> ((IncludeExcludeRegexSupport)this.branchIncludesExcludes).addExcludePattern(arg_0));
        this.importantBranches.clear();
        this.importantBranches.addAll(configuration.importantBranchPatterns);
    }

    private GitIndices createIndices() throws StorageException {
        return new GitIndices(this.gitInfoStoreOptions.getGitInfoIndex(), new ServerOptionIndex((IStore)new InMemoryStore()), new AccessTokenIndex((IStore)new InMemoryStore()), new PostponedRollbackIndex((IStore)new InMemoryStore()), new RepositoryRevisionIndex(), new PendingGarbageCollectionIndex((IStore)new InMemoryStore()), new CrossRepositoryMergeRequestSourceBranchesIndex((IStore)new InMemoryStore()));
    }

    protected CommitTree expandCommitTree(GitRepositoryConnection connection, boolean adjustTimeStamps) throws StorageException, RepositoryException, RescheduleRequestedException {
        CommitTree commitTree = new CommitTreeIndex((IStore)new InMemoryStore()).loadTree();
        connection.expandCommitTree((IChangeRetrieverCommitTree)commitTree);
        if (adjustTimeStamps) {
            new AdjustAllCommits(new TimestampAdjustmentIndex((IStore)new InMemoryStore())).adjustTimestamps(commitTree.getAllNodes());
        }
        return commitTree;
    }
}

