/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.repository.base.CredentialsBasedRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitBranchRefInfo;
import com.teamscale.index.repository.git.GitChangeRetriever;
import com.teamscale.index.repository.git.GitContentUpdater;
import com.teamscale.index.repository.git.GitLfsClient;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.LsRemoteGitProxy;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@ConnectorDescriptor
public class GitRepositoryConnectorDescriptor
extends CredentialsBasedRepositoryConnectorDescriptorBase {
    @ConfigExposed(name="Include files stored via Git LFS", description="Whether files stored using Git Large File Storage (LFS) should be included in the Teamscale analysis.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private boolean includeGitLfs = false;
    @ConfigExposed(name="Important Branches", description="Important branches are preferred in addition to the default branch when assigning commits to branches. List of regular expressions with decreasing priority, e.g. develop, release/.*", multilineText=true, visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public List<String> importantBranchPatterns = new ArrayList<String>();
    @ConfigExposed(name="Include Submodules", description="Whether to transparently analyze submodules.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private boolean includeSubModules = false;
    @ConfigExposed(name="Submodule recursion depth", description="The maximum recursion depth when analyzing submodules.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private int subModuleRecursionDepth = 10;
    @ConfigExposed(name="SSH Private Key ID", description="The ID of the SSH private key to use when connecting to the server. Must match the ID of a Git Private Key configured under Admin > Settings > Git.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private @Nullable String privateKeyId;
    @ConfigExposed(name="Fetch additional ref specs", description="Use patterns in the form of `+refs/builds/tags/*:refs/remotes/origin/builds/tags/* -> refs/remotes/origin/builds/tags/./.\\.(.*)` to fetch additional ref specs. The last part specifies a capture group which will be used to determine the displayed name of the fetched refs.", visibility=ConfigExposed.EConfigVisibility.EXPERT, multilineText=true)
    private List<String> additionalUserRequestedRefSpecMappings = Collections.emptyList();
    public static final String SKIP_VOTING_EMPTY_MERGE_REQUEST_NAME = "Skip Voting on merge requests without relevant changes";
    @ConfigExposed(name="Skip Voting on merge requests without relevant changes", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If this is true, Teamscale does not vote on merge requests that do not contain any relevant changes.That also results in Teamscale not producing any findings badge in the merge request.")
    public boolean skipVotingForEmptyMergeRequests = false;
    public static final String IMPORTANT_BRANCHES = "Important Branches";
    public static final String SSH_PRIVATE_KEY_ID_OPTION = "SSH Private Key ID";
    private static final String INCLUDE_SUBMODULES_OPTION = "Include Submodules";
    private static final String INCLUDE_GIT_LFS = "Include files stored via Git LFS";
    private static final String SUBMODULE_RECURSION_DEPTH_OPTION = "Submodule recursion depth";
    public static final String ADDITIONAL_USER_REQUESTED_REF_SPEC_MAPPINGS_OPTION = "Fetch additional ref specs";
    private final SupplierWithException<GitBranchRefInfo, ConnectorValidationException> gitBranchRefInfo = SupplierWithException.memoize(() -> this.getGitBranchRefInfo(this.getRepositoryUri()));

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        String concatenated = GitRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.resolveExternalCredentials().uri, this.getPathSuffix());
        String normalized = GitUtils.rewriteGitAtUrl(concatenated);
        return this.parseUri(normalized);
    }

    public GitRepositoryConnectorDescriptor() {
        this(ERepositoryConnector.GIT);
        this.autoExpose();
    }

    protected GitRepositoryConnectorDescriptor(ERepositoryConnector type) {
        super(type, "master");
        this.branchExcludePatterns.add("_anon.*");
        this.branchExcludePatterns.add("renovate/.*");
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        GitRepositoryConnectorDescriptor.createGitRepositoryIndices(indexCreator, this.connectorIdentifier);
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        this.setExternalLinkTemplates(triggerCreator);
    }

    @TestOnly
    public void setPrivateKeyIdForTesting(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    @TestOnly
    public void setImportantBranchPatterns(List<String> importantBranchPatterns) {
        this.importantBranchPatterns = importantBranchPatterns;
    }

    private void setExternalLinkTemplates(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerCreator.addMetaIndexExternalLinkTemplates(this.getConnectorIdentifier(), this.getCommitLinkTemplate(), this.getCommitInMergeRequestLinkTemplate());
    }

    public static void createGitRepositoryIndices(ConnectorDescriptorBase.IIndexCreator indexCreator, String repositoryIdentifier) {
        indexCreator.createProjectIndex(GitRepositoryInfoIndex.class, GitRepositoryInfoIndex.createIndexName(repositoryIdentifier));
        indexCreator.createProjectIndex(GitBranchPointerIndex.class, GitBranchPointerIndex.createIndexName(repositoryIdentifier));
        indexCreator.createProjectIndex(CrossRepositoryMergeRequestSourceBranchesIndex.class, CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(repositoryIdentifier));
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        GitRepositoryConnectorDescriptor.setCommonParametersForGitConnectors(triggerBuilder, this.connectorIdentifier);
        triggerBuilder.setTriggerParameter("include-git-lfs", this.includeGitLfs);
        triggerBuilder.setTriggerParameter("include-sub-modules", this.includeSubModules);
        triggerBuilder.setTriggerParameter("sub-module-recursion-depth", this.subModuleRecursionDepth);
        if (this.privateKeyId != null) {
            triggerBuilder.setTriggerParameter("git-ssh-private-key", this.privateKeyId);
        }
        triggerBuilder.setTriggerParameter("important-branch-pattern", ITriggerParameter.of(this.importantBranchPatterns));
        triggerBuilder.setTriggerParameter("user-requested-ref-specs", ITriggerParameter.of(this.getUserRequestedRefSpecs()));
        triggerBuilder.setTriggerParameter("connector-type", this.getRepositoryType().name());
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    public static void setCommonParametersForGitConnectors(TriggerBuilder trigger, String repositoryIdentifier) {
        trigger.resolveIndexNamePlaceholder("git-repository-infos-placeholder", GitRepositoryInfoIndex.createIndexName(repositoryIdentifier));
        trigger.resolveIndexNamePlaceholder("git-branch-pointers-placeholder", GitBranchPointerIndex.createIndexName(repositoryIdentifier));
        trigger.resolveIndexNamePlaceholder("cross-repo-merge-request-source-branches-placeholder", CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(repositoryIdentifier));
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return GitChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return GitContentUpdater.class;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        ConnectorUtils.validateAndReturnPatterns(this.importantBranchPatterns, (String)IMPORTANT_BRANCHES);
        URI uri = this.getRepositoryUri();
        try {
            EGitProtocol gitProtocol = GitUtils.getProtocolFromUri(uri).orElseThrow(() -> new ConnectorValidationException("Parsed URL (%s) does not have a valid git protocol"));
            switch (gitProtocol) {
                case FILE: {
                    this.validateLocalRepository(uri);
                    break;
                }
                case SSH: 
                case HTTP: 
                case HTTPS: {
                    this.validateRemoteRepository(uri);
                    break;
                }
                default: {
                    CCSMAssert.fail((String)"Unsupported protocol!");
                    break;
                }
            }
        }
        catch (JGitInternalException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
        catch (RepositoryException e) {
            GitRepositoryConnectorDescriptor.handleExceptionDuringRepositoryValidation((Exception)((Object)e), uri);
        }
        for (String refSpecMapping : this.additionalUserRequestedRefSpecMappings) {
            GitRepositoryConnectorDescriptor.validateRefSpecMappingPattern(refSpecMapping);
        }
    }

    private static void handleExceptionDuringRepositoryValidation(Exception e, URI uri) throws ConnectorValidationException {
        Object message = e.getMessage();
        if (((String)message).contains("invalid advertisement of <!DOCTYPE html>")) {
            message = String.format("'%s' must be the root of a Git repository.", uri);
        }
        if (((String)message).contains("git-upload-pack not found")) {
            message = "URL does not seem to point to a valid Git repository: " + e.getMessage();
        }
        throw new ConnectorValidationException((String)message, (Throwable)e);
    }

    @Override
    protected void validateDefaultBranchName() {
    }

    private void validateLocalRepository(URI uri) throws RepositoryException, ConnectorValidationException {
        try (Repository repository = this.getLocalRepository();){
            Path configuredPath;
            Path repositoryPath = Objects.requireNonNull(Paths.get(repository.getDirectory().toURI()));
            if (repositoryPath.getFileName().equals(Paths.get(".git", new String[0]))) {
                repositoryPath = repositoryPath.getParent();
            }
            if (!Files.isSameFile(repositoryPath, configuredPath = Paths.get(uri))) {
                throw new RepositoryException("URL '" + String.valueOf(configuredPath) + "' does not point to the root of the Git repository at '" + String.valueOf(repositoryPath) + "'. Please note that sub-paths of a repository aren't supported.");
            }
            this.validateDefaultBranchName(this.getLocalRepositoryBranchRefInfoFromRepository(repository, uri), uri);
        }
        catch (IOException e) {
            throw new RepositoryException("Error occurred during validating Git repository: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean validateRevision(String revision) {
        return GitRefUtils.isCommitHashOrHeadRef((String)revision);
    }

    private static void validateGitLfsConnection(URI uri, String username, String password) throws ConnectorValidationException {
        try (GitLfsClient client = new GitLfsClient(uri, username, password);){
            client.checkConnection();
        }
        catch (IOException | RepositoryException e) {
            throw new ConnectorValidationException("Could not connect to the Git LFS server.", e);
        }
        catch (URISyntaxException e) {
            throw new ConnectorValidationException("Teamscale was unable to deduct the URI for the Git LFS server.", (Throwable)e);
        }
    }

    protected void validateRemoteRepository(URI repositoryUri) throws RepositoryException, ConnectorValidationException {
        this.validateDefaultBranchName((GitBranchRefInfo)this.gitBranchRefInfo.get(), repositoryUri);
        ExternalCredentials credentials = this.resolveExternalCredentials();
        if (this.includeGitLfs) {
            GitRepositoryConnectorDescriptor.validateGitLfsConnection(repositoryUri, credentials.username, credentials.password);
        }
    }

    @VisibleForTesting
    public static void validateRefSpecMappingPattern(String value) throws ConnectorValidationException {
        Pair<String, String> mappingParts;
        try {
            mappingParts = GitRepositoryConnectorDescriptor.splitRefSpecMapping(value);
        }
        catch (AssertionError e) {
            throw new ConnectorValidationException((Throwable)((Object)e));
        }
        try {
            new RefSpec((String)mappingParts.getFirst());
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorValidationException("Invalid ref spec '" + value + "'.", (Throwable)e);
        }
        try {
            Pattern pattern = Pattern.compile((String)mappingParts.getSecond());
            if (!GitRepositoryConnectorDescriptor.containsCaptureGroup(pattern)) {
                throw new ConnectorValidationException("Ref spec mapping contains an extraction pattern without a capture group: '" + pattern.pattern() + "'.");
            }
        }
        catch (PatternSyntaxException e) {
            throw new ConnectorValidationException("Ref spec mapping contains an invalid extraction pattern: '" + (String)mappingParts.getSecond() + "'.", (Throwable)e);
        }
    }

    private static boolean containsCaptureGroup(Pattern pattern) {
        return pattern.matcher("").groupCount() > 0;
    }

    private static Pair<String, String> splitRefSpecMapping(String value) {
        String[] split = value.split("->");
        CCSMAssert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"Ref spec mapping must contain exactly one '->' to indicate how the refs should be interpreted in Teamscale.");
        return new Pair((Object)split[0].trim(), (Object)split[1].trim());
    }

    private static GitBranchRefInfo getGitBranchRefInfo(URI uri, LsRemoteGitProxy proxy, TeamscaleGitCredentialsProvider createCredentialsProvider) throws GitAPIException, IOException {
        Collection refs = GitUtils.configureCommand(uri, createCredentialsProvider, proxy.lsRemote().setRemote(uri.toString()), ICancelable.neverCanceled()).call();
        return GitBranchRefInfo.create(refs);
    }

    public Map<String, Pattern> getAdditionalRefSpecMappings() {
        return this.additionalUserRequestedRefSpecMappings.stream().map(GitRepositoryConnectorDescriptor::splitRefSpecMapping).collect(Collectors.toMap(ImmutablePair::getFirst, mapping -> Pattern.compile((String)mapping.getSecond()), (a, b) -> b, HashMap::new));
    }

    public Set<String> getUserRequestedRefSpecs() {
        return this.additionalUserRequestedRefSpecMappings.stream().map(GitRepositoryConnectorDescriptor::splitRefSpecMapping).map(ImmutablePair::getFirst).collect(Collectors.toSet());
    }

    private void validateDefaultBranchName(GitBranchRefInfo gitBranchRefInfo, URI repositoryUri) throws RepositoryException {
        if (StringUtils.isEmpty((String)this.defaultBranchName)) {
            throw new RepositoryException("Default branch name may not be empty! " + GitRepositoryConnectorDescriptor.createDefaultBranchSuggestionMessage(gitBranchRefInfo));
        }
        if (!gitBranchRefInfo.containsRefForBranchName(this.defaultBranchName)) {
            throw new RepositoryException(String.format("The branch '%s' does not exist in the repository '%s'. %s", this.defaultBranchName, repositoryUri, GitRepositoryConnectorDescriptor.createDefaultBranchSuggestionMessage(gitBranchRefInfo)));
        }
    }

    private static String createDefaultBranchSuggestionMessage(GitBranchRefInfo gitBranchRefInfo) {
        List<String> branchNamesForHeadRef = gitBranchRefInfo.getBranchNamesMatchingHeadRef();
        if (branchNamesForHeadRef.isEmpty()) {
            return "Teamscale is unable to determine suggestions for the default branch. Git repository HEAD ref seems to be in an inconsistent state. When using a manually cloned Git please use the --mirror flag.";
        }
        return "Consider using one of these default branches which match the HEAD ref of the repository: " + StringUtils.concat(branchNamesForHeadRef, (String)", ");
    }

    @Override
    protected Predicate<String> validUriProtocol() {
        return urlProtocol -> Arrays.stream(EGitProtocol.values()).anyMatch(gitProtocol -> gitProtocol.getProtocol().equals(urlProtocol));
    }

    @Override
    protected Optional<String> fallbackUriProtocol() {
        return Optional.of(EGitProtocol.FILE.getProtocol());
    }

    public boolean isIncludeSubModules() {
        return this.includeSubModules;
    }

    public @Nullable String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public int getSubModuleRecursionDepth() {
        return this.subModuleRecursionDepth;
    }

    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return "";
    }

    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return "";
    }

    @Override
    public boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String preselectedUIBranchBeforeTransform) throws ConnectorValidationException {
        return ((GitBranchRefInfo)this.gitBranchRefInfo.get()).containsRefForBranchName(preselectedUIBranchBeforeTransform);
    }

    private GitBranchRefInfo getGitBranchRefInfo(URI uri) throws ConnectorValidationException {
        try {
            EGitProtocol gitProtocol = GitUtils.getProtocolFromUri(uri).orElseThrow(() -> new ConnectorValidationException("Parsed URL (%s) does not have a valid git protocol"));
            return switch (gitProtocol) {
                default -> throw new MatchException(null, null);
                case EGitProtocol.FILE -> this.getLocalRepositoryBranchRefInfoFromRepository(this.getLocalRepository(), uri);
                case EGitProtocol.SSH, EGitProtocol.HTTP -> this.getRemoteRepositoryBranchRefInfo(true, uri);
                case EGitProtocol.HTTPS -> this.getRemoteRepositoryBranchRefInfo(false, uri);
                case EGitProtocol.GIT -> throw new IllegalArgumentException("Unsupported protocol!");
            };
        }
        catch (Exception exception) {
            GitRepositoryConnectorDescriptor.handleExceptionDuringRepositoryValidation(exception, uri);
            return null;
        }
    }

    private Repository getLocalRepository() throws RepositoryException, ConnectorValidationException {
        return GitUtils.getExistingLocalRepository(this.getRepositoryUri());
    }

    private GitBranchRefInfo getLocalRepositoryBranchRefInfoFromRepository(Repository repository, URI uri) throws IOException, RepositoryException, ConnectorValidationException {
        List refs = repository.getRefDatabase().getRefs();
        if (refs.isEmpty()) {
            throw new RepositoryException(String.format("There are no branches in the repository %s. Is the repository empty?", uri));
        }
        if (this.includeGitLfs) {
            throw new ConnectorValidationException("Fetching files via LFS is not supported for local file repositories in Teamscale.");
        }
        return GitBranchRefInfo.create(refs);
    }

    private GitBranchRefInfo getRemoteRepositoryBranchRefInfo(boolean createLocalDummy, URI uri) throws Exception {
        try (LsRemoteGitProxy proxy = new LsRemoteGitProxy(this.connectorIdentifier, createLocalDummy);){
            ExternalCredentials credentials = this.resolveExternalCredentials();
            TeamscaleGitCredentialsProvider credentialsProvider = GitUtils.createCredentialsProvider(credentials.username, credentials.password, this.getPrivateKeyOption());
            GitBranchRefInfo gitBranchRefInfo = GitRepositoryConnectorDescriptor.getGitBranchRefInfo(uri, proxy, credentialsProvider);
            return gitBranchRefInfo;
        }
    }

    private @Nullable GitPrivateKeyOption getPrivateKeyOption() throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)this.privateKeyId)) {
            return null;
        }
        try {
            GitPrivateKeyOption privateKeyOption = (GitPrivateKeyOption)ServerOptionRegistry.getInstance().getServerMultiOption("git.privatekey", this.privateKeyId, GitPrivateKeyOption.class, (ServerOptionIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class));
            if (privateKeyOption == null) {
                throw new ConnectorValidationException("Could not find private key for id '" + this.privateKeyId + "'.");
            }
            return privateKeyOption;
        }
        catch (StorageException e) {
            throw new ConnectorValidationException("Failed to retrieve private key for id '" + this.privateKeyId + "'.", (Throwable)e);
        }
    }
}

