/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.Nullable;

public class GitRepositoryConnectorParameterStep {
    public static final String INCLUDE_GIT_LFS_PARAMETER = "include-git-lfs";
    public static final String INCLUDE_SUB_MODULES_PARAMETER = "include-sub-modules";
    public static final String CONNECTOR_TYPE_PARAMETER = "connector-type";
    public static final String SUB_MODULE_RECURSION_DEPTH_PARAMETER = "sub-module-recursion-depth";
    public static final String GIT_SSH_PRIVATE_KEY_PARAMETER = "git-ssh-private-key";
    public static final String IMPORTANT_BRANCH_PATTERN_PARAMETER = "important-branch-pattern";
    public static final String USER_REQUESTED_REF_SPECS_PARAMETER = "user-requested-ref-specs";
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectIndex projectIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AccessTokenIndex accessTokenIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PendingGarbageCollectionIndex pendingGarbageCollectionIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private GitRepositoryInfoIndex gitInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PostponedRollbackIndex postponedRollbackIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RepositoryRevisionIndex repositoryRevisionIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private CrossRepositoryMergeRequestSourceBranchesIndex crossRepoMergeRequestSourceBranchesIndex;
    @BranchingLayerAccess.Dynamic(value=GitBranchPointerIndex.class)
    private IBranchingLayer branchPointerIndexBranchingLayer;
    @StepParameter(value="include-git-lfs", optional=true)
    private boolean includeGitLfs = false;
    @StepParameter(value="include-sub-modules", optional=true)
    private boolean includeSubModules = false;
    @StepParameter(value="sub-module-recursion-depth", optional=true)
    private int subModuleRecursionDepth = 10;
    @StepParameter(value="git-ssh-private-key", optional=true)
    private @Nullable String sshKeyIdentifier;
    @StepParameter(value="important-branch-pattern", optional=true)
    private List<String> importantBranchPatterns = new ArrayList<String>();
    @StepParameter(value="user-requested-ref-specs", optional=true)
    private Set<String> userRequestedRefSpecs = new HashSet<String>();
    private Path cloneDirectory;
    @StepParameter(value="connector-type", optional=true)
    private @Nullable ERepositoryConnector connectorType;

    public static GitRepositoryConnectorBuilder builder(GitRepositoryConnectorParameterStep existingGitParameters) {
        GitRepositoryInfoIndex gitInfoIndex = Optional.ofNullable(existingGitParameters.gitInfoIndex).orElseGet(() -> new GitRepositoryInfoIndex((IStore)new InMemoryStore()));
        ServerOptionIndex serverOptionIndex = Optional.ofNullable(existingGitParameters.serverOptionIndex).orElseGet(() -> new ServerOptionIndex((IStore)new InMemoryStore()));
        AccessTokenIndex accessTokenIndex = Optional.ofNullable(existingGitParameters.accessTokenIndex).orElseGet(() -> new AccessTokenIndex((IStore)new InMemoryStore()));
        PostponedRollbackIndex postponedRollbackIndex = Optional.ofNullable(existingGitParameters.postponedRollbackIndex).orElseGet(() -> new PostponedRollbackIndex((IStore)new InMemoryStore()));
        RepositoryRevisionIndex repositoryRevisionIndex = Optional.ofNullable(existingGitParameters.repositoryRevisionIndex).orElseGet(RepositoryRevisionIndex::new);
        PendingGarbageCollectionIndex pendingGarbageCollectionIndex = Optional.ofNullable(existingGitParameters.pendingGarbageCollectionIndex).orElseGet(() -> new PendingGarbageCollectionIndex((IStore)new InMemoryStore()));
        CrossRepositoryMergeRequestSourceBranchesIndex crossRepoMergeRequestSourceBranchesIndex = Optional.ofNullable(existingGitParameters.crossRepoMergeRequestSourceBranchesIndex).orElseGet(() -> new CrossRepositoryMergeRequestSourceBranchesIndex((IStore)new InMemoryStore()));
        IBranchingLayer branchPointerIndexBranchingLayer = Optional.ofNullable(existingGitParameters.branchPointerIndexBranchingLayer).orElseGet(() -> new CommitLayeringBranchingLayer((IStore)new InMemoryStore(), null));
        GitIndices indices = new GitIndices(gitInfoIndex, serverOptionIndex, accessTokenIndex, postponedRollbackIndex, repositoryRevisionIndex, pendingGarbageCollectionIndex, crossRepoMergeRequestSourceBranchesIndex);
        GitRepositoryConnectorBuilder builder = GitRepositoryConnectorParameterStep.builder(indices, branchPointerIndexBranchingLayer).withIsIncludeSubModules(existingGitParameters.includeSubModules).withSubModuleRecursionDepth(existingGitParameters.subModuleRecursionDepth);
        if (existingGitParameters.sshKeyIdentifier != null) {
            builder.withSshKeyIdentifier(existingGitParameters.sshKeyIdentifier);
        }
        if (existingGitParameters.cloneDirectory != null) {
            builder.withCloneDirectory(existingGitParameters.cloneDirectory);
        }
        if (!existingGitParameters.importantBranchPatterns.isEmpty()) {
            builder.withImportantBranchPatterns(existingGitParameters.importantBranchPatterns);
        }
        if (!existingGitParameters.userRequestedRefSpecs.isEmpty()) {
            builder.withUserRequestedRefSpecs(existingGitParameters.userRequestedRefSpecs);
        }
        if (existingGitParameters.connectorType != null) {
            builder.withConnectorType(existingGitParameters.connectorType);
        }
        return builder;
    }

    public PatternList getImportantBranchPatterns() throws RepositoryException {
        try {
            return new PatternList((Collection)ConnectorUtils.validateAndReturnPatterns(this.importantBranchPatterns, (String)"Important Branches"));
        }
        catch (ConnectorValidationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected GitBranchPointerIndex openBranchPointerIndex() throws RepositoryException {
        try {
            return new GitBranchPointerIndex(this.branchPointerIndexBranchingLayer.openStore(HistoryAccessOption.readHeadWriteTimestamp((String)"d", (long)System.currentTimeMillis())));
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Path getRepositoryCloneDirectory() throws RepositoryException {
        if (this.cloneDirectory == null) {
            try {
                this.cloneDirectory = RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)this.getServerOptionIndex());
            }
            catch (StorageException e) {
                throw new RepositoryException("No working directory configured. Please configure one under Admin > Settings", (Throwable)e);
            }
        }
        return this.cloneDirectory;
    }

    public static GitRepositoryConnectorBuilder builder(GitIndices indices, IBranchingLayer branchPointerIndexBranchingLayer) {
        return new GitRepositoryConnectorBuilder(indices, branchPointerIndexBranchingLayer);
    }

    public ServerOptionIndex getServerOptionIndex() {
        return this.serverOptionIndex;
    }

    public ProjectIndex getProjectIndex() {
        return this.projectIndex;
    }

    public AccessTokenIndex getAccessTokenIndex() {
        return this.accessTokenIndex;
    }

    public GitRepositoryInfoIndex getGitInfoIndex() {
        return this.gitInfoIndex;
    }

    protected PostponedRollbackIndex getPostponedRollbackIndex() {
        return this.postponedRollbackIndex;
    }

    public RepositoryRevisionIndex getRepositoryRevisionIndex() {
        return this.repositoryRevisionIndex;
    }

    protected boolean isIncludeSubModules() {
        return this.includeSubModules;
    }

    protected boolean isIncludeGitLfs() {
        return this.includeGitLfs;
    }

    protected int getSubModuleRecursionDepth() {
        return this.subModuleRecursionDepth;
    }

    public @Nullable String getSshKeyIdentifier() {
        return this.sshKeyIdentifier;
    }

    public PendingGarbageCollectionIndex getPendingGarbageCollectionIndex() {
        return this.pendingGarbageCollectionIndex;
    }

    public Set<String> getUserRequestedRefSpecs() {
        return this.userRequestedRefSpecs;
    }

    public CrossRepositoryMergeRequestSourceBranchesIndex getCrossRepositoryMergeRequestSourceBranchesIndex() {
        return this.crossRepoMergeRequestSourceBranchesIndex;
    }

    public @Nullable ERepositoryConnector getConnectorType() {
        return this.connectorType;
    }

    public static class GitRepositoryConnectorBuilder {
        private final GitRepositoryConnectorParameterStep parameter = new GitRepositoryConnectorParameterStep();

        private GitRepositoryConnectorBuilder(GitIndices indices, IBranchingLayer branchPointerIndexBranchingLayer) {
            CCSMAssert.isNotNull((Object)branchPointerIndexBranchingLayer, (String)"Index layer for BranchPointerIndex must not be null.");
            this.parameter.serverOptionIndex = indices.serverOptionIndex();
            this.parameter.accessTokenIndex = indices.accessTokenIndex();
            this.parameter.gitInfoIndex = indices.gitInfoIndex();
            this.parameter.postponedRollbackIndex = indices.postponedRollbackIndex();
            this.parameter.pendingGarbageCollectionIndex = indices.pendingGarbageCollectionIndex();
            this.parameter.crossRepoMergeRequestSourceBranchesIndex = indices.crossRepositoryMergeRequestSourceBranchesIndex();
            this.parameter.branchPointerIndexBranchingLayer = branchPointerIndexBranchingLayer;
            this.parameter.repositoryRevisionIndex = indices.repositoryRevisionIndex();
        }

        public GitRepositoryConnectorBuilder withIsIncludeSubModules(boolean includeSubModules) {
            this.parameter.includeSubModules = includeSubModules;
            return this;
        }

        public GitRepositoryConnectorBuilder withSubModuleRecursionDepth(int subModuleRecursionDepth) {
            this.parameter.subModuleRecursionDepth = subModuleRecursionDepth;
            return this;
        }

        public GitRepositoryConnectorBuilder withSshKeyIdentifier(String sshKeyIdentifier) {
            this.parameter.sshKeyIdentifier = sshKeyIdentifier;
            return this;
        }

        public GitRepositoryConnectorBuilder withCloneDirectory(Path cloneDirectory) {
            this.parameter.cloneDirectory = cloneDirectory;
            return this;
        }

        public GitRepositoryConnectorBuilder withImportantBranchPatterns(List<String> importantBranchPatterns) {
            CCSMAssert.isTrue((boolean)this.parameter.importantBranchPatterns.isEmpty(), (String)"May only add important branch patterns once.");
            this.parameter.importantBranchPatterns.addAll(importantBranchPatterns);
            return this;
        }

        public GitRepositoryConnectorBuilder withUserRequestedRefSpecs(Set<String> userRequestedRefSpecs) {
            CCSMAssert.isTrue((boolean)this.parameter.userRequestedRefSpecs.isEmpty(), (String)"May only add user requested ref specs once.");
            this.parameter.userRequestedRefSpecs.addAll(userRequestedRefSpecs);
            return this;
        }

        public GitRepositoryConnectorBuilder withConnectorType(ERepositoryConnector connectorType) {
            this.parameter.connectorType = connectorType;
            return this;
        }

        public GitRepositoryConnectorParameterStep build() {
            CCSMAssert.isNotNull((Object)this.parameter.getConnectorType(), (String)"The connector type must be set.");
            return this.parameter;
        }
    }
}

