/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.shutdown.ShutdownLock;
import com.teamscale.core.shutdown.ShutdownManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.conqat.lib.commons.waiting.WaitSpec;
import org.conqat.lib.commons.waiting.WaitUtil;
import org.eclipse.jgit.lib.Repository;

public class GitWriteLockManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String INDEX_LOCK_FILE_NAME = "index.lock";
    private static final Duration MAX_LOCK_FILE_WAIT_TIME = Duration.ofMinutes(15L);
    private static final Map<Path, GitDirectoryLock> EXISTING_LOCKS = Collections.synchronizedMap(new HashMap());

    public static GitDirectoryLock lockGitRepositoryForWriting(Repository repository) throws RepositoryException {
        return GitWriteLockManager.lockGitDirectoryForWriting(repository.getDirectory().toPath());
    }

    public static GitDirectoryLock lockGitDirectoryForWriting(Path gitMetadataDirectory) throws RepositoryException {
        GitDirectoryLock lock = EXISTING_LOCKS.computeIfAbsent(gitMetadataDirectory, x -> new GitDirectoryLock());
        lock.lock();
        Path lockFile = gitMetadataDirectory.resolve(INDEX_LOCK_FILE_NAME);
        ((WaitSpec)((WaitSpec)((WaitSpec)WaitUtil.condition((IWaitCondition)IWaitCondition.of(() -> !Files.exists(lockFile, new LinkOption[0])).or(IWaitCondition.of(() -> ShutdownManager.getInstance().isShutdownStarted()))).timeout(MAX_LOCK_FILE_WAIT_TIME)).pollInterval(Duration.ofMillis(10L))).asWaitingFor("git index.lock file to be removed")).continueSilentlyOnTimeoutOrInterrupt().execute();
        if (Files.exists(lockFile, new LinkOption[0])) {
            GitWriteLockManager.cleanupStaleLockFile(lockFile, gitMetadataDirectory);
        }
        lock.beginNoShutdownRegion();
        return lock;
    }

    private static void cleanupStaleLockFile(Path lockFile, Path gitMetadataDirectory) {
        try {
            LOGGER.warn("Stale lock file {} detected after waiting {} minutes. Attempting to delete it to prevent further lock failures.", (Object)lockFile, (Object)MAX_LOCK_FILE_WAIT_TIME.toMinutes());
            Files.delete(lockFile);
            LOGGER.info("Successfully deleted stale lock file {} in repository {}.", (Object)lockFile, (Object)gitMetadataDirectory);
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete stale lock file {} in repository {}. Manual cleanup may be required.", (Object)lockFile, (Object)gitMetadataDirectory, (Object)e);
        }
    }

    public static final class GitDirectoryLock
    implements AutoCloseable {
        private final Lock delegate = new ReentrantLock();
        private final ShutdownLock shutdownLock = ShutdownManager.getInstance().obtainShutdownLock();
        private int reentrantLockCount;

        private void lock() {
            this.delegate.lock();
        }

        private void beginNoShutdownRegion() throws RepositoryException {
            boolean couldEnterNoShutdownRegion;
            if (this.reentrantLockCount == 0 && !(couldEnterNoShutdownRegion = this.shutdownLock.enterNoShutdownRegion())) {
                this.delegate.unlock();
                throw new RepositoryException("Teamscale is already shutting down");
            }
            ++this.reentrantLockCount;
        }

        public void unlock() {
            --this.reentrantLockCount;
            if (this.reentrantLockCount == 0) {
                this.shutdownLock.exitNoShutdownRegion();
            }
            this.delegate.unlock();
        }

        @Override
        public void close() {
            this.unlock();
        }
    }
}

