/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.autogc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.repository.git.autogc.GitGarbageCollectionMaintenanceTrigger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;

@ExportToTypeScript
@Option(id="repository.git.gc", name="Git Automatic Garbage Collection", type=EOptionType.SERVER, category=EOptionCategory.GIT)
@IndexValueClass(containedInBackup=true)
public class GitAutoGCOption
implements IOption {
    private static final long serialVersionUID = 1L;
    protected static final String OPTION_ID = "repository.git.gc";
    protected static final String OPTION_NAME = "Git Automatic Garbage Collection";
    @JsonProperty(value="enabled")
    @OptionFieldDescription(name="Enable automatic garbage collection. If enabled, please configure a scheduling interval as well.", description="Enable automatic garbage collection. If enabled, please configure a scheduling interval as well.")
    @ScheduleOption(triggerClass=GitGarbageCollectionMaintenanceTrigger.class)
    public boolean enabled = EFeatureToggle.ENABLE_GIT_AUTO_GC.isEnabled();
    @JsonProperty(value="schedule")
    @OptionFieldDescription(name="Defines when the Git garbage collection is scheduled. Has no effect if automatic garbage collection is disabled.")
    @ScheduleOption(triggerClass=GitGarbageCollectionMaintenanceTrigger.class)
    public String schedule = "@midnight";

    public static boolean isEnabled(GlobalStorageSystem globalStorageSystem) throws StorageException {
        GitAutoGCOption option = (GitAutoGCOption)ServerOptionRegistry.getInstance().getOption("server", OPTION_ID, null, GitAutoGCOption.class, (OptionIndexBase)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class));
        return option != null && option.enabled && !StringUtils.isEmpty((String)option.schedule);
    }

    @TestOnly
    public static void enableForTesting(GlobalStorageSystem globalStorageSystem) throws StorageException {
        GitAutoGCOption option = new GitAutoGCOption();
        option.schedule = "@midnight";
        option.enabled = true;
        ServerOptionRegistry.getInstance().putOption("server", OPTION_ID, null, (IOption)option, (OptionIndexBase)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class));
        CCSMAssert.isTrue((boolean)GitAutoGCOption.isEnabled(globalStorageSystem), (String)"Failed to enable Git Automatic Garbage Collection option for testing.");
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (this.enabled && StringUtils.isEmpty((String)this.schedule)) {
            return "Enabling automatic Git garbage collection has no effect without providing a schedule.";
        }
        return null;
    }
}

