/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestAnnotationUtils;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.comments.ReviewCommentResolutionReasonProvider;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitClient;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestProvider;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestDescriptionDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestStatusDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestThreadDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitStatusContextDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitThreadCommentDto;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;

public class AzureDevOpsGitMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<AzureDevOpsGitPullRequestDto, MergeRequestBuildJob> {
    private static final Logger LOGGER = LogManager.getLogger();
    private AzureDevOpsGitClient client;

    protected AzureDevOpsGitMergeRequestProvider createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        ExternalCredentials credentials = MergeRequestUpdateTriggerBase.extractCredentials(schedulingParameters.connector(), this.indexLayer.openGlobalStorageSystem());
        String repositoryPath = AzureDevOpsGitMergeRequestAnnotationTrigger.getRepositoryPath(schedulingParameters.connector());
        this.client = new AzureDevOpsGitClient(credentials, repositoryPath, StorageException::new, LOGGER);
        return new AzureDevOpsGitMergeRequestProvider(repositoryPath, this.client);
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteInlineCommentsAfterCommentLimitExceeded(input, comment -> CcpCommentUtils.isTeamscaleFindingsComment(comment.getContent()));
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteInlineCommentsAfterCommentLimitExceeded(input, comment -> CcpCommentUtils.isMarkdownTeamscaleTestGapComment(comment.getContent()));
    }

    private void deleteInlineCommentsAfterCommentLimitExceeded(MergeRequestAnnotationInput input, Predicate<AzureDevOpsGitThreadCommentDto> filter) throws ServiceCallException {
        String repositoryPath = this.client.getRepositoryPath();
        int pullRequestId = this.client.getPullRequest(input.mergeRequest.getId()).getId();
        List<AzureDevOpsGitPullRequestThreadDto> teamscaleThreads = this.client.getTeamscaleThreads(repositoryPath, pullRequestId);
        for (AzureDevOpsGitPullRequestThreadDto thread : teamscaleThreads) {
            if (thread.isResolved()) continue;
            List teamscaleComments = CollectionUtils.filter(thread.getComments(), filter);
            this.deleteInlineComments(repositoryPath, pullRequestId, thread, teamscaleComments, "The number of line comments exceeds the configured limit so that this comment is no longer updated and may be outdated.");
        }
    }

    private void deleteInlineComments(String repositoryPath, int pullRequestId, AzureDevOpsGitPullRequestThreadDto thread, List<AzureDevOpsGitThreadCommentDto> teamscaleComments, String resolutionMessage) throws ServiceCallException {
        for (AzureDevOpsGitThreadCommentDto teamscaleComment : teamscaleComments) {
            if (!AzureDevOpsGitMergeRequestAnnotationTrigger.hasReplies(teamscaleComment.getId(), thread.getComments())) {
                this.client.deletePullRequestComment(repositoryPath, pullRequestId, thread.getId(), teamscaleComment);
                continue;
            }
            this.resolvePullRequestThread(repositoryPath, pullRequestId, thread, "closed", resolutionMessage);
        }
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) throws ServiceCallException {
        AzureDevOpsGitPullRequestDto pullRequest = this.client.getPullRequest(input.mergeRequest.getId());
        String newDescription = MergeRequestAnnotationUtils.compileDescriptionWithLimitCommentWarning(commentLimitWarningExceededMessage, pullRequest.getDescription(), "[//]: # (Teamscale start)", "[//]: # (Teamscale end)", commentLimitWarningFormat);
        this.client.updatePullRequestDescription(this.client.getRepositoryPath(), pullRequest.getId(), new AzureDevOpsGitPullRequestDescriptionDto(newDescription));
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.INLINE_COMMENTS);
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) throws ServiceCallException, StorageException {
        AzureDevOpsGitPullRequestDto pullRequest = this.client.getPullRequest(input.mergeRequest.getId());
        MergeRequestAnnotationUtils.updateDescription(pullRequest.getDescription(), badgeAsMarkdown, "[//]: # (Teamscale start)", "[//]: # (Teamscale end)", AzureDevOpsGitMergeRequestAnnotationTrigger.isBadgeSetToTopPosition(schedulingParams.connector()), (ConsumerWithTwoExceptions<String, ServiceCallException, StorageException>)((ConsumerWithTwoExceptions)newDescription -> this.client.updatePullRequestDescription(this.client.getRepositoryPath(), pullRequest.getId(), new AzureDevOpsGitPullRequestDescriptionDto((String)newDescription))));
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        return this.postBuildStatus(findingsVotingInfo, schedulingParams.linkProvider(), input);
    }

    private VotingRecord.EVotingState postBuildStatus(FindingsVotingInfo findingsVotingInfo, TeamscaleCommitLinkProvider linkProvider, MergeRequestAnnotationInput input) throws ServiceCallException {
        long pullRequestId = input.mergeRequest.getId();
        int pullRequestIterationsCount = this.client.getPulLRequestIterationsCount(pullRequestId);
        AzureDevOpsGitPullRequestStatusDto pullRequestStatus = AzureDevOpsGitMergeRequestAnnotationTrigger.createPullRequestStatus(findingsVotingInfo, input.createMergeRequestDetailsLink(linkProvider), pullRequestIterationsCount);
        this.client.createPullRequestStatus(this.client.getRepositoryPath(), (int)input.mergeRequest.getId(), pullRequestStatus);
        return findingsVotingInfo.isPositiveVote() ? VotingRecord.EVotingState.VOTED_POSITIVE : VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    private static AzureDevOpsGitPullRequestStatusDto createPullRequestStatus(FindingsVotingInfo findingsVotingInfo, String targetUrl, int iterationsCount) {
        String state = findingsVotingInfo.isPositiveVote() ? "succeeded" : "failed";
        String description = findingsVotingInfo.getTitle();
        return new AzureDevOpsGitPullRequestStatusDto(state, description, new AzureDevOpsGitStatusContextDto("Teamscale", "teamscale-findings"), targetUrl, iterationsCount);
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) throws ServiceCallException {
        String repositoryPath = this.client.getRepositoryPath();
        int pullRequestId = (int)input.mergeRequest.getId();
        this.updatePullRequestThreads(reviewComments, repositoryPath, pullRequestId, input.sourceCommit);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        String repositoryPath = this.client.getRepositoryPath();
        int pullRequestId = (int)input.mergeRequest.getId();
        List<AzureDevOpsGitPullRequestThreadDto> existingThreads = this.client.getTeamscaleAggregatedTestGapThreads(repositoryPath, pullRequestId);
        for (AzureDevOpsGitPullRequestThreadDto thread : existingThreads) {
            if (thread.isResolved()) continue;
            this.deleteInlineComments(repositoryPath, pullRequestId, thread, thread.getComments(), "This comment is no longer valid and may be outdated.");
        }
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws ServiceCallException {
        this.client.createPullRequestThread(this.client.getRepositoryPath(), (int)pullRequestId, new AzureDevOpsGitPullRequestThreadDto(commentContent, null));
    }

    private static boolean hasReplies(int id, List<AzureDevOpsGitThreadCommentDto> teamscaleComments) {
        return teamscaleComments.stream().anyMatch(comment -> comment.getParentCommentId() == id);
    }

    private void updatePullRequestThreads(List<IReviewComment> reviewComments, String repositoryPath, int pullRequestId, CommitDescriptor sourceCommit) throws ServiceCallException {
        List<AzureDevOpsGitPullRequestThreadDto> teamscaleThreads = this.client.getTeamscaleThreads(repositoryPath, pullRequestId);
        HashMap<String, AzureDevOpsGitPullRequestThreadDto> findingsIdToThread = new HashMap<String, AzureDevOpsGitPullRequestThreadDto>();
        HashMap<String, AzureDevOpsGitPullRequestThreadDto> normalisedExistingTestGapComments = new HashMap<String, AzureDevOpsGitPullRequestThreadDto>();
        for (AzureDevOpsGitPullRequestThreadDto thread : teamscaleThreads) {
            String teamscaleComment = AzureDevOpsGitMergeRequestAnnotationTrigger.getFirstCommentContentOfTeamscaleThread(thread);
            Optional<String> findingsId = CcpCommentUtils.extractFindingIdFromComment(teamscaleComment);
            findingsId.ifPresent(s -> findingsIdToThread.put((String)s, thread));
            if (findingsId.isPresent()) continue;
            Optional<String> normalisedTestGapComment = CcpCommentUtils.extractNormalizedTestGapComment(teamscaleComment);
            normalisedTestGapComment.ifPresent(comment -> normalisedExistingTestGapComments.put((String)comment, thread));
        }
        for (AzureDevOpsGitPullRequestThreadDto newThread : this.createPullRequestThreads(reviewComments, repositoryPath, pullRequestId)) {
            this.updateOrCreatePullRequestThread(newThread, findingsIdToThread, normalisedExistingTestGapComments, repositoryPath, pullRequestId);
        }
        this.resolvePullRequestThreads(findingsIdToThread, normalisedExistingTestGapComments, sourceCommit, repositoryPath, pullRequestId);
    }

    private List<AzureDevOpsGitPullRequestThreadDto> createPullRequestThreads(List<IReviewComment> reviewComments, String repositoryPath, int pullRequestId) throws ServiceCallException {
        ArrayList<AzureDevOpsGitPullRequestThreadDto> threadsToBeAdded = new ArrayList<AzureDevOpsGitPullRequestThreadDto>();
        HashSet<String> pullRequestFiles = new HashSet<String>(this.client.getPullRequestFiles(repositoryPath, pullRequestId));
        Map<String, List<IReviewComment>> pathToFindings = reviewComments.stream().filter(comment -> pullRequestFiles.contains(comment.getLocation().getUniformPath())).collect(Collectors.groupingBy(commentProvider -> commentProvider.getLocation().getUniformPath()));
        pathToFindings.forEach((path, reviewCommentsForPath) -> threadsToBeAdded.addAll(AzureDevOpsGitMergeRequestAnnotationTrigger.getInlineCommentsForPath(path, reviewCommentsForPath)));
        return threadsToBeAdded;
    }

    private void updateOrCreatePullRequestThread(AzureDevOpsGitPullRequestThreadDto newThread, Map<String, AzureDevOpsGitPullRequestThreadDto> existingThreadsByFindingId, Map<String, AzureDevOpsGitPullRequestThreadDto> normalisedExistingTestGapComments, String repositoryPath, int pullRequestId) throws ServiceCallException {
        String newCommentContent = AzureDevOpsGitMergeRequestAnnotationTrigger.getFirstCommentContentOfTeamscaleThread(newThread);
        Optional<String> findingId = CcpCommentUtils.extractFindingIdFromComment(newCommentContent);
        if (findingId.isEmpty() || !existingThreadsByFindingId.containsKey(findingId.get())) {
            Optional<String> normalizedTestGapComment = CcpCommentUtils.extractNormalizedTestGapComment(newCommentContent);
            if (normalizedTestGapComment.isPresent() && normalisedExistingTestGapComments.remove(normalizedTestGapComment.get()) != null) {
                return;
            }
            this.client.createPullRequestThread(repositoryPath, pullRequestId, newThread);
            return;
        }
        AzureDevOpsGitPullRequestThreadDto existingThread = existingThreadsByFindingId.remove(findingId.get());
        if (existingThread.isResolved()) {
            return;
        }
        String existingCommentContent = AzureDevOpsGitMergeRequestAnnotationTrigger.getFirstCommentContentOfTeamscaleThread(existingThread);
        if (CcpCommentUtils.normalizeCommentText(newCommentContent).equals(CcpCommentUtils.normalizeCommentText(existingCommentContent))) {
            return;
        }
        AzureDevOpsGitThreadCommentDto existingTeamscaleComment = existingThread.getComments().getFirst();
        this.client.updateThreadComment(repositoryPath, pullRequestId, existingThread.getId(), existingTeamscaleComment.getId(), newCommentContent);
    }

    private void resolvePullRequestThreads(Map<String, AzureDevOpsGitPullRequestThreadDto> existingThreadsByFindingId, Map<String, AzureDevOpsGitPullRequestThreadDto> normalisedExistingTestGapComments, CommitDescriptor sourceCommit, String repositoryPath, int pullRequestId) throws ServiceCallException {
        try {
            ReviewCommentResolutionReasonProvider commentResolutionProvider = new ReviewCommentResolutionReasonProvider(this.createReviewCommentResolutionReasonParameters(sourceCommit));
            for (Map.Entry<String, AzureDevOpsGitPullRequestThreadDto> entry : existingThreadsByFindingId.entrySet()) {
                String findingId = entry.getKey();
                String message = commentResolutionProvider.getMarkdownText(findingId);
                this.resolvePullRequestThread(repositoryPath, pullRequestId, entry.getValue(), "fixed", message);
            }
            for (Map.Entry<String, AzureDevOpsGitPullRequestThreadDto> entry : normalisedExistingTestGapComments.entrySet()) {
                this.resolvePullRequestThread(repositoryPath, pullRequestId, entry.getValue(), "fixed", "The test gap was resolved by an update to the code or a new vote.");
            }
        }
        catch (StorageException e) {
            LOGGER.error("Resolving outdated pull request comments failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void resolvePullRequestThread(String repositoryPath, int pullRequestId, AzureDevOpsGitPullRequestThreadDto thread, String threadStatus, String message) throws ServiceCallException {
        if (thread.isResolved()) {
            return;
        }
        this.client.updatePullRequestThreadStatus(repositoryPath, pullRequestId, thread.getId(), threadStatus);
        AzureDevOpsGitThreadCommentDto comment = new AzureDevOpsGitThreadCommentDto(message);
        this.client.addCommentToPullRequestThread(repositoryPath, pullRequestId, thread.getId(), comment);
    }

    private static String getFirstCommentContentOfTeamscaleThread(AzureDevOpsGitPullRequestThreadDto thread) {
        CCSMAssert.isNotEmpty(thread.getComments(), (String)"A Teamscale thread must have at least one comment.");
        return thread.getComments().getFirst().getContent();
    }

    private static List<AzureDevOpsGitPullRequestThreadDto> getInlineCommentsForPath(String path, List<IReviewComment> reviewComments) {
        ArrayList<AzureDevOpsGitPullRequestThreadDto> fileComments = new ArrayList<AzureDevOpsGitPullRequestThreadDto>();
        Map<Integer, List<IReviewComment>> lineToFindingsMap = reviewComments.stream().collect(Collectors.groupingBy(IReviewComment::getStartLine));
        lineToFindingsMap.forEach((line, reviewCommentsForLine) -> {
            String text = CcpCommentUtils.createInlineCommentMarkdownContent(reviewCommentsForLine, line);
            fileComments.add(new AzureDevOpsGitPullRequestThreadDto(path, text, (int)line, 1, (int)line, 1));
        });
        return fileComments;
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.AZURE_DEVOPS_GIT;
    }
}

