/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitClient;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestDto;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AzureDevOpsGitMergeRequestProvider
extends MergeRequestProvider<AzureDevOpsGitPullRequestDto, MergeRequestBuildJob> {
    private static final String SOURCE_REF_CROSS_REPO_PREFIX = "refs/pull/";
    private static final String SOURCE_REF_HEADS_PREFIX = "refs/heads/";
    private final String repositoryName;
    private final AzureDevOpsGitClient client;

    public AzureDevOpsGitMergeRequestProvider(String repositoryName, AzureDevOpsGitClient client) {
        super(null, null);
        this.repositoryName = repositoryName;
        this.client = client;
    }

    @Override
    public List<AzureDevOpsGitPullRequestDto> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        return this.client.getActivePullRequests();
    }

    @Override
    public @Nullable AzureDevOpsGitPullRequestDto getPlatformMergeRequest(long id) throws ServiceCallException {
        return this.client.getPullRequest(id);
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(AzureDevOpsGitPullRequestDto pullRequest) {
        return new AzureDevOpsMergeRequestAdapter(this, pullRequest);
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest(@NonNull AzureDevOpsGitPullRequestDto pullRequest) {
        return pullRequest.getSourceBranch().startsWith(SOURCE_REF_CROSS_REPO_PREFIX);
    }

    @Override
    public String getRepositoryPath() {
        return this.repositoryName;
    }

    private class AzureDevOpsMergeRequestAdapter
    implements MergeRequestProvider.IMergeRequestAdapter {
        private final AzureDevOpsGitPullRequestDto pullRequest;
        final /* synthetic */ AzureDevOpsGitMergeRequestProvider this$0;

        private AzureDevOpsMergeRequestAdapter(AzureDevOpsGitMergeRequestProvider azureDevOpsGitMergeRequestProvider, AzureDevOpsGitPullRequestDto pullRequest) {
            AzureDevOpsGitMergeRequestProvider azureDevOpsGitMergeRequestProvider2 = azureDevOpsGitMergeRequestProvider;
            Objects.requireNonNull(azureDevOpsGitMergeRequestProvider2);
            this.this$0 = azureDevOpsGitMergeRequestProvider2;
            this.pullRequest = pullRequest;
        }

        @Override
        public MergeRequestIdentifier getIdentifier() {
            return new MergeRequestIdentifier(this.this$0.repositoryName, (long)this.pullRequest.getId());
        }

        @Override
        public EMergeRequestStatus getStatus() {
            if (this.pullRequest.isActive()) {
                return EMergeRequestStatus.OPEN;
            }
            if (this.pullRequest.isCompleted()) {
                return EMergeRequestStatus.MERGED;
            }
            return EMergeRequestStatus.OTHER;
        }

        @Override
        public String getTitle() {
            return this.pullRequest.getTitle();
        }

        @Override
        public String getSourceBranch() {
            return this.sanitizeBranchName(this.pullRequest.getSourceBranch());
        }

        @Override
        public String getCommit() {
            return this.pullRequest.getLastMergeSourceCommitId();
        }

        @Override
        public String getTargetBranch() {
            return this.sanitizeBranchName(this.pullRequest.getTargetBranch());
        }

        private String sanitizeBranchName(String refName) {
            return StringUtils.stripPrefix((String)refName, (String)AzureDevOpsGitMergeRequestProvider.SOURCE_REF_HEADS_PREFIX);
        }

        @Override
        public String getUrl() {
            return this.this$0.client.getPullRequestUrl(this.pullRequest.getId());
        }

        @Override
        public Long getCreatedAt() {
            return Instant.parse(this.pullRequest.getCreationDate()).toEpochMilli();
        }

        @Override
        public Long getUpdatedAt() {
            String headCommitDate = this.pullRequest.getHeadCommitDate();
            if (headCommitDate == null) {
                return this.getCreatedAt();
            }
            return Long.max(Instant.parse(headCommitDate).toEpochMilli(), this.getCreatedAt());
        }
    }
}

