/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitThreadCommentDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitThreadContextDto;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class AzureDevOpsGitPullRequestThreadDto {
    public static final String STATUS_FIXED = "fixed";
    public static final String STATUS_CLOSED = "closed";
    private static final String STATUS_ACTIVE = "active";
    private static final Set<String> RESOLVED_STATES = Set.of("fixed", "closed", "byDesign", "wontFix");
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="isDeleted")
    private boolean isDeleted;
    @JsonProperty(value="threadContext")
    private AzureDevOpsGitThreadContextDto threadContext;
    @JsonProperty(value="comments")
    private List<AzureDevOpsGitThreadCommentDto> comments;
    @JsonProperty(value="status")
    private final String status;

    @JsonCreator
    public AzureDevOpsGitPullRequestThreadDto(@JsonProperty(value="id") int id, @JsonProperty(value="isDeleted") boolean isDeleted, @JsonProperty(value="threadContext") AzureDevOpsGitThreadContextDto threadContext, @JsonProperty(value="comments") List<AzureDevOpsGitThreadCommentDto> comments, @JsonProperty(value="status") String status) {
        this.id = id;
        this.isDeleted = isDeleted;
        this.threadContext = threadContext;
        this.comments = comments;
        this.status = status;
    }

    public AzureDevOpsGitPullRequestThreadDto(String path, String comment, int startLine, int startColumn, int endLine, int endColumn) {
        this.threadContext = new AzureDevOpsGitThreadContextDto(path, startLine, startColumn, endLine, endColumn);
        this.comments = Collections.singletonList(new AzureDevOpsGitThreadCommentDto(comment));
        this.status = STATUS_ACTIVE;
    }

    public AzureDevOpsGitPullRequestThreadDto(String comment, AzureDevOpsGitThreadContextDto threadContext) {
        this.comments = Collections.singletonList(new AzureDevOpsGitThreadCommentDto(comment));
        this.threadContext = threadContext;
        this.status = STATUS_ACTIVE;
    }

    public AzureDevOpsGitPullRequestThreadDto(String status) {
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isResolved() {
        return RESOLVED_STATES.contains(this.status);
    }

    public AzureDevOpsGitThreadContextDto getThreadContext() {
        return this.threadContext;
    }

    public List<AzureDevOpsGitThreadCommentDto> getComments() {
        return CollectionUtils.filter(this.comments, comment -> !comment.isDeleted());
    }

    public String printThreadComments() {
        StringBuilder builder = new StringBuilder();
        this.comments.forEach(comment -> builder.append(comment.getContent()).append("\n"));
        return builder.toString();
    }
}

