/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.AppBasedGitRepositoryDataRetriever;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudUtils;
import com.teamscale.index.repository.git.bitbucket.cloud.CachingRepositoryFullNameProvider;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudClient;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.net.UrlUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class BitbucketCloudDataRetriever
extends AppBasedGitRepositoryDataRetriever<BitbucketCloudInstallationIndex.BitbucketInstallation> {
    private final GlobalStorageSystem globalStorage;
    private final Logger logger;

    public BitbucketCloudDataRetriever(@NonNull ServerOptionIndex serverOptionIndex, @NonNull AccessTokenIndex accessTokenIndex, @Nullable ProjectConfiguration projectConfiguration, @Nullable ConnectorConfiguration connectorConfiguration, @Nullable String username, @NonNull GlobalStorageSystem globalStorage, @NonNull Logger logger) {
        super(serverOptionIndex, accessTokenIndex, projectConfiguration, connectorConfiguration, username);
        this.globalStorage = globalStorage;
        this.logger = logger;
    }

    public BitbucketCloudDataRetriever(GlobalStorageSystem globalStorage, Logger logger) throws StorageException {
        this((ServerOptionIndex)globalStorage.openGlobalIndex(ServerOptionIndex.class), (AccessTokenIndex)globalStorage.openGlobalIndex(AccessTokenIndex.class), null, null, null, globalStorage, logger);
    }

    @Override
    protected void checkUserIsCollaborator(String username, String repositoryName) {
    }

    @Override
    protected Pair<String, String> getConnectorUsernameAndPassword() throws RepositoryException {
        return new Pair((Object)"x-token-auth", (Object)this.getInstallationToken());
    }

    @Override
    protected ExternalCredentials createExternalCredentials(URI repositoryUri) throws RepositoryException {
        return new ExternalCredentials("Dummy Credentials", repositoryUri.toString(), "x-token-auth", this.getInstallationToken());
    }

    private String getInstallationToken() throws RepositoryException {
        try {
            BitbucketCloudInstallationIndex.BitbucketInstallation appInstallation = (BitbucketCloudInstallationIndex.BitbucketInstallation)this.getInstallation();
            return BitbucketCloudUtils.getInstallationToken(this.getAccessTokenIndex(), appInstallation);
        }
        catch (ServiceCallException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    protected URI getRepositoryUri(String repositoryName, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        GitRepositoryManagementConnectorDescriptorBase.splitRepositoryPath(repositoryName, ProjectConfigurationException::new);
        BitbucketCloudInstallationIndex.BitbucketInstallation appInstallation = (BitbucketCloudInstallationIndex.BitbucketInstallation)this.getInstallation();
        try {
            BitbucketCloudClient client = new BitbucketCloudClient(appInstallation, this.getAccessTokenIndex(), this.logger);
            BitbucketCloudRepository repository = client.getInstallationRepository(PlatformRepositoryIdentifier.fromRepositoryPath(repositoryName));
            return UrlUtils.parseUri((String)BitbucketCloudUtils.getHttpCloneUrlFromResponse(repository));
        }
        catch (ServiceCallException | StorageException e) {
            throw new RepositoryException(e);
        }
        catch (URISyntaxException e) {
            throw new ProjectConfigurationException("Invalid repository uri: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected BitbucketCloudInstallationIndex.BitbucketInstallation init(String repositoryName, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        try {
            String repositoryUuidFullName = CachingRepositoryFullNameProvider.getRepositoryUuidFullName(repositoryName, this.globalStorage);
            Pair<String, String> workspaceAndRepositoryUuids = GitRepositoryManagementConnectorDescriptorBase.splitRepositoryPath(repositoryUuidFullName, ProjectConfigurationException::new);
            return BitbucketCloudRepositoryConnectorDescriptor.findInstallationForOrganizationOrUser((String)workspaceAndRepositoryUuids.getFirst(), this.globalStorage);
        }
        catch (ServiceCallException | StorageException e) {
            throw new ProjectConfigurationException(e);
        }
    }
}

