/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudUtils;
import java.net.URISyntaxException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.net.UrlUtils;

public class BitbucketCloudRepositoryConnector
extends GitRepositoryConnector {
    @StepParameter(value="repository-path")
    private String repositoryPath;

    public BitbucketCloudRepositoryConnector() {
    }

    public BitbucketCloudRepositoryConnector(BitbucketCloudRepositoryConnectorDescriptor connectorDescriptor, GitIndices gitIndices, IBranchingLayer branchPointerIndexBranchingLayer) throws ConnectorValidationException {
        super(connectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        this.repositoryPath = connectorDescriptor.getRepositoryPath();
    }

    @Override
    public GitRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        Pair<String, BitbucketCloudInstallationIndex.BitbucketInstallation> account = BitbucketCloudUtils.deserializeAccountIdentifier(this.accountIdentifier);
        try {
            String accessToken = BitbucketCloudUtils.getInstallationToken(this.gitParameters.getAccessTokenIndex(), (BitbucketCloudInstallationIndex.BitbucketInstallation)account.getSecond());
            return new GitRepositoryConnection(this.getBaseParameters(), this.gitParameters, new GitCredentials("x-token-auth", accessToken, UrlUtils.parseUri((String)((String)account.getFirst())), this.getPrivateKeyOption()), cancelable, true);
        }
        catch (ServiceCallException | URISyntaxException | StorageException e) {
            throw new RepositoryException(e);
        }
    }
}

