/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client;

import com.google.common.collect.Lists;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudClient;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudWorkspace;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequest;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReport;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReportAnnotation;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithException;

public class BitbucketCloudClientHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String REPORT_ID = "teamscale-insights";
    @StepParameter(value="repository-path")
    private String repositoryPath;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BitbucketCloudInstallationIndex installationIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AccessTokenIndex accessTokenIndex;
    private String apiUrl = null;
    private final SupplierWithException<BitbucketCloudClient, ServiceCallException> bitbucketClient = SupplierWithException.memoize(() -> {
        try {
            BitbucketCloudInstallationIndex.BitbucketInstallation installation = this.getBitbucketInstallation();
            if (this.apiUrl != null) {
                return new BitbucketCloudClient(this.apiUrl, installation, this.accessTokenIndex, LOGGER);
            }
            return new BitbucketCloudClient(installation, this.accessTokenIndex, LOGGER);
        }
        catch (StorageException e) {
            throw new ServiceCallException((Throwable)e);
        }
    });

    public BitbucketCloudClientHelper() {
    }

    public BitbucketCloudClientHelper(String repositoryPath, BitbucketCloudInstallationIndex installationIndex, AccessTokenIndex accessTokenIndex) {
        this.repositoryPath = repositoryPath;
        this.installationIndex = installationIndex;
        this.accessTokenIndex = accessTokenIndex;
    }

    public BitbucketCloudClientHelper(String apiUrl, String repositoryPath, BitbucketCloudInstallationIndex installationIndex, AccessTokenIndex accessTokenIndex) {
        this(repositoryPath, installationIndex, accessTokenIndex);
        this.apiUrl = apiUrl;
    }

    public BitbucketCloudPullRequest getPullRequest(long pullRequestId) throws ServiceCallException {
        return ((BitbucketCloudClient)this.bitbucketClient.get()).getPullRequest(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), pullRequestId);
    }

    public String getPullRequestUrl(long pullRequestId) {
        return BitbucketCloudClient.getPullRequestUrl(this.repositoryPath, pullRequestId);
    }

    public List<BitbucketCloudPullRequest> getAllPullRequests() throws ServiceCallException, StorageException, JsonSerializationException {
        return ((BitbucketCloudClient)this.bitbucketClient.get()).getAllOpenPullRequests(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath));
    }

    public String getFullCommitHash(String shortenedHash) throws ServiceCallException {
        return ((BitbucketCloudClient)this.bitbucketClient.get()).getFullCommitHash(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), shortenedHash);
    }

    private BitbucketCloudInstallationIndex.BitbucketInstallation getBitbucketInstallation() throws StorageException {
        String[] parts = this.repositoryPath.split("/");
        return this.installationIndex.getBitbucketInstallationForTeamOrUsername(parts[0]).orElseThrow(() -> new StorageException("No bitbucket installation found for repository: " + this.repositoryPath));
    }

    public void postNewCommitStatus(CommitStatus status, String commit) throws ServiceCallException {
        ((BitbucketCloudClient)this.bitbucketClient.get()).postCommitStatus(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), commit, status);
    }

    public void postAnnotations(String commit, List<BitbucketCloudCommitReportAnnotation> annotations) throws ServiceCallException {
        int maxAnnotationsPerBulkOperation = 100;
        List partitions = Lists.partition(annotations, (int)maxAnnotationsPerBulkOperation);
        for (List partition : partitions) {
            ((BitbucketCloudClient)this.bitbucketClient.get()).postReportAnnotations(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), commit, REPORT_ID, partition);
        }
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public BitbucketCloudCommitReport postCommitReport(String sourceHead, BitbucketCloudCommitReport report) throws ServiceCallException {
        return ((BitbucketCloudClient)this.bitbucketClient.get()).putCommitReport(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), sourceHead, REPORT_ID, report);
    }

    public BitbucketCloudPullRequest putUpdatePullRequest(BitbucketCloudPullRequest pullRequest) throws ServiceCallException {
        return ((BitbucketCloudClient)this.bitbucketClient.get()).putUpdatePullRequest(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), pullRequest);
    }

    public BitbucketCloudWorkspace getWorkspace(BitbucketCloudRepository repository) throws ServiceCallException {
        String[] parts = repository.getFullName().split("/");
        return ((BitbucketCloudClient)this.bitbucketClient.get()).getWorkspace(parts[0]);
    }

    public void deleteReport(String commit) throws ServiceCallException {
        ((BitbucketCloudClient)this.bitbucketClient.get()).deleteReport(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), commit, REPORT_ID);
    }

    public List<BitbucketCloudPullRequestComment> getAllPullRequestComments(long pullRequestId) throws ServiceCallException, JsonSerializationException {
        return ((BitbucketCloudClient)this.bitbucketClient.get()).getAllPullRequestComments(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), String.valueOf(pullRequestId));
    }

    public void postPullRequestComment(long pullRequestId, String commentContent) throws ServiceCallException {
        ((BitbucketCloudClient)this.bitbucketClient.get()).postPullRequestComment(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), pullRequestId, new BitbucketCloudPullRequestComment(commentContent));
    }

    public void deletePullRequestComment(long pullRequestId, long commentId) throws ServiceCallException {
        ((BitbucketCloudClient)this.bitbucketClient.get()).deletePullRequestComment(PlatformRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), pullRequestId, commentId);
    }
}

