/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client;

import com.atlassian.jwt.core.reader.JwtIssuerSharedSecretService;
import com.atlassian.jwt.core.reader.JwtIssuerValidator;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;

public class BitbucketCloudJwtValidator
implements JwtIssuerValidator,
JwtIssuerSharedSecretService {
    private final BitbucketCloudInstallationIndex installationIndex;

    public BitbucketCloudJwtValidator(BitbucketCloudInstallationIndex installationIndex) {
        this.installationIndex = installationIndex;
    }

    public String getSharedSecret(@NonNull String issuer) {
        Optional<BitbucketCloudInstallationIndex.BitbucketInstallation> installation;
        try {
            installation = this.installationIndex.getBitbucketInstallationForClientKey(issuer);
        }
        catch (StorageException e) {
            return null;
        }
        if (!installation.isPresent()) {
            return null;
        }
        return installation.get().getSharedSecret();
    }

    public boolean isValid(String issuer) {
        Optional<BitbucketCloudInstallationIndex.BitbucketInstallation> installation;
        try {
            installation = this.installationIndex.getBitbucketInstallationForClientKey(issuer);
        }
        catch (StorageException e) {
            return false;
        }
        return installation.isPresent();
    }
}

