/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightReport;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.TestGapVotingInfo;
import org.conqat.engine.index.shared.MergeRequestIdentifier;

final class BitbucketServerCodeInsightReportCreator {
    private final MergeRequestIdentifier mergeRequestIdentifier;
    private final String commitHash;
    private final TeamscaleProjectLinkProvider linkProvider;

    BitbucketServerCodeInsightReportCreator(MergeRequestIdentifier mergeRequestIdentifier, String commitHash, TeamscaleProjectLinkProvider linkProvider) {
        this.mergeRequestIdentifier = mergeRequestIdentifier;
        this.commitHash = commitHash;
        this.linkProvider = linkProvider;
    }

    BitbucketServerCodeInsightReportCreator(MergeRequest mergeRequest, TeamscaleProjectLinkProvider linkProvider) {
        this(mergeRequest.identifier, mergeRequest.sourceHead, linkProvider);
    }

    BitbucketServerCodeInsightReport createInProgressReport() {
        return new BitbucketServerCodeInsightReport(BitbucketServerCodeInsightReportCreator.getAnalysisInProgressText(this.commitHash), this.linkProvider, this.mergeRequestIdentifier, BitbucketServerCodeInsightReport.EResult.PASS);
    }

    static String getAnalysisInProgressText(String commitHash) {
        return "Teamscale analysis for commit " + commitHash + " is in progress. Results will be posted as soon as the analysis is complete.";
    }

    BitbucketServerCodeInsightReport createAnalysisSkippedReport(String reason) {
        return new BitbucketServerCodeInsightReport("Teamscale analysis for commit %s was skipped: %s".formatted(this.commitHash, reason), this.linkProvider, this.mergeRequestIdentifier, BitbucketServerCodeInsightReport.EResult.PASS);
    }

    BitbucketServerCodeInsightReport createAnalysisErrorReport(String reason) {
        return new BitbucketServerCodeInsightReport("Teamscale analysis for commit %s encountered an error: %s".formatted(this.commitHash, reason), this.linkProvider, this.mergeRequestIdentifier, BitbucketServerCodeInsightReport.EResult.PASS);
    }

    BitbucketServerCodeInsightReport createConcludedReport(ConnectorConfiguration connector, FindingsVotingInfo findingsVotingInfo, TestGapVotingInfo testGapVotingInfo, LineCoverageVotingInfo lineCoverageVotingInfo) {
        String reportDetails = BitbucketServerCodeInsightReportCreator.createConcludedReportDetails(this.commitHash, findingsVotingInfo, testGapVotingInfo, lineCoverageVotingInfo);
        BitbucketServerCodeInsightReport.EResult reportStatus = BitbucketServerCodeInsightReportCreator.computeReportStatus(connector, findingsVotingInfo, testGapVotingInfo, lineCoverageVotingInfo);
        return new BitbucketServerCodeInsightReport(reportDetails, this.linkProvider, this.mergeRequestIdentifier, reportStatus);
    }

    private static String createConcludedReportDetails(String commitHash, FindingsVotingInfo findingsVotingInfo, TestGapVotingInfo testGapVotingInfo, LineCoverageVotingInfo lineCoverageVotingInfo) {
        return "Teamscale finished analyzing commit " + commitHash + ".\n\n- Findings: " + findingsVotingInfo.toReadableDescription() + "\n- Test Gaps: " + testGapVotingInfo.toReadableDescription() + "\n- Line Coverage: " + lineCoverageVotingInfo.toReadableDescription();
    }

    private static BitbucketServerCodeInsightReport.EResult computeReportStatus(ConnectorConfiguration connector, FindingsVotingInfo findingsVotingInfo, TestGapVotingInfo testGapVotingInfo, LineCoverageVotingInfo lineCoverageVotingInfo) {
        if (CcpIntegrationFeatureEnablements.isVotingForFindingsEnabled(connector) && !findingsVotingInfo.isPositiveVote()) {
            return BitbucketServerCodeInsightReport.EResult.FAIL;
        }
        if (testGapVotingInfo.getVotingRequirementsCheckerResult().isRequirementsFulfilled() && !testGapVotingInfo.isPositiveVote()) {
            return BitbucketServerCodeInsightReport.EResult.FAIL;
        }
        if (lineCoverageVotingInfo.getVotingRequirementsCheckerResult().isRequirementsFulfilled() && !lineCoverageVotingInfo.isPositiveVote()) {
            return BitbucketServerCodeInsightReport.EResult.FAIL;
        }
        return BitbucketServerCodeInsightReport.EResult.PASS;
    }
}

