/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.base.IncludeExcludeStepParameter;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerChangeRetriever;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestProvider;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryIdentifier;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep
public class BitbucketServerMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<BitbucketServerMergeRequestProvider, BitbucketServerPullRequest> {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="repository-path")
    private String repositoryPath;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;
    @StepParameterObject(namePrefix="build-")
    private final IncludeExcludeStepParameter<IncludeExcludeRegexSupport> buildPatternSupport = new IncludeExcludeStepParameter<IncludeExcludeRegexSupport>(IncludeExcludeRegexSupport::new);

    @Override
    protected BitbucketServerMergeRequestProvider createMergeRequestProvider() throws StorageException {
        ExternalCredentials credentials = this.getExternalCredentials(this.accountIdentifier);
        BitbucketServerClient client = new BitbucketServerClient(credentials.uri, credentials.username, credentials.password, LOGGER);
        return new BitbucketServerMergeRequestProvider(BitbucketServerRepositoryIdentifier.fromRepositoryPath(this.repositoryPath), client, this.buildPatternSupport.get());
    }

    @Override
    protected String getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return BitbucketServerChangeRetriever.class;
    }
}

