/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfiguration;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.index.repository.base.RepositoryToTriggerMappingIndex;
import com.teamscale.index.repository.git.common.VoteSupportingGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.version.Version;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class GitRepositoryManagementConnectorDescriptorBase
extends VoteSupportingGitRepositoryConnectorDescriptorBase {
    public static final String REPOSITORY_PATH_OPTION_NAME = "Repository Path";
    public static final String INCLUDED_BUILD_JOBS_PARAMETER_NAME = "Included build jobs";
    public static final String EXCLUDED_BUILD_JOBS_PARAMETER_NAME = "Excluded build jobs";
    private static final String BUILD_POLLING_INTERVAL_PARAMETER_NAME = "Build polling interval";
    public static final String BUILD_INCLUDE_EXCLUDE_PATTERN = "build-";
    private static final String BUILD_EXCLUDE_PATTERN_PARAMETER = "build-exclude-pattern";
    private static final String BUILD_INCLUDE_PATTERN_PARAMETER = "build-include-pattern";
    private static final int DEFAULT_BUILD_POLLING_INTERVAL_SECONDS = 86400;
    private static final int DEFAULT_DISABLED_BUILD_POLLING_INTERVAL_SECONDS = Integer.MAX_VALUE;
    public static final int MERGE_REQUEST_POLLING_INTERVAL_SECONDS = Integer.getInteger("com.teamscale.mergerequest.polling_interval_seconds", 86400);
    @ConfigExposed(name="Included build jobs", description="Regular expressions describing the merge request build jobs to be included when voting. Build jobs will be matched case-sensitively. Patterns can be inserted in two ways:\n1. Multiple lines where each pattern is inserted in a new line, e.g.:\n    .*/unit-test/.*\n    .*/integration-test/.*\n2. Single line with patterns separated by a comma, e.g. .*/unit-test/.*, .*/integration-test/.*\nLines starting with '##' are ignored.", multilineText=true, changeRequiresReAnalysis=false)
    public final List<String> buildIncludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Excluded build jobs", description="Regular expressions describing the merge request build jobs to be excluded when voting. Build jobs will be matched case-sensitively. Patterns can be inserted in two ways:\n1. Multiple lines where each pattern is inserted in a new line, e.g.:\n    .*/ui-test/.*\n    .*/frontend-test/.*\n2. Single line with patterns separated by a comma, e.g. .*/ui-test/.*, .*/frontend-test/.*\nLines starting with '##' are ignored.", multilineText=true, changeRequiresReAnalysis=false)
    public final List<String> buildExcludePatterns = new ArrayList<String>();
    public static final int MERGE_REQUEST_LAST_UPDATE_PERIOD_SECONDS = Integer.getInteger("com.teamscale.merge-request.merge_requests_last_update_period_seconds", 86400);
    @ConfigExposed(name="Repository Path", description="The path to the repository in the code collaboration platform, e.g. 'cqse/teamscale-python-client' for GitHub or GitLab, or 'project/_git/repository' for Azure DevOps.", visibility=ConfigExposed.EConfigVisibility.DEFAULT, required=true, orderingHint=30)
    protected String repositoryPath;
    @ConfigExposed(name="Build polling interval", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Delay used for polling the merge requests' build jobs in seconds (default is 86400 seconds).", changeRequiresReAnalysis=false)
    public int buildPollingIntervalSeconds = this.getDefaultBuildPollingInterval();
    public static final String CRITICAL_CHANGE_BADGES_OPTION_NAME = "Badges for Critical Changes";
    private static final String CRITICAL_CHANGE_BADGES_DESCRIPTION = "Badges added to merge requests indicating that modifications in predefined critical code areas occurred.";
    @ConfigExposed(name="Badges for Critical Changes", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Badges added to merge requests indicating that modifications in predefined critical code areas occurred.")
    protected CriticalChangeBadgesConfiguration criticalChangeBadges = new CriticalChangeBadgesConfiguration();
    public static final String BUILD_JOB_POLLING_INTERVAL_PARAMETER = "build-job-polling-interval";

    protected GitRepositoryManagementConnectorDescriptorBase(ERepositoryConnector type) {
        super(type);
        this.pollingIntervalSeconds = 3600;
        this.hideOption("Path suffix");
        if (!this.supportsCloningViaSsh()) {
            this.hideOption("SSH Private Key ID");
        }
        if (!this.requiresBuildCompleteness()) {
            this.hideOption(INCLUDED_BUILD_JOBS_PARAMETER_NAME);
            this.hideOption(EXCLUDED_BUILD_JOBS_PARAMETER_NAME);
            this.hideOption(BUILD_POLLING_INTERVAL_PARAMETER_NAME);
        }
    }

    protected boolean supportsCloningViaSsh() {
        return false;
    }

    public static <X extends Exception> Pair<String, String> splitRepositoryPath(String repositoryPath, Function<String, X> exceptionFactory) throws X {
        String[] parts = repositoryPath.split("/", 2);
        if (parts.length < 2) {
            throw (Exception)exceptionFactory.apply("Invalid repository path. Expected path cannot be empty and must contain a slash!");
        }
        return Pair.createPair((Object)parts[0], (Object)parts[1]);
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        this.createPullRequestSynchronizer(triggerCreator);
    }

    @Override
    public void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) throws StorageException, ConnectorValidationException {
        super.storeConfigurationDataInternal(projectStorageSystem);
        ((RepositoryToTriggerMappingIndex)projectStorageSystem.openProjectIndex(RepositoryToTriggerMappingIndex.class, null)).insertMapping(this.getRepositoryPath(), this.changeRetrieverTriggerName);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        if (this.repositoryPath.startsWith("/")) {
            throw new ConnectorValidationException("Repository path must not start with '/'");
        }
        if (this.repositoryPath.endsWith("/")) {
            throw new ConnectorValidationException("Repository path must not end with '/'");
        }
        this.validateRegexPatterns();
        super.validate();
    }

    @VisibleForTesting
    void validateRegexPatterns() throws ConnectorValidationException {
        ConnectorUtils.validateAndReturnPatterns(this.buildIncludePatterns, (String)BUILD_INCLUDE_PATTERN_PARAMETER);
        ConnectorUtils.validateAndReturnPatterns(this.buildExcludePatterns, (String)BUILD_EXCLUDE_PATTERN_PARAMETER);
    }

    private void createPullRequestSynchronizer(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(this.getPullRequestSynchronizerClass());
        this.setPullRequestSynchronizerParameters(trigger);
        triggerCreator.createTrigger(trigger, this.connectorIdentifier);
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.setTriggerParameter("repository-path", this.repositoryPath);
    }

    protected void setPullRequestSynchronizerParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        trigger.setSchedulingParameter(ESchedulingParameter.PERIOD, (Object)this.getPullRequestSynchronizerPollingInterval());
        trigger.setTriggerParameter("repository-path", this.getRepositoryPath());
        trigger.setTriggerParameter("Connector Identifier", this.connectorIdentifier);
        trigger.resolveIndexNamePlaceholder("cross-repo-merge-request-source-branches-placeholder", CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(this.connectorIdentifier));
        trigger.setTriggerParameter(BUILD_JOB_POLLING_INTERVAL_PARAMETER, this.getBuildPollingIntervalSeconds());
        trigger.setTriggerParameter(BUILD_INCLUDE_PATTERN_PARAMETER, ITriggerParameter.of(this.buildIncludePatterns));
        trigger.setTriggerParameter(BUILD_EXCLUDE_PATTERN_PARAMETER, ITriggerParameter.of(this.buildExcludePatterns));
    }

    public int getDefaultBuildPollingInterval() {
        return 86400;
    }

    private int getBuildPollingIntervalSeconds() {
        if (!this.requiresBuildCompleteness()) {
            return Integer.MAX_VALUE;
        }
        return this.buildPollingIntervalSeconds;
    }

    private Duration getPullRequestSynchronizerPollingInterval() {
        return Duration.ofSeconds(Math.min(MERGE_REQUEST_POLLING_INTERVAL_SECONDS, this.getBuildPollingIntervalSeconds()));
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public abstract Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass();

    public static boolean isOutdatedServerVersion(Version minimumVersion, String currentVersion) {
        String[] splitVersion = currentVersion.split("\\.");
        Version serverVersion = new Version(Integer.parseInt(splitVersion[0]), Integer.parseInt(splitVersion[1]));
        return minimumVersion.compareTo(serverVersion) > 0;
    }

    protected boolean requiresBuildCompleteness() {
        return false;
    }
}

