/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import java.net.URI;
import java.net.URISyntaxException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.string.StringUtils;

public abstract class WebHookBasedGitRepositoryConnectorBase
extends GitRepositoryConnector {
    @StepParameter(value="repository-uri")
    private String repositoryUri;
    private ExternalCredentials externalAccountCredentials;

    protected WebHookBasedGitRepositoryConnectorBase() {
    }

    protected WebHookBasedGitRepositoryConnectorBase(WebHookBasedGitRepositoryConnectorDescriptorBase connectorDescriptor, GitIndices gitIndices, IBranchingLayer branchPointerIndexBranchingLayer) throws ConnectorValidationException {
        super(connectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        this.repositoryUri = connectorDescriptor.getRepositoryUri().toString();
    }

    @Override
    public GitRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        URI repositoryUri;
        this.externalAccountCredentials = this.getExternalCredentials();
        try {
            repositoryUri = new URI(this.repositoryUri);
        }
        catch (URISyntaxException e) {
            throw new RepositoryException((Throwable)e);
        }
        return new GitRepositoryConnection(this.getBaseParameters(), this.gitParameters, new GitCredentials(this.getUsername(), this.externalAccountCredentials.password, repositoryUri, this.getPrivateKeyOption()), cancelable, StringUtils.isEmpty((String)this.gitParameters.getSshKeyIdentifier()));
    }

    protected String getUsername() {
        return this.externalAccountCredentials.username;
    }
}

