/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common.voting_info;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfigurationEntry;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChange;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeLocation;
import com.teamscale.index.repository.git.common.AnnotationOutputDetailsCreator;
import com.teamscale.index.repository.git.common.voting_info.IAnnotationInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.string.StringUtils;

public class CriticalChangeAnnotationInfo
implements IAnnotationInfo {
    private final MergeRequestCriticalChange criticalChange;
    private final CommitDescriptor mergeBase;

    public CriticalChangeAnnotationInfo(MergeRequestCriticalChange criticalChange, CommitDescriptor mergeBase) {
        this.criticalChange = criticalChange;
        this.mergeBase = mergeBase;
    }

    public CriticalChangeBadgesConfigurationEntry getBadgeConfiguration() {
        return this.criticalChange.criticalChangeBadgeConfigurationEntry();
    }

    @Override
    public String getTitle() {
        int numberOfCriticalChanges = this.criticalChange.criticalChangeLocations().size();
        return "This pull request has " + numberOfCriticalChanges + StringUtils.pluralize((String)" critical change", (int)numberOfCriticalChanges);
    }

    @Override
    public String createAnnotationDetails(TeamscaleCommitLinkProvider linkProvider, int maxLength) {
        return new AnnotationOutputDetailsCreator<MergeRequestCriticalChangeLocation>("critical change", criticalChangeLocation -> this.createCriticalChangeDetailsLine((MergeRequestCriticalChangeLocation)criticalChangeLocation, linkProvider), maxLength).createWithCombinedItems(this.criticalChange.criticalChangeLocations(), CriticalChangeAnnotationInfo.createSectionTitle(this.criticalChange.criticalChangeBadgeConfigurationEntry()));
    }

    private static String createSectionTitle(CriticalChangeBadgesConfigurationEntry criticalChangeBadgeConfigurationEntry) {
        return criticalChangeBadgeConfigurationEntry.badgeTitle() + ": " + criticalChangeBadgeConfigurationEntry.badgeText();
    }

    private String createCriticalChangeDetailsLine(MergeRequestCriticalChangeLocation criticalChangeLocation, TeamscaleCommitLinkProvider linkProvider) {
        Object changeDetails = "";
        if (criticalChangeLocation.isMethodLocation()) {
            changeDetails = ": Change in method `" + criticalChangeLocation.getMethodName() + "`";
        }
        return "* %s%s [(view in Teamscale)](%s)\n".formatted(criticalChangeLocation.getUniformFilePath(), changeDetails, CriticalChangeAnnotationInfo.createLinkToCriticalChangeLocation(criticalChangeLocation, linkProvider, this.mergeBase));
    }

    private static String createLinkToCriticalChangeLocation(MergeRequestCriticalChangeLocation item, TeamscaleCommitLinkProvider linkProvider, CommitDescriptor mergeBase) {
        int rightLine = -1;
        if (item.isMethodLocation()) {
            rightLine = item.getMethodStartLine();
        }
        return linkProvider.createLinkToFileComparison(item.getOriginPath(), item.getUniformFilePath(), mergeBase, rightLine);
    }
}

