/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common.voting_info;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.testcoverage.LineCoverageChange;
import com.teamscale.index.repository.git.common.AnnotationOutputDetailsCreator;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfoWithRequirementsCheck;
import java.util.List;
import org.conqat.engine.index.shared.MergeRequestIdentifier;

public class LineCoverageVotingInfo
implements IVotingInfoWithRequirementsCheck {
    private final TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult;
    private final boolean hasCoverableLines;
    private final double coverage;
    private final double threshold;
    private final List<LineCoverageChange> lineCoverageChangesPerFile;
    private final MergeRequestIdentifier mergeRequestIdentifier;

    public LineCoverageVotingInfo(TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult, boolean hasCoverableLines, double coverage, double threshold, List<LineCoverageChange> lineCoverageChangesPerFile, MergeRequestIdentifier mergeRequestIdentifier) {
        this.votingRequirementsCheckerResult = votingRequirementsCheckerResult;
        this.hasCoverableLines = hasCoverableLines;
        this.coverage = coverage;
        this.threshold = threshold;
        this.lineCoverageChangesPerFile = lineCoverageChangesPerFile;
        this.mergeRequestIdentifier = mergeRequestIdentifier;
    }

    @Override
    public boolean isPositiveVote() {
        if (!this.hasCoverableLines) {
            return true;
        }
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return false;
        }
        return this.coverage >= this.threshold;
    }

    @Override
    public String toReadableDescription() {
        if (!this.hasCoverableLines) {
            return "This pull request contains no changes that can be covered by tests.";
        }
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return this.votingRequirementsCheckerResult.getFailureReason();
        }
        if (this.coverage >= this.threshold) {
            return "This pull request has a line coverage of %.2f%% and reaches the configured threshold of %.0f%%.".formatted(this.coverage, this.threshold);
        }
        return "This pull request does not reach the configured line coverage threshold of %.0f%%. Only %.2f%% of the added or changed code lines are covered by tests.".formatted(this.threshold, this.coverage);
    }

    @Override
    public String getTitle() {
        if (!this.hasCoverableLines) {
            return "No changes that can be covered by tests";
        }
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return this.votingRequirementsCheckerResult.getShortFailureReason();
        }
        if (this.coverage >= this.threshold) {
            return "Line coverage above threshold: %.2f%%".formatted(this.coverage);
        }
        return "Line coverage below threshold: %.2f%%".formatted(this.coverage);
    }

    @Override
    public String createAnnotationDetails(TeamscaleCommitLinkProvider linkProvider, int maxLength) {
        String itemName = "test coverage";
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return AnnotationOutputDetailsCreator.getNoDetailsText(itemName);
        }
        return new AnnotationOutputDetailsCreator<LineCoverageChange>(itemName, lineCoverageChange -> this.createLineCoverageDetailsLine((LineCoverageChange)lineCoverageChange, linkProvider), maxLength).createWithCombinedItems(this.lineCoverageChangesPerFile, "Line Coverage per File");
    }

    private String createLineCoverageDetailsLine(LineCoverageChange lineCoverageChange, TeamscaleCommitLinkProvider linkProvider) {
        return "* %s: %.2f%% [(view in Teamscale)](%s)\n".formatted(lineCoverageChange.uniformPath(), lineCoverageChange.coverageOfChanges() * 100.0, linkProvider.createMergeRequestTestCoverageDetailsLink(this.mergeRequestIdentifier.toString(), lineCoverageChange.uniformPath(), lineCoverageChange.originPath()));
    }

    public double getCoverage() {
        return this.coverage;
    }

    @Override
    public TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult getVotingRequirementsCheckerResult() {
        return this.votingRequirementsCheckerResult;
    }
}

