/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common.voting_info;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.repository.git.common.AnnotationOutputDetailsCreator;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfoWithRequirementsCheck;
import com.teamscale.index.repository.git.common.voting_info.VotingInfoWithSeverityLevelsBase;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.util.List;
import org.conqat.engine.index.shared.MergeRequestIdentifier;

public class TestGapVotingInfo
extends VotingInfoWithSeverityLevelsBase<AssessedTgaData.AssessedMethodData>
implements IVotingInfoWithRequirementsCheck {
    private final TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult;
    private final boolean hasChangedMethods;
    private final MergeRequestIdentifier mergeRequestIdentifier;

    public TestGapVotingInfo(TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult, boolean hasChangedMethods, List<AssessedTgaData.AssessedMethodData> untestedAddedMethods, List<AssessedTgaData.AssessedMethodData> untestedChangedMethods, boolean isIgnoreYellowTestGapsForVoting, MergeRequestIdentifier mergeRequestIdentifier) {
        super(untestedAddedMethods, untestedChangedMethods, isIgnoreYellowTestGapsForVoting);
        this.votingRequirementsCheckerResult = votingRequirementsCheckerResult;
        this.hasChangedMethods = hasChangedMethods;
        this.mergeRequestIdentifier = mergeRequestIdentifier;
    }

    @Override
    public boolean isPositiveVote() {
        if (!this.hasChangedMethods) {
            return true;
        }
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return false;
        }
        return super.isPositiveVote();
    }

    @Override
    public String getTitle() {
        if (!this.hasChangedMethods) {
            return "No changes relevant for TGA";
        }
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return this.votingRequirementsCheckerResult.getShortFailureReason();
        }
        return super.getTitle();
    }

    @Override
    public String toReadableDescription() {
        if (!this.hasChangedMethods) {
            return "This pull request contains no changes that are relevant for TGA.";
        }
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return this.votingRequirementsCheckerResult.getFailureReason();
        }
        return super.toReadableDescription();
    }

    @Override
    public String createAnnotationDetails(TeamscaleCommitLinkProvider linkProvider, int maxLength) {
        if (!this.votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return AnnotationOutputDetailsCreator.getNoDetailsText(this.itemName());
        }
        return super.createAnnotationDetails(linkProvider, maxLength);
    }

    @Override
    protected String createDetailsLine(AssessedTgaData.AssessedMethodData method, TeamscaleCommitLinkProvider linkProvider) {
        return "* %s: Untested %s method `%s` [(view in Teamscale)](%s)\n".formatted(method.getLocation().getUniformPath(), TestGapVotingInfo.getTestGapStateText(method.getTestGapState()), method.getMethodName(), linkProvider.createMergeRequestTestGapDetailsLink(method.getLocation().getUniformPath().toStringAsMigrationFrontier(), method.getLocation().getRegion().getStart(), method.getLocation().getRegion().getEnd(), this.mergeRequestIdentifier));
    }

    private static String getTestGapStateText(ETestGapState state) {
        return switch (state) {
            case ETestGapState.UNTESTED_ADDITION -> "added";
            case ETestGapState.UNTESTED_CHANGE -> "changed";
            default -> "";
        };
    }

    @Override
    public TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult getVotingRequirementsCheckerResult() {
        return this.votingRequirementsCheckerResult;
    }

    @Override
    protected String itemName() {
        return "test gap";
    }

    @Override
    protected String redItemName() {
        return "untested added method";
    }

    @Override
    protected String redItemsSectionTitle() {
        return "Test gaps in added methods";
    }

    @Override
    protected String yellowItemName() {
        return "untested changed method";
    }

    @Override
    protected String yellowItemsSectionTitle() {
        return "Test gaps in changed methods";
    }

    @Override
    protected String descriptionPrefix() {
        return "This pull request has ";
    }
}

