/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.cross_repo_merge_requests;

import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.LockableIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Index(name="cross-repo-merge-request-source-branches-placeholder", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={CrossRepositoryMergeRequestSourceBranch.class})
public class CrossRepositoryMergeRequestSourceBranchesIndex
extends LockableIndex<LockedIndexAccess>
implements IProjectIndexWithDynamicName {
    public static final String PLACEHOLDER = "cross-repo-merge-request-source-branches-placeholder";
    private static final String ACTIVE_BRANCHES_KEY_PREFIX = "active";
    private final ValueIndex<CrossRepositoryMergeRequestSourceBranch> branchesDelegateIndex;
    private String indexName;

    public CrossRepositoryMergeRequestSourceBranchesIndex(IStore store) {
        super(store);
        this.branchesDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, ACTIVE_BRANCHES_KEY_PREFIX));
    }

    public static String createIndexName(String connectorIdentifier) {
        return IProjectIndexWithDynamicName.createIndexName((String)connectorIdentifier, (String)PLACEHOLDER);
    }

    protected LockedIndexAccess getIndexAccess(IStore store) {
        return new LockedIndexAccess(this);
    }

    public void setName(String indexName) {
        this.indexName = indexName;
    }

    public String getName() {
        return this.indexName;
    }

    public class LockedIndexAccess {
        final /* synthetic */ CrossRepositoryMergeRequestSourceBranchesIndex this$0;

        private LockedIndexAccess(CrossRepositoryMergeRequestSourceBranchesIndex this$0) {
            CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryMergeRequestSourceBranchesIndex = this$0;
            Objects.requireNonNull(crossRepositoryMergeRequestSourceBranchesIndex);
            this.this$0 = crossRepositoryMergeRequestSourceBranchesIndex;
        }

        public UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> readAllBranches() throws StorageException {
            return this.this$0.branchesDelegateIndex.getAllEntries().getSecondList();
        }

        public boolean updateBranch(CrossRepositoryMergeRequestSourceBranch branch) throws StorageException {
            String key = LockedIndexAccess.getKey(branch);
            if (branch.equals(this.this$0.branchesDelegateIndex.getValue(key))) {
                return false;
            }
            this.this$0.branchesDelegateIndex.setValue(key, (Object)branch);
            return true;
        }

        public void removeBranch(CrossRepositoryMergeRequestSourceBranch branch) throws StorageException {
            String key = LockedIndexAccess.getKey(branch);
            this.this$0.branchesDelegateIndex.removeValue(key);
        }

        public void removeBranch(List<CrossRepositoryMergeRequestSourceBranch> branches) throws StorageException {
            List<String> keys = branches.stream().map(LockedIndexAccess::getKey).toList();
            this.this$0.branchesDelegateIndex.removeValues(keys);
        }

        private static String getKey(CrossRepositoryMergeRequestSourceBranch branch) {
            return branch.localBranchName();
        }
    }
}

