/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.common.SystemPropertyUtils;
import com.teamscale.index.repository.git.gerrit.GerritCommitInfo;
import com.teamscale.index.repository.git.gerrit.GerritPatchSetInfo;
import com.teamscale.index.repository.git.gerrit.GerritRestClient;
import com.teamscale.index.repository.git.gerrit.GerritUtils;
import com.teamscale.index.repository.git.gerrit.data.ChangeInfo;
import com.teamscale.index.repository.git.gerrit.data.RevisionInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GerritRepositoryConnection
extends GitRepositoryConnection {
    private static final String GERRIT_CHANGE_REF_PREFIX = "refs/changes/";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FULL_SCAN_INTERVAL_SYSTEM_PROPERTY = "com.teamscale.index.repository.git.gerrit.fullscaninterval.millis";
    private static final String SCAN_OVERLAP_SYSTEM_PROPERTY = "com.teamscale.index.repository.git.gerrit.scanoverlap.millis";
    private static final String LAST_GERRIT_UPDATE_KEY_NAME = "last-gerrit-update";
    private static final String LAST_GERRIT_FULL_SCAN_KEY_NAME = "last-gerrit-full-scan";
    private static final int MAX_GERRIT_FILES_CHANGED_PER_COMMIT = Integer.getInteger(EFeatureToggle.GERRIT_PATCHSET_MAX_FILES_CHANGED_FILTER_COUNT.getId(), 1000);
    private static final String TEAMSCALE_GIT_SECTION_NAME = "teamscale";
    private final long fullScanIntervalMillis;
    private final long scanOverlapMillis;
    private final URI gerritUrl;
    private final String userName;
    private final String password;
    private final ERestClientAuthenticationMode authenticationMode;
    private final int readTimeoutSeconds;
    private final String gerritProjectName;
    private Long potentialLastUpdateTimestamp = null;
    private Long potentialLastFullScanTimestamp = null;
    private Long minimumCreationTimestamp = null;
    private final boolean fetchMergedChanges;
    private final MergeRequestIndex mergeRequestIndex;

    public GerritRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, URI gerritUrl, String userName, String password, String gerritProjectName, MergeRequestIndex mergeRequestIndex, @Nullable GitPrivateKeyOption privateKeyOption, ERestClientAuthenticationMode authenticationMode, int readTimeoutSeconds, String minimumCreationDateOrRevision, boolean fetchMergedChanges, ICancelable cancelable) throws RepositoryException, URISyntaxException {
        super(connectorBaseParameterStep, gitParameterStep, new GitCredentials(userName, password, new URI(StringUtils.ensureEndsWith((String)gerritUrl.toString(), (String)"/") + gerritProjectName), privateKeyOption), cancelable);
        this.mergeRequestIndex = mergeRequestIndex;
        this.gerritUrl = gerritUrl;
        this.userName = userName;
        this.password = password;
        this.authenticationMode = authenticationMode;
        this.readTimeoutSeconds = readTimeoutSeconds;
        this.gerritProjectName = gerritProjectName;
        this.fetchMergedChanges = fetchMergedChanges;
        if (!StringUtils.isEmpty((String)minimumCreationDateOrRevision)) {
            this.minimumCreationTimestamp = this.getInstantForStartDateOrRevision(minimumCreationDateOrRevision, this.getAnalysisStart().toEpochMilli()).toEpochMilli();
        }
        this.getBranchPatternSupport().addIncludePattern("gerrit/.*");
        this.fullScanIntervalMillis = SystemPropertyUtils.getSystemPropertyAsLong(FULL_SCAN_INTERVAL_SYSTEM_PROPERTY, Long.MAX_VALUE);
        this.scanOverlapMillis = SystemPropertyUtils.getSystemPropertyAsLong(SCAN_OVERLAP_SYSTEM_PROPERTY, 0L);
    }

    @Override
    protected void updateLiveBranches(IChangeRetrieverCommitTree commitTree) throws RepositoryException {
        super.updateLiveBranches(commitTree);
        ArrayList liveBranchNames = new ArrayList(commitTree.getLiveBranchNames());
        commitTree.getAllKnownBranchNames().stream().filter(GerritUtils::isGerritBranch).forEach(liveBranchNames::add);
        commitTree.setLiveBranchNames(liveBranchNames);
    }

    @Override
    protected UnmodifiableSet<RefSpec> getRefSpecs() throws RepositoryException {
        long scanEndTimestamp;
        Instant startOfGetRefSpecs = Instant.now();
        long scanStartTimestamp = this.getScanStartTimestamp();
        if (scanStartTimestamp > (scanEndTimestamp = Math.min(System.currentTimeMillis(), this.getAnalysisEnd().toEpochMilli()))) {
            LOGGER.warn("Gerrit change scan start {} ({}) is after current scan end {} ({}). Skipping fetch of ref specs.", new Supplier[]{() -> DateTimeUtils.getUiFormattedDateString((long)scanStartTimestamp), () -> scanStartTimestamp, () -> DateTimeUtils.getUiFormattedDateString((long)scanEndTimestamp), () -> scanEndTimestamp});
            return CollectionUtils.emptySet();
        }
        try {
            String apiReadyProjectName = StringUtils.stripPrefix((String)this.gerritProjectName, (String)"a/");
            LOGGER.info("Fetching changes between {} ({}) and {} ({}) for Gerrit project: {}", new Supplier[]{() -> DateTimeUtils.getUiFormattedDateString((long)scanStartTimestamp), () -> scanStartTimestamp, () -> DateTimeUtils.getUiFormattedDateString((long)scanEndTimestamp), () -> scanEndTimestamp, () -> this.gerritProjectName});
            List<ChangeInfo> changesToPull = this.createGerritRestClient().getChangesBetween(apiReadyProjectName, scanStartTimestamp, scanEndTimestamp);
            LOGGER.debug(() -> "Fetched " + changesToPull.size() + " change infos from Gerrit: " + String.valueOf(changesToPull));
            this.updateStatusOfExistingMergeRequests(changesToPull, scanStartTimestamp);
            UnmodifiableSet<RefSpec> refSpecsToPull = this.calculateRefSpecs(this.filterIrrelevantChanges(changesToPull, scanStartTimestamp));
            LOGGER.debug(() -> "Pulling " + refSpecsToPull.size() + " ref specs from Gerrit: " + String.valueOf(refSpecsToPull));
            LOGGER.info(() -> "Searching for refs to fetch from Gerrit took: " + ChronoUnit.MILLIS.between(startOfGetRefSpecs, Instant.now()) + " ms");
            this.potentialLastUpdateTimestamp = scanEndTimestamp;
            return refSpecsToPull;
        }
        catch (ServiceCallException | IOException | StorageException e) {
            throw new RepositoryException("Problem extracting refs for project: " + this.gerritProjectName, e);
        }
    }

    private void updateStatusOfExistingMergeRequests(List<ChangeInfo> changesToPull, long scanStartTimestamp) throws StorageException {
        if (this.mergeRequestIndex == null) {
            return;
        }
        List updatedChangeInfos = CollectionUtils.filter(changesToPull, change -> change.getUpdatedInstant().isAfter(Instant.ofEpochMilli(scanStartTimestamp)));
        for (ChangeInfo updatedChange : updatedChangeInfos) {
            Optional<RevisionInfo> revisionInfo = updatedChange.getCurrentRevisionInfo();
            if (revisionInfo.isEmpty()) continue;
            List commitHashes = CollectionUtils.filterAndMap(updatedChange.getRevisions().entrySet(), entry -> ((RevisionInfo)revisionInfo.get()).equals(entry.getValue()), Map.Entry::getKey);
            for (String hash : commitHashes) {
                this.updateMergeRequestFromCommitHash(hash, updatedChange);
            }
        }
    }

    private void updateMergeRequestFromCommitHash(String hash, ChangeInfo updatedChange) throws StorageException {
        Optional<MergeRequest> mergeRequest = this.mergeRequestIndex.getMergeRequest(hash);
        if (mergeRequest.isEmpty()) {
            return;
        }
        if ("ABANDONED".equals(updatedChange.getStatus())) {
            this.mergeRequestIndex.removeMergeRequest(mergeRequest.get().identifier);
        } else if ("MERGED".equals(updatedChange.getStatus())) {
            MergeRequest updatedMergeRequest = new MergeRequest(mergeRequest.get().identifier, EMergeRequestStatus.MERGED, mergeRequest.get().title, new MergeRequestProvider.SourceBranchAndCommit(mergeRequest.get().sourceBranch, mergeRequest.get().sourceHead), mergeRequest.get().targetBranch, mergeRequest.get().url, mergeRequest.get().createdAt, mergeRequest.get().updatedAt);
            this.mergeRequestIndex.reAssociateMergeRequest(updatedMergeRequest);
        }
    }

    private List<ChangeInfo> filterIrrelevantChanges(List<ChangeInfo> changesToPull, long scanStartTimestamp) {
        Stream<Object> changesToFilter = changesToPull.stream();
        changesToFilter = changesToFilter.filter(change -> {
            if ("ABANDONED".equals(change.getStatus())) {
                return false;
            }
            if (this.fetchMergedChanges) {
                return true;
            }
            return !"MERGED".equals(change.getStatus());
        });
        if (this.minimumCreationTimestamp != null) {
            Instant minimumCreationInstant = Instant.ofEpochMilli(this.minimumCreationTimestamp);
            changesToFilter = changesToFilter.peek(change -> change.getRevisions().entrySet().removeIf(revisionInfoEntry -> ((RevisionInfo)revisionInfoEntry.getValue()).getCreationInstant().isBefore(minimumCreationInstant)));
        }
        Instant lastScanInstant = Instant.ofEpochMilli(scanStartTimestamp);
        changesToFilter = changesToFilter.filter(change -> {
            Optional<RevisionInfo> revisionInfo = change.getCurrentRevisionInfo();
            return revisionInfo.filter(info -> info.getCreationInstant().isAfter(lastScanInstant)).isPresent();
        });
        return changesToFilter.collect(Collectors.toList());
    }

    @Override
    protected void onSynchronizeSuccessful() throws RepositoryException {
        super.onSynchronizeSuccessful();
        if (this.potentialLastUpdateTimestamp == null) {
            return;
        }
        try {
            LOGGER.info("Persisting last update for Gerrit changes: {} ({})", new Supplier[]{() -> DateTimeUtils.getUiFormattedDateString((long)this.potentialLastUpdateTimestamp), () -> this.potentialLastUpdateTimestamp});
            StoredConfig config = this.repository.getRepository().getConfig();
            config.setLong(TEAMSCALE_GIT_SECTION_NAME, null, LAST_GERRIT_UPDATE_KEY_NAME, this.potentialLastUpdateTimestamp.longValue());
            if (this.potentialLastFullScanTimestamp != null) {
                config.setLong(TEAMSCALE_GIT_SECTION_NAME, null, LAST_GERRIT_FULL_SCAN_KEY_NAME, this.potentialLastFullScanTimestamp.longValue());
                LOGGER.debug("Periodic full scan at '{}' finished.", (Object)this.potentialLastFullScanTimestamp);
                this.potentialLastFullScanTimestamp = null;
            }
            config.save();
        }
        catch (IOException e) {
            throw new RepositoryException("Problem persisting config.", (Throwable)e);
        }
    }

    private UnmodifiableSet<RefSpec> calculateRefSpecs(List<ChangeInfo> changesToPull) throws IOException {
        LOGGER.debug(() -> "Computing ref specs based on  " + changesToPull.size() + " change infos from Gerrit: " + String.valueOf(changesToPull));
        HashSet<RefSpec> refSpecsToPull = new HashSet<RefSpec>();
        for (ChangeInfo changeInfo : changesToPull) {
            String bucketNumber = String.format("%02d", changeInfo.getNumber());
            bucketNumber = bucketNumber.substring(bucketNumber.length() - 2);
            String refBaseString = GERRIT_CHANGE_REF_PREFIX + bucketNumber + "/" + changeInfo.getNumber() + "/";
            Optional<RevisionInfo> revisionInfo = changeInfo.getCurrentRevisionInfo();
            if (revisionInfo.isEmpty()) continue;
            for (RevisionInfo revision : changeInfo.getRevisions().values()) {
                String patchSetRef = refBaseString + revision.getNumber();
                if (this.repository.getRepository().exactRef(patchSetRef) != null) continue;
                refSpecsToPull.add(new RefSpec("+" + patchSetRef + ":" + patchSetRef));
            }
        }
        return CollectionUtils.asUnmodifiable(refSpecsToPull);
    }

    @Override
    protected void processLabeledNodes(Map<String, CommitGraphNode> nodesByName, ICommitTree commitTree) throws RepositoryException, StorageException {
        Map<String, GerritCommitInfo> gitRevisionToGerritCommitInfo = this.createGitRevisionToGerritCommitInfo();
        LOGGER.debug(() -> "Git revision to Gerrit commit infos: " + String.valueOf(gitRevisionToGerritCommitInfo));
        DiffFormatter diffFormatter = GitUtils.createDiffFormatter(this.repository.getRepository());
        HashSet<String> precheckedCommits = this.gitParameters.getGitInfoIndex().getNodesSafeToProcess();
        int precheckedCommitsSize = precheckedCommits.size();
        for (CommitGraphNode commitGraphNode : nodesByName.values()) {
            String revision = GerritRepositoryConnection.extractGitRevision(commitGraphNode);
            GerritCommitInfo gerritCommitInfo = gitRevisionToGerritCommitInfo.get(revision);
            if (gerritCommitInfo == null) continue;
            if (commitGraphNode.hasBranchNameSet() && !GitRefUtils.isAnonymousBranchName((String)commitGraphNode.getBranchName())) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> revision;
                supplierArray[1] = commitGraphNode::getBranchName;
                LOGGER.debug("Revision {} already has a branch name set {}", supplierArray);
                continue;
            }
            if (!precheckedCommits.contains(gerritCommitInfo.getCommitHash())) {
                if (GerritRepositoryConnection.patchSetDiffTooLarge(diffFormatter, commitGraphNode)) continue;
                precheckedCommits.add(commitGraphNode.getName());
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> revision;
            supplierArray[1] = gerritCommitInfo::getBranchName;
            LOGGER.debug("Labeling revision {} to Gerrit branch {}", supplierArray);
            commitGraphNode.setBranchName(gerritCommitInfo.getBranchName());
        }
        if (precheckedCommitsSize < precheckedCommits.size()) {
            this.gitParameters.getGitInfoIndex().setNodesSafeToProcess(precheckedCommits);
        }
    }

    private static boolean patchSetDiffTooLarge(DiffFormatter differ, CommitGraphNode commitGraphNode) {
        if (commitGraphNode.getFirstParent() == null) {
            return false;
        }
        try {
            List diffs = differ.scan(commitGraphNode.getFirstParent().getCommit().getTree(), commitGraphNode.getCommit().getTree());
            if (diffs.size() > MAX_GERRIT_FILES_CHANGED_PER_COMMIT) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not calculate diff between '" + commitGraphNode.getFirstParent().getCommit().getName() + "' and '" + commitGraphNode.getCommit().getName() + "'. Skipping...");
            return true;
        }
        return false;
    }

    private @NonNull Map<String, GerritCommitInfo> createGitRevisionToGerritCommitInfo() throws RepositoryException {
        Collection<GerritCommitInfo> gerritCommitInfos = GerritUtils.parseChangeReferences(this.repository.getChangeRefs());
        return GerritRepositoryConnection.createGitRevisionToGerritCommitInfo(gerritCommitInfos);
    }

    @VisibleForTesting
    static @NonNull Map<String, GerritCommitInfo> createGitRevisionToGerritCommitInfo(Collection<GerritCommitInfo> gerritCommitInfos) {
        HashMap<String, GerritCommitInfo> gitRevisionToGerritCommitInfos = HashMap.newHashMap(gerritCommitInfos.size());
        for (GerritCommitInfo gerritCommitInfo : gerritCommitInfos) {
            String gitRevision = gerritCommitInfo.getCommitHash();
            gitRevisionToGerritCommitInfos.compute(gitRevision, (ignored, existingGerritCommitInfo) -> {
                if (existingGerritCommitInfo == null) {
                    return gerritCommitInfo;
                }
                LOGGER.warn("Picking Gerrit change with higher change or patch set number for revision {} with multiple Gerrit patch sets: {}, {}", (Object)gitRevision, existingGerritCommitInfo, (Object)gerritCommitInfo);
                if (existingGerritCommitInfo.changeNumber < gerritCommitInfo.changeNumber) {
                    return gerritCommitInfo;
                }
                if (existingGerritCommitInfo.changeNumber == gerritCommitInfo.changeNumber && existingGerritCommitInfo.patchSetNumber < gerritCommitInfo.patchSetNumber) {
                    return gerritCommitInfo;
                }
                return existingGerritCommitInfo;
            });
        }
        return gitRevisionToGerritCommitInfos;
    }

    @Override
    protected void filterExcludedBranches(Map<String, CommitGraphNode> nodesByName) throws StorageException {
        super.filterExcludedBranches(nodesByName);
        for (CommitGraphNode node : CollectionUtils.topSortNoCyclesExpected(nodesByName.values(), CommitGraphNode::getSuccessors)) {
            if (!node.isRoot() || !GerritUtils.isGerritBranch(node.getBranchName())) continue;
            LOGGER.warn("Removing node on Gerrit change branch which has no parent to avoid expensive import commits on Gerrit change branches: {}", (Object)node);
            node.remove();
            nodesByName.remove(node.getName());
        }
    }

    public List<String> getVirtualBranches() throws RepositoryException {
        return CollectionUtils.map(GerritUtils.parseChangeReferences(this.repository.getChangeRefs()), GerritPatchSetInfo::getBranchName);
    }

    private static String extractGitRevision(CommitGraphNode gitCommitGraphNode) {
        return gitCommitGraphNode.getName();
    }

    private GerritRestClient createGerritRestClient() {
        return new GerritRestClient(this.gerritUrl.toString(), this.userName, this.password, Collections.emptyList(), this.readTimeoutSeconds, this.authenticationMode);
    }

    private long getScanStartTimestamp() {
        long minimumStartTimestamp = this.getMinimumStartTimestamp();
        long scanStartTimestamp = GerritRepositoryConnection.getScanStartTimestamp(minimumStartTimestamp, this.getLastGerritUpdate(), this.getLastFullScan(), this.fullScanIntervalMillis, this.scanOverlapMillis);
        if (scanStartTimestamp == minimumStartTimestamp) {
            LOGGER.info("Starting full scan for Gerrit at '{}'.", (Object)minimumStartTimestamp);
            this.potentialLastFullScanTimestamp = minimumStartTimestamp;
        }
        return scanStartTimestamp;
    }

    @VisibleForTesting
    static long getScanStartTimestamp(long minimumStartTimestamp, long lastScanEndTimestamp, long lastFullScanEndTimestamp, long fullScanIntervalMillis, long scanOverlapMillis) {
        if (lastScanEndTimestamp - lastFullScanEndTimestamp > fullScanIntervalMillis) {
            return minimumStartTimestamp;
        }
        return Math.max(lastScanEndTimestamp - scanOverlapMillis, minimumStartTimestamp);
    }

    private long getMinimumStartTimestamp() {
        long analysisStartEpochMillis = this.getAnalysisStart().toEpochMilli();
        if (this.minimumCreationTimestamp == null) {
            return analysisStartEpochMillis;
        }
        return Math.max(analysisStartEpochMillis, this.minimumCreationTimestamp);
    }

    private long getLastGerritUpdate() {
        return this.repository.getRepository().getConfig().getLong(TEAMSCALE_GIT_SECTION_NAME, LAST_GERRIT_UPDATE_KEY_NAME, 0L);
    }

    private long getLastFullScan() {
        return this.repository.getRepository().getConfig().getLong(TEAMSCALE_GIT_SECTION_NAME, LAST_GERRIT_FULL_SCAN_KEY_NAME, 0L);
    }

    @Override
    protected boolean isExcluded(Ref ref, List<Ref> relevantCrossRepoRefs) {
        if (!ref.getName().isEmpty() && ref.getName().startsWith(GERRIT_CHANGE_REF_PREFIX)) {
            return false;
        }
        return super.isExcluded(ref, relevantCrossRepoRefs);
    }

    @Override
    public boolean isGerritConnection() {
        return true;
    }

    @Override
    public Long getGerritMinimalCreationTimestamp() {
        return this.minimumCreationTimestamp;
    }
}

