/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.merge_request.comments.ReviewCommentEngine;
import com.teamscale.index.merge_request.comments.ReviewCommentEngineParameters;
import com.teamscale.index.merge_request.comments.cluster.IFindingClusterStrategy;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.repository.git.gerrit.GerritIndexParameters;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

public abstract class GerritTriggerBase
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected BranchAnalysisStateIndex branchAnalysisStateIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex externalCredentialsIndex;
    @StepParameter(value="ignore-yellow-findings-for-votes")
    protected boolean isIgnoreYellowFindingsForVotesEnabled;
    @StepParameter(value="ignore-yellow-findings-for-comments")
    protected boolean isIgnoreYellowFindingsForCommentsEnabled;
    @StepParameter(value="enable-voting")
    protected boolean isVotingEnabled;
    @StepParameter(value="detailed-line-comments")
    protected boolean isDetailedLineCommentsEnabled;
    @StepParameter(value="comment-aggregation")
    private boolean isCommentAggregationEnabled;
    @StepParameter(value="review")
    protected String reviewLabel;
    @StepParameter(value="authentication-mode", optional=true)
    protected String restClientAuthenticationModeName;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected RepositoryOriginalPathIndex originalPathIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected VotingRecordIndex votingRecordIndex;
    @StepParameterObject
    protected GerritIndexParameters indexes;
    @StepParameterObject
    protected ReviewCommentEngineParameters reviewCommentTriggerParameters;
    private IncludeExcludeAntPatternSupport voteIncludeSupport;
    @StepParameter(value="vote-includes", optional=true)
    private final List<String> voteIncludePatterns;
    @StepParameter(value="vote-excludes", optional=true)
    private final List<String> voteExcludePatterns;

    public GerritTriggerBase() {
        GerritTriggerBase gerritTriggerBase = this;
        this.indexes = new GerritIndexParameters(() -> gerritTriggerBase.getParallelTaskExecutor());
        this.reviewCommentTriggerParameters = new ReviewCommentEngineParameters();
        this.voteIncludePatterns = new ArrayList<String>();
        this.voteExcludePatterns = new ArrayList<String>();
    }

    protected IncludeExcludeAntPatternSupport getVoteIncludeSupport() {
        if (this.voteIncludeSupport == null) {
            this.voteIncludeSupport = new IncludeExcludeAntPatternSupport(false, this.voteIncludePatterns, this.voteExcludePatterns);
        }
        return this.voteIncludeSupport;
    }

    protected ExternalCredentials getAccountCredentials() throws StorageException {
        ExternalCredentials credentials = this.externalCredentialsIndex.getExternalCredentials(this.accountIdentifier);
        if (credentials == null) {
            throw new StorageException("Account doesn't exist: " + this.accountIdentifier);
        }
        return credentials;
    }

    protected ReviewCommentEngine createReviewCommentEngine(CommitDescriptor commentedCommit, TeamscaleCommitLinkProvider linkProvider) {
        IFindingClusterStrategy findingClusterStrategy = IFindingClusterStrategy.create(this.isCommentAggregationEnabled, this.reviewCommentTriggerParameters);
        return ReviewCommentEngine.create(this.reviewCommentTriggerParameters, findingClusterStrategy, this.originalPathIndex.createView(this.accountIdentifier), commentedCommit, linkProvider);
    }

    protected boolean isVotingOrCommentingEnabled() {
        return this.isVotingEnabled || this.isDetailedLineCommentsEnabled;
    }
}

