/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.PostStepParameterInjection;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class GitHubClientHelper<X extends Exception> {
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private GitHubInstallationIndex installationIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AccessTokenIndex accessTokenIndex;
    @StepParameter(value="repository-path")
    private String repositoryPath;
    @StepParameter(value="github-url")
    private String gitHubServerUrl;
    private GitHubAppBasedRepositoryAccessHelper<X> repositoryAccessHelper;
    private final Function<String, X> exceptionFactory;
    private final Logger logger;

    public GitHubClientHelper(Function<String, X> exceptionFactory, Logger logger) {
        this.exceptionFactory = exceptionFactory;
        this.logger = logger;
    }

    public GitHubClientHelper(String repositoryPath, String gitHubServerUrl, GitHubInstallationIndex installationIndex, ServerOptionIndex serverOptionIndex, AccessTokenIndex accessTokenIndex, Function<String, X> exceptionFactory, Logger logger) {
        this.repositoryPath = repositoryPath;
        this.gitHubServerUrl = gitHubServerUrl;
        this.installationIndex = installationIndex;
        this.serverOptionIndex = serverOptionIndex;
        this.accessTokenIndex = accessTokenIndex;
        this.exceptionFactory = exceptionFactory;
        this.logger = logger;
        this.initRepositoryAccessHelper();
    }

    @PostStepParameterInjection
    private void initRepositoryAccessHelper() {
        this.repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<X>(this.gitHubServerUrl, this.repositoryPath, this.installationIndex, this.serverOptionIndex, this.accessTokenIndex, this.exceptionFactory, this.logger);
    }

    public String getInstallationToken() throws X, StorageException, ServiceCallException {
        return this.repositoryAccessHelper.getInstallationAccessToken();
    }

    public GitHubPullRequestClient createGitHubPullRequestClient() throws X, ServiceCallException, StorageException {
        return this.repositoryAccessHelper.createGitHubPullRequestClient();
    }
}

