/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChange;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.voting_info.CriticalChangeAnnotationInfo;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRunBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GitHubCriticalChangeCheckRunCreator {
    public static List<CheckRunBuilder> initCriticalChangeCheckRuns(String contextIdentifier, MergeRequestAnnotationInput input, CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        if (input.criticalChangeInfo == null || input.criticalChangeInfo.criticalChanges().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CheckRunBuilder> criticalChangeCheckRuns = new ArrayList<CheckRunBuilder>();
        String revision = input.mergeRequest.sourceHead;
        String mergeRequestDetailsLink = input.createMergeRequestDetailsLink(schedulingParams.linkProvider());
        for (MergeRequestCriticalChange criticalChange : input.criticalChangeInfo.criticalChanges()) {
            CriticalChangeAnnotationInfo criticalChangeInfo = new CriticalChangeAnnotationInfo(criticalChange, input.mergeBase.getMergeBase());
            String markdownBadge = input.buildCriticalChangeBadgeAsMarkdown(criticalChangeInfo.getBadgeConfiguration(), (TeamscaleProjectLinkProvider)schedulingParams.linkProvider());
            CheckRunBuilder checkRunBuilder = CheckRun.builder(criticalChangeInfo.getBadgeConfiguration(), contextIdentifier, revision, mergeRequestDetailsLink).withConclusion(CheckRun.Conclusion.NEUTRAL).withOutputTitle(criticalChangeInfo.getTitle()).withOutputText(criticalChangeInfo.createAnnotationDetails(schedulingParams.linkProvider(), 64000)).withMarkdownBadge(markdownBadge);
            criticalChangeCheckRuns.add(checkRunBuilder);
        }
        return criticalChangeCheckRuns;
    }
}

